/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.idea.streaming.core.LayoutNode;
import com.android.tools.idea.streaming.core.LeafNode;
import com.android.tools.idea.streaming.core.PartitionGenerator;
import com.android.tools.idea.streaming.core.SplitNode;
import com.android.tools.idea.streaming.core.SplitType;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001:\u0003\"#$B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\bH\u0002\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00042\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\bH\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00182\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\bH\u0002\u00a2\u0006\u0002\u0010!R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer;", "", "rectangleSizes", "", "Ljava/awt/Dimension;", "<init>", "(Ljava/util/List;)V", "levels", "", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LevelParams;", "[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LevelParams;", "nodesArraySize", "", "childrenOffsetByParentOffset", "", "maxChildrenByOffset", "optimize", "Lcom/android/tools/idea/streaming/core/LayoutNode;", "availableSpace", "populateLevelParameters", "numLevels", "(I)[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LevelParams;", "buildLayoutTree", "optimizationNode", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "optimizationNodes", "(Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;)Lcom/android/tools/idea/streaming/core/LayoutNode;", "calculateScale", "", "layoutNodes", "(Ljava/awt/Dimension;[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;)D", "calculateSize", "node", "(Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;)Ljava/awt/Dimension;", "LayoutGenerator", "Node", "LevelParams", "intellij.android.streaming"})
final class LayoutOptimizer {
    @NotNull
    private final List<Dimension> rectangleSizes;
    @NotNull
    private final LevelParams[] levels;
    private final int nodesArraySize;
    @NotNull
    private final int[] childrenOffsetByParentOffset;
    @NotNull
    private final int[] maxChildrenByOffset;

    public LayoutOptimizer(@NotNull List<? extends Dimension> rectangleSizes) {
        int n;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        Intrinsics.checkNotNullParameter(rectangleSizes, (String)"rectangleSizes");
        this.rectangleSizes = rectangleSizes;
        this.levels = this.populateLevelParameters(this.rectangleSizes.size());
        this.nodesArraySize = ((LevelParams)ArraysKt.last((Object[])this.levels)).getOffset() + ((LevelParams)ArraysKt.last((Object[])this.levels)).getSize();
        int n5 = ((LevelParams)ArraysKt.last((Object[])this.levels)).getOffset();
        int[] nArray2 = new int[n5];
        LayoutOptimizer layoutOptimizer = this;
        for (n4 = 0; n4 < n5; ++n4) {
            LevelParams level;
            int i;
            int multiplier;
            block5: {
                n2 = n3 = n4;
                nArray = nArray2;
                multiplier = 1;
                int n6 = this.levels.length;
                for (i = 1; i < n6; ++i) {
                    level = this.levels[i];
                    if (n3 >= level.getOffset()) {
                        multiplier = level.getMaxChildren();
                        continue;
                    }
                    break block5;
                }
                throw new AssertionError((Object)"Internal error");
            }
            n = level.getOffset() + (n3 - this.levels[i - 1].getOffset()) * multiplier;
            nArray[n2] = n;
        }
        layoutOptimizer.childrenOffsetByParentOffset = nArray2;
        n5 = this.nodesArraySize;
        nArray2 = new int[n5];
        layoutOptimizer = this;
        for (n4 = 0; n4 < n5; ++n4) {
            block6: {
                n2 = n3 = n4;
                nArray = nArray2;
                int n7 = this.levels.length;
                for (int i = 1; i < n7; ++i) {
                    if (n3 >= this.levels[i].getOffset()) continue;
                    n = this.levels[i - 1].getMaxChildren();
                    break block6;
                }
                n = ((LevelParams)ArraysKt.last((Object[])this.levels)).getMaxChildren();
            }
            nArray[n2] = n;
        }
        layoutOptimizer.maxChildrenByOffset = nArray2;
    }

    @NotNull
    public final LayoutNode optimize(@NotNull Dimension availableSpace) {
        Intrinsics.checkNotNullParameter((Object)availableSpace, (String)"availableSpace");
        int n = 0;
        int n2 = this.rectangleSizes.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        int[] indices = nArray;
        n2 = 0;
        int n4 = this.nodesArraySize;
        Object[] objectArray = new Node[n4];
        while (n2 < n4) {
            int n5 = n2++;
            objectArray[n5] = null;
        }
        Object[] currentLayout = objectArray;
        n4 = 0;
        int n6 = this.nodesArraySize;
        Object[] objectArray2 = new Node[n6];
        while (n4 < n6) {
            int n7 = n4++;
            objectArray2[n7] = null;
        }
        Object[] bestLayout = objectArray2;
        double bestScale = -1.0;
        LayoutGenerator layoutGenerator = new LayoutGenerator(indices, null, 0, (Node[])currentLayout);
        while (layoutGenerator.next()) {
            double scale = this.calculateScale(availableSpace, (Node[])currentLayout);
            if (!(bestScale < scale)) continue;
            bestScale = scale;
            ArraysKt.copyInto$default((Object[])currentLayout, (Object[])bestLayout, (int)0, (int)0, (int)0, (int)14, null);
        }
        Node node = bestLayout[0];
        Intrinsics.checkNotNull((Object)node);
        return this.buildLayoutTree(node, (Node[])bestLayout);
    }

    private final LevelParams[] populateLevelParameters(int numLevels) {
        LevelParams params2;
        LevelParams[] levelParams = new LevelParams[numLevels];
        levelParams[0] = params2 = new LevelParams(0, 1, numLevels);
        for (int level = 1; level < numLevels; ++level) {
            int maxChildren = params2.getMaxChildren() > 2 ? params2.getMaxChildren() - 1 : 0;
            levelParams[level] = params2 = new LevelParams(params2.getOffset() + params2.getSize(), params2.getSize() * params2.getMaxChildren(), maxChildren);
        }
        return levelParams;
    }

    private final LayoutNode buildLayoutTree(Node optimizationNode, Node[] optimizationNodes) {
        if (optimizationNode instanceof Node.Leaf) {
            return new LeafNode(((Node.Leaf)optimizationNode).getRectangleIndex(), this.rectangleSizes.get(((Node.Leaf)optimizationNode).getRectangleIndex()));
        }
        Intrinsics.checkNotNull((Object)optimizationNode, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.core.LayoutOptimizer.Node.Split");
        Node.Split cfr_ignored_0 = (Node.Split)optimizationNode;
        int childOffset = this.childrenOffsetByParentOffset[optimizationNode.getOffset()];
        Node node = optimizationNodes[childOffset++];
        Intrinsics.checkNotNull((Object)node);
        LayoutNode node2 = this.buildLayoutTree(node, optimizationNodes);
        int n = ((Node.Split)optimizationNode).getChildrenCount();
        for (int i = 1; i < n; ++i) {
            Node node3 = optimizationNodes[childOffset++];
            Intrinsics.checkNotNull((Object)node3);
            LayoutNode nextNode = this.buildLayoutTree(node3, optimizationNodes);
            node2 = new SplitNode(((Node.Split)optimizationNode).getSplitType(), node2, nextNode);
        }
        return node2;
    }

    private final double calculateScale(Dimension availableSpace, Node[] layoutNodes) {
        Node node = layoutNodes[0];
        Intrinsics.checkNotNull((Object)node);
        Dimension size = this.calculateSize(node, layoutNodes);
        return Math.min(availableSpace.getWidth() / (double)size.width, availableSpace.getHeight() / (double)size.height);
    }

    private final Dimension calculateSize(Node node, Node[] layoutNodes) {
        if (node instanceof Node.Leaf) {
            return this.rectangleSizes.get(((Node.Leaf)node).getRectangleIndex());
        }
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.core.LayoutOptimizer.Node.Split");
        Node.Split cfr_ignored_0 = (Node.Split)node;
        int width = 0;
        int height = 0;
        int childOffset = this.childrenOffsetByParentOffset[node.getOffset()];
        int n = ((Node.Split)node).getChildrenCount();
        block4: for (int i = 0; i < n; ++i) {
            Node node2 = layoutNodes[childOffset++];
            Intrinsics.checkNotNull((Object)node2);
            Dimension childSize = this.calculateSize(node2, layoutNodes);
            switch (WhenMappings.$EnumSwitchMapping$0[((Node.Split)node).getSplitType().ordinal()]) {
                case 1: {
                    width += childSize.width;
                    height = RangesKt.coerceAtLeast((int)height, (int)childSize.height);
                    continue block4;
                }
                case 2: {
                    width = RangesKt.coerceAtLeast((int)width, (int)childSize.width);
                    height += childSize.height;
                    continue block4;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return new Dimension(width, height);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J,\u0010/\u001a\u0002H0\"\u0004\b\u0000\u00100*\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H0012\u0006\u00102\u001a\u00020\u0007H\u0082\u0002\u00a2\u0006\u0002\u00103R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010#\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020$0\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00064"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LayoutGenerator;", "", "indices", "", "splitTypeToAvoid", "Lcom/android/tools/idea/streaming/core/SplitType;", "offset", "", "storage", "", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "<init>", "(Lcom/android/tools/idea/streaming/core/LayoutOptimizer;[ILcom/android/tools/idea/streaming/core/SplitType;I[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;)V", "getIndices", "()[I", "getOffset", "()I", "getStorage", "()[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "splitTypeIterator", "", "getSplitTypeIterator", "()Ljava/util/Iterator;", "splitType", "getSplitType", "()Lcom/android/tools/idea/streaming/core/SplitType;", "setSplitType", "(Lcom/android/tools/idea/streaming/core/SplitType;)V", "partitionGenerator", "Lcom/android/tools/idea/streaming/core/PartitionGenerator;", "getPartitionGenerator", "()Lcom/android/tools/idea/streaming/core/PartitionGenerator;", "setPartitionGenerator", "(Lcom/android/tools/idea/streaming/core/PartitionGenerator;)V", "childGenerators", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer;", "getChildGenerators", "()[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LayoutGenerator;", "setChildGenerators", "([Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LayoutGenerator;)V", "[Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LayoutGenerator;", "next", "", "clearDescendants", "", "createSplitTypeIterator", "get", "T", "Lkotlin/Pair;", "i", "(Lkotlin/Pair;I)Ljava/lang/Object;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nMultiDisplayLayoutOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiDisplayLayoutOptimizer.kt\ncom/android/tools/idea/streaming/core/LayoutOptimizer$LayoutGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1#2:358\n*E\n"})
    private final class LayoutGenerator {
        @NotNull
        private final int[] indices;
        private final int offset;
        @NotNull
        private final Node[] storage;
        @NotNull
        private final Iterator<SplitType> splitTypeIterator;
        @NotNull
        private SplitType splitType;
        @NotNull
        private PartitionGenerator partitionGenerator;
        @NotNull
        private LayoutGenerator[] childGenerators;

        public LayoutGenerator(@Nullable int[] indices, SplitType splitTypeToAvoid, @NotNull int offset, Node[] storage) {
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.indices = indices;
            this.offset = offset;
            this.storage = storage;
            this.splitTypeIterator = this.createSplitTypeIterator(splitTypeToAvoid);
            this.splitType = this.splitTypeIterator.next();
            this.partitionGenerator = new PartitionGenerator(this.indices);
            int n = 0;
            LayoutGenerator[] layoutGeneratorArray = new LayoutGenerator[2];
            LayoutGenerator layoutGenerator = this;
            while (n < 2) {
                int n2 = n++;
                layoutGeneratorArray[n2] = null;
            }
            layoutGenerator.childGenerators = layoutGeneratorArray;
        }

        @NotNull
        public final int[] getIndices() {
            return this.indices;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final Node[] getStorage() {
            return this.storage;
        }

        @NotNull
        public final Iterator<SplitType> getSplitTypeIterator() {
            return this.splitTypeIterator;
        }

        @NotNull
        public final SplitType getSplitType() {
            return this.splitType;
        }

        public final void setSplitType(@NotNull SplitType splitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"<set-?>");
            this.splitType = splitType;
        }

        @NotNull
        public final PartitionGenerator getPartitionGenerator() {
            return this.partitionGenerator;
        }

        public final void setPartitionGenerator(@NotNull PartitionGenerator partitionGenerator) {
            Intrinsics.checkNotNullParameter((Object)partitionGenerator, (String)"<set-?>");
            this.partitionGenerator = partitionGenerator;
        }

        @NotNull
        public final LayoutGenerator[] getChildGenerators() {
            return this.childGenerators;
        }

        public final void setChildGenerators(@NotNull LayoutGenerator[] layoutGeneratorArray) {
            Intrinsics.checkNotNullParameter((Object)layoutGeneratorArray, (String)"<set-?>");
            this.childGenerators = layoutGeneratorArray;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean next() {
            LayoutGenerator generator;
            for (LayoutGenerator childGenerator : this.childGenerators) {
                if (childGenerator == null) break;
                if (!generator.next()) continue;
                return true;
            }
            if (!this.partitionGenerator.hasNext()) {
                if (!this.splitTypeIterator.hasNext()) {
                    return false;
                }
                this.splitType = this.splitTypeIterator.next();
                this.partitionGenerator = new PartitionGenerator(this.indices);
            }
            Pair<int[], int[]> partitions = this.partitionGenerator.next();
            this.clearDescendants(this.offset);
            if (((int[])partitions.getSecond()).length == 0) {
                int[] partition = (int[])partitions.getFirst();
                if (partition.length == 1) {
                    this.storage[this.offset] = new Node.Leaf(partition[0], this.offset);
                } else {
                    this.storage[this.offset] = new Node.Split(this.splitType, partition.length, this.offset);
                    int childOffset = LayoutOptimizer.this.childrenOffsetByParentOffset[this.offset];
                    for (int index : partition) {
                        this.storage[childOffset] = new Node.Leaf(index, childOffset);
                        ++childOffset;
                    }
                }
                ArraysKt.fill$default((Object[])this.childGenerators, null, (int)0, (int)0, (int)6, null);
            } else {
                this.storage[this.offset] = new Node.Split(this.splitType, 2, this.offset);
                int childOffset = LayoutOptimizer.this.childrenOffsetByParentOffset[this.offset];
                int i = 0;
                while (i < 2) {
                    void $this$next_u24lambda_u240;
                    LayoutGenerator layoutGenerator;
                    generator = layoutGenerator = new LayoutGenerator(this.get(partitions, i), this.splitType, childOffset + i, this.storage);
                    int n = i++;
                    LayoutGenerator[] layoutGeneratorArray = this.childGenerators;
                    boolean bl = false;
                    $this$next_u24lambda_u240.next();
                    Unit unit = Unit.INSTANCE;
                    layoutGeneratorArray[n] = layoutGenerator;
                }
            }
            return true;
        }

        private final void clearDescendants(int offset) {
            int numChildren = LayoutOptimizer.this.maxChildrenByOffset[offset];
            if (numChildren == 0) {
                return;
            }
            int childOffset = LayoutOptimizer.this.childrenOffsetByParentOffset[offset];
            for (int i = 0; i < numChildren; ++i) {
                this.storage[childOffset] = null;
                this.clearDescendants(childOffset);
                ++childOffset;
            }
        }

        private final Iterator<SplitType> createSplitTypeIterator(SplitType splitTypeToAvoid) {
            List values = splitTypeToAvoid == null ? (List)SplitType.getEntries() : CollectionsKt.minus((Iterable)((Iterable)SplitType.getEntries()), (Object)((Object)splitTypeToAvoid));
            return values.iterator();
        }

        private final <T> T get(Pair<? extends T, ? extends T> $this$get, int i) {
            Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
            return (T)(switch (i) {
                case 0 -> $this$get.getFirst();
                case 1 -> $this$get.getSecond();
                default -> throw new IllegalArgumentException();
            });
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer$LevelParams;", "", "offset", "", "size", "maxChildren", "<init>", "(III)V", "getOffset", "()I", "getSize", "getMaxChildren", "intellij.android.streaming"})
    private static final class LevelParams {
        private final int offset;
        private final int size;
        private final int maxChildren;

        public LevelParams(int offset, int size, int maxChildren) {
            this.offset = offset;
            this.size = size;
            this.maxChildren = maxChildren;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getMaxChildren() {
            return this.maxChildren;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "", "offset", "", "<init>", "(I)V", "getOffset", "()I", "Leaf", "Split", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node$Leaf;", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node$Split;", "intellij.android.streaming"})
    private static abstract sealed class Node {
        private final int offset;

        private Node(int offset) {
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }

        public /* synthetic */ Node(int offset, DefaultConstructorMarker $constructor_marker) {
            this(offset);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node$Leaf;", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "rectangleIndex", "", "offset", "<init>", "(II)V", "getRectangleIndex", "()I", "intellij.android.streaming"})
        public static final class Leaf
        extends Node {
            private final int rectangleIndex;

            public Leaf(int rectangleIndex, int offset) {
                super(offset, null);
                this.rectangleIndex = rectangleIndex;
            }

            public final int getRectangleIndex() {
                return this.rectangleIndex;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node$Split;", "Lcom/android/tools/idea/streaming/core/LayoutOptimizer$Node;", "splitType", "Lcom/android/tools/idea/streaming/core/SplitType;", "childrenCount", "", "offset", "<init>", "(Lcom/android/tools/idea/streaming/core/SplitType;II)V", "getSplitType", "()Lcom/android/tools/idea/streaming/core/SplitType;", "getChildrenCount", "()I", "intellij.android.streaming"})
        public static final class Split
        extends Node {
            @NotNull
            private final SplitType splitType;
            private final int childrenCount;

            public Split(@NotNull SplitType splitType, int childrenCount, int offset) {
                Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
                super(offset, null);
                this.splitType = splitType;
                this.childrenCount = childrenCount;
            }

            @NotNull
            public final SplitType getSplitType() {
                return this.splitType;
            }

            public final int getChildrenCount() {
                return this.childrenCount;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SplitType.values().length];
            try {
                nArray[SplitType.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitType.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

