/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.core.FloatingToolbarContainerKt;
import com.android.tools.idea.streaming.core.Orientation;
import com.android.tools.idea.streaming.core.ToolbarPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.Animator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0003567B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0010H\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020$H\u0002J\b\u00103\u001a\u00020$H\u0002J\b\u00104\u001a\u00020$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00058\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001d\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010\u001bR\u001e\u0010 \u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b!\u0010\"\u00a8\u00068"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;", "Ljavax/swing/JPanel;", "horizontal", "", "inactiveAlpha", "", "<init>", "(ZD)V", "orientation", "", "getOrientation$annotations", "()V", "actionToolbars", "", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "visibilityDisposable", "Lcom/intellij/openapi/Disposable;", "listeningToMouseEvents", "activationAnimator", "Lcom/intellij/util/ui/Animator;", "deactivationAnimator", "pendingDeactivation", "value", "activationFactor", "getActivationFactor$intellij_android_streaming", "()D", "setActivationFactor", "(D)V", "expansionFactor", "setExpansionFactor", "alpha", "setAlpha", "hasCollapsibleToolbar", "setHasCollapsibleToolbar", "(Z)V", "addToolbar", "", "place", "", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "collapsible", "setTargetComponent", "component", "Ljavax/swing/JComponent;", "setUpMouseListener", "disposable", "controlActivation", "event", "Ljava/awt/event/MouseEvent;", "triggerActivation", "triggerDeactivation", "onVisibilityChanged", "ActivationAnimator", "DeactivationAnimator", "Layout", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nFloatingToolbarContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingToolbarContainer.kt\ncom/android/tools/idea/streaming/core/FloatingToolbarContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,580:1\n1#2:581\n*E\n"})
public final class FloatingToolbarContainer
extends JPanel {
    private final double inactiveAlpha;
    private final int orientation;
    @NotNull
    private final List<ActionToolbar> actionToolbars;
    @Nullable
    private Disposable visibilityDisposable;
    private boolean listeningToMouseEvents;
    @Nullable
    private Animator activationAnimator;
    @Nullable
    private Animator deactivationAnimator;
    private boolean pendingDeactivation;
    @VisibleForTesting
    private double activationFactor;
    private double expansionFactor;
    private double alpha;
    private boolean hasCollapsibleToolbar;

    public FloatingToolbarContainer(boolean horizontal, double inactiveAlpha) {
        this.inactiveAlpha = inactiveAlpha;
        this.orientation = horizontal ? 0 : 1;
        this.actionToolbars = new ArrayList();
        this.expansionFactor = 1.0;
        this.alpha = this.inactiveAlpha;
        double d = this.inactiveAlpha;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setOpaque(false);
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.addHierarchyListener(arg_0 -> FloatingToolbarContainer._init_$lambda$1(this, arg_0));
    }

    public /* synthetic */ FloatingToolbarContainer(boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(bl, d);
    }

    @Orientation
    private static /* synthetic */ void getOrientation$annotations() {
    }

    public final double getActivationFactor$intellij_android_streaming() {
        return this.activationFactor;
    }

    private final void setActivationFactor(double value2) {
        if (!(this.activationFactor == value2)) {
            this.activationFactor = value2;
            if (this.hasCollapsibleToolbar) {
                this.setExpansionFactor(this.activationFactor);
            }
            this.setAlpha(RangesKt.coerceIn((double)(this.inactiveAlpha + (1.0 - this.inactiveAlpha) * value2), (double)this.inactiveAlpha, (double)1.0));
        }
    }

    private final void setExpansionFactor(double value2) {
        if (!(this.expansionFactor == value2)) {
            this.expansionFactor = value2;
            this.revalidate();
        }
    }

    private final void setAlpha(double value2) {
        if (!(this.alpha == value2)) {
            this.alpha = value2;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getComponents());
            while (iterator2.hasNext()) {
                Component child = (Component)iterator2.next();
                if (!(child instanceof ToolbarPanel)) continue;
                ((ToolbarPanel)((Object)child)).setAlpha((float)this.alpha);
            }
            this.repaint();
        }
    }

    private final void setHasCollapsibleToolbar(boolean value2) {
        block2: {
            if (this.hasCollapsibleToolbar == value2) break block2;
            this.hasCollapsibleToolbar = value2;
            if (value2) {
                this.setExpansionFactor(this.activationFactor);
                Disposable disposable = this.visibilityDisposable;
                if (disposable != null) {
                    Disposable it = disposable;
                    boolean bl = false;
                    this.setUpMouseListener(it);
                }
            }
        }
    }

    public final void addToolbar(@NonNls @NotNull String place, @NotNull ActionGroup actionGroup2, boolean collapsible) {
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        ActionToolbar $this$addToolbar_u24lambda_u242 = actionToolbar = ActionManager.getInstance().createActionToolbar(place, actionGroup2, this.orientation == 0);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$addToolbar_u24lambda_u242);
        FloatingToolbarContainerKt.access$configureToolbar($this$addToolbar_u24lambda_u242);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar actionToolbar3 = actionToolbar2;
        this.actionToolbars.add(actionToolbar3);
        ToolbarPanel toolbarPanel = new ToolbarPanel(actionToolbar3, collapsible);
        toolbarPanel.setAlpha((float)this.alpha);
        this.add((Component)((Object)toolbarPanel));
        if (collapsible) {
            this.setHasCollapsibleToolbar(true);
        }
    }

    public final void setTargetComponent(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (ActionToolbar toolbar : this.actionToolbars) {
            toolbar.setTargetComponent(component);
        }
    }

    private final void setUpMouseListener(Disposable disposable) {
        if (this.listeningToMouseEvents) {
            return;
        }
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ FloatingToolbarContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.mouseMoved(event);
            }

            public void mouseExited(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.mouseMoved(event);
            }

            public void mouseMoved(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer.access$controlActivation(this.this$0, event);
            }
        };
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this);
        Intrinsics.checkNotNull((Object)ideGlassPane, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeGlassPaneEx");
        IdeGlassPaneEx glass = (IdeGlassPaneEx)ideGlassPane;
        glass.addMousePreprocessor((MouseListener)mouseListener2, disposable);
        glass.addMouseMotionPreprocessor((MouseMotionListener)mouseListener2, disposable);
        this.listeningToMouseEvents = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void controlActivation(MouseEvent event) {
        Point point = event.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        Point point2 = this.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocationOnScreen(...)");
        Point mouseLocation = FloatingToolbarContainerKt.access$minus(point, point2);
        if (mouseLocation.x >= 0 && mouseLocation.y >= 0 && mouseLocation.x < this.getWidth() && mouseLocation.y < this.getHeight() && this.getComponentCount() != 0) {
            int n = FloatingToolbarContainerKt.access$get(mouseLocation, this.orientation);
            Point point3 = this.getComponent(0).getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"getLocation(...)");
            if (n >= FloatingToolbarContainerKt.access$get(point3, this.orientation)) {
                this.triggerActivation();
                return;
            }
        }
        this.triggerDeactivation();
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerActivation() {
        this.pendingDeactivation = false;
        Animator animator = this.deactivationAnimator;
        if (animator != null) {
            animator.dispose();
        }
        if (this.activationAnimator == null && this.activationFactor < 1.0) {
            void $this$triggerActivation_u24lambda_u243;
            ActivationAnimator activationAnimator;
            ActivationAnimator activationAnimator2 = activationAnimator = new ActivationAnimator(AwtUtilsKt.scaled((int)200, (double)(1.0 - this.activationFactor)));
            FloatingToolbarContainer floatingToolbarContainer = this;
            boolean bl = false;
            $this$triggerActivation_u24lambda_u243.resume();
            floatingToolbarContainer.activationAnimator = activationAnimator;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerDeactivation() {
        if (this.activationAnimator == null) {
            if (this.activationFactor > 0.0 && this.deactivationAnimator == null) {
                void $this$triggerDeactivation_u24lambda_u244;
                DeactivationAnimator deactivationAnimator;
                DeactivationAnimator deactivationAnimator2 = deactivationAnimator = new DeactivationAnimator(400);
                FloatingToolbarContainer floatingToolbarContainer = this;
                boolean bl = false;
                $this$triggerDeactivation_u24lambda_u244.resume();
                floatingToolbarContainer.deactivationAnimator = deactivationAnimator;
            }
        } else {
            this.pendingDeactivation = true;
        }
    }

    private final void onVisibilityChanged() {
        if (this.isShowing()) {
            Disposable disposable = this.visibilityDisposable;
            if (disposable == null) {
                Disposable disposable2;
                Disposable it = disposable2 = Disposer.newDisposable((String)"FloatingToolbarContainer");
                boolean bl = false;
                this.visibilityDisposable = it;
                Disposable disposable3 = disposable2;
                disposable = disposable3;
                Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"also(...)");
            }
            Disposable disposable4 = disposable;
            if (this.hasCollapsibleToolbar || this.inactiveAlpha < 1.0) {
                this.setUpMouseListener(disposable4);
            }
        } else {
            Animator animator = this.activationAnimator;
            if (animator != null) {
                animator.dispose();
            }
            Animator animator2 = this.deactivationAnimator;
            if (animator2 != null) {
                animator2.dispose();
            }
            Disposable disposable = this.visibilityDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.visibilityDisposable = null;
            this.listeningToMouseEvents = false;
        }
    }

    private static final void _init_$lambda$1(FloatingToolbarContainer this$0, HierarchyEvent event) {
        if (((int)event.getChangeFlags() & 6) != 0) {
            this$0.onVisibilityChanged();
        }
    }

    public static final /* synthetic */ void access$controlActivation(FloatingToolbarContainer $this, MouseEvent event) {
        $this.controlActivation(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ActivationAnimator;", "Lcom/intellij/util/ui/Animator;", "durationMillis", "", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;I)V", "initialActivationFactor", "", "paintNow", "", "frame", "totalFrames", "cycle", "paintCycleEnd", "dispose", "intellij.android.streaming"})
    private final class ActivationAnimator
    extends Animator {
        private final double initialActivationFactor;

        public ActivationAnimator(int durationMillis) {
            super("ActivationAnimator", FloatingToolbarContainerKt.access$numFrames(durationMillis), durationMillis, false, false, null, 48, null);
            this.initialActivationFactor = FloatingToolbarContainer.this.getActivationFactor$intellij_android_streaming();
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            FloatingToolbarContainer.this.setActivationFactor(RangesKt.coerceIn((double)(this.initialActivationFactor + (double)frame / (double)totalFrames), (double)0.0, (double)1.0));
        }

        protected void paintCycleEnd() {
            FloatingToolbarContainer.this.setActivationFactor(1.0);
            this.dispose();
        }

        public void dispose() {
            super.dispose();
            FloatingToolbarContainer.this.activationAnimator = null;
            if (FloatingToolbarContainer.this.pendingDeactivation) {
                FloatingToolbarContainer.this.pendingDeactivation = false;
                FloatingToolbarContainer.this.triggerDeactivation();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\nH\u0014J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$DeactivationAnimator;", "Lcom/intellij/util/ui/Animator;", "durationMillis", "", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;I)V", "initialActivationFactor", "", "delayFrames", "paintNow", "", "frame", "totalFrames", "cycle", "paintCycleEnd", "dispose", "intellij.android.streaming"})
    private final class DeactivationAnimator
    extends Animator {
        private final double initialActivationFactor;
        private final int delayFrames;

        public DeactivationAnimator(int durationMillis) {
            super("CollapseAnimator", FloatingToolbarContainerKt.access$numFrames(durationMillis + 2000), durationMillis + 2000, false, false, null, 48, null);
            this.initialActivationFactor = FloatingToolbarContainer.this.getActivationFactor$intellij_android_streaming();
            this.delayFrames = FloatingToolbarContainerKt.access$numFrames(2000);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            if (frame <= this.delayFrames) {
                return;
            }
            FloatingToolbarContainer.this.setActivationFactor(RangesKt.coerceIn((double)(this.initialActivationFactor - (double)(frame - this.delayFrames) / (double)(totalFrames - this.delayFrames)), (double)0.0, (double)1.0));
        }

        protected void paintCycleEnd() {
            FloatingToolbarContainer.this.setActivationFactor(0.0);
            this.dispose();
        }

        public void dispose() {
            super.dispose();
            FloatingToolbarContainer.this.deactivationAnimator = null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$Layout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;)V", "preferredLayoutSize", "Ljava/awt/Dimension;", "container", "Ljava/awt/Container;", "layoutContainer", "", "computeSize", "collapsed", "", "intellij.android.streaming"})
    private final class Layout
    extends AbstractLayoutManager {
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!Intrinsics.areEqual((Object)container, (Object)FloatingToolbarContainer.this)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.computeSize(false);
        }

        public void layoutContainer(@NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!Intrinsics.areEqual((Object)container, (Object)FloatingToolbarContainer.this)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Dimension expandedSize = this.computeSize(false);
            Dimension collapsedSize = this.computeSize(true);
            Insets insets = FloatingToolbarContainer.this.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, FloatingToolbarContainer.this.getWidth() - insets.left - insets.right, FloatingToolbarContainer.this.getHeight() - insets.top - insets.bottom);
            int expansion2 = AwtUtilsKt.scaled((int)(FloatingToolbarContainerKt.access$get(expandedSize, FloatingToolbarContainer.this.orientation) - FloatingToolbarContainerKt.access$get(collapsedSize, FloatingToolbarContainer.this.orientation)), (double)FloatingToolbarContainer.this.expansionFactor);
            Dimension offset = new Dimension();
            int n = FloatingToolbarContainer.this.orientation;
            Dimension dimension2 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
            FloatingToolbarContainerKt.access$set(offset, n, FloatingToolbarContainerKt.access$get(dimension2, FloatingToolbarContainer.this.orientation) - FloatingToolbarContainerKt.access$get(collapsedSize, FloatingToolbarContainer.this.orientation) - expansion2);
            boolean pendingSpacer = false;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])container.getComponents());
            while (iterator2.hasNext()) {
                Component child = (Component)iterator2.next();
                if (pendingSpacer) {
                    int spacerLength = Math.min(expansion2, FloatingToolbarContainerKt.access$getSPACER_SIZE$p());
                    expansion2 -= spacerLength;
                    FloatingToolbarContainerKt.access$increment(offset, FloatingToolbarContainer.this.orientation, spacerLength);
                }
                Dimension childSize = child.getPreferredSize();
                Intrinsics.checkNotNull((Object)child);
                int minChildLength = FloatingToolbarContainerKt.access$get(FloatingToolbarContainerKt.access$preferredSize(child, true), FloatingToolbarContainer.this.orientation);
                Intrinsics.checkNotNull((Object)childSize);
                int childExpansion = Math.min(expansion2, FloatingToolbarContainerKt.access$get(childSize, FloatingToolbarContainer.this.orientation) - minChildLength);
                FloatingToolbarContainerKt.access$set(childSize, FloatingToolbarContainer.this.orientation, minChildLength + childExpansion);
                child.setBounds(offset.width, offset.height, childSize.width, childSize.height);
                expansion2 -= childExpansion;
                FloatingToolbarContainerKt.access$increment(offset, FloatingToolbarContainer.this.orientation, FloatingToolbarContainerKt.access$get(childSize, FloatingToolbarContainer.this.orientation));
                if (FloatingToolbarContainerKt.access$get(childSize, FloatingToolbarContainer.this.orientation) == 0) continue;
                pendingSpacer = true;
            }
        }

        private final Dimension computeSize(boolean collapsed) {
            Dimension size = new Dimension();
            boolean pendingSpacer = false;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])FloatingToolbarContainer.this.getComponents());
            while (iterator2.hasNext()) {
                Component child = (Component)iterator2.next();
                Intrinsics.checkNotNull((Object)child);
                Dimension childSize = FloatingToolbarContainerKt.access$preferredSize(child, collapsed);
                if (FloatingToolbarContainerKt.access$get(childSize, FloatingToolbarContainer.this.orientation) == 0) continue;
                if (pendingSpacer) {
                    FloatingToolbarContainerKt.access$increment(size, FloatingToolbarContainer.this.orientation, FloatingToolbarContainerKt.access$getSPACER_SIZE$p());
                }
                FloatingToolbarContainerKt.access$combine(size, FloatingToolbarContainer.this.orientation, childSize);
                pendingSpacer = true;
            }
            return size;
        }
    }
}

