/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.core.DeviceInputListener;
import com.android.tools.idea.streaming.core.DeviceInputListenerDispatcher;
import com.intellij.openapi.components.Service;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007JU\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/core/DeviceInputListenerManager;", "", "<init>", "()V", "deviceInputDispatchers", "", "", "Lcom/android/tools/idea/streaming/core/DeviceInputListenerDispatcher;", "addDeviceInputListener", "", "deviceSerialNumber", "listener", "Lcom/android/tools/idea/streaming/core/DeviceInputListener;", "removeDeviceInputListener", "notifyListenersOfTouchEvent", "displayId", "", "displayWidth", "displayHeight", "displayOrientation", "x", "y", "endOfTouch", "", "multiTouch", "notifyListenersOfTouchEvent$intellij_android_streaming", "intellij.android.streaming"})
public final class DeviceInputListenerManager {
    @NotNull
    private final Map<String, DeviceInputListenerDispatcher> deviceInputDispatchers = new LinkedHashMap();

    @UiThread
    public final void addDeviceInputListener(@NotNull String deviceSerialNumber, @NotNull DeviceInputListener listener2) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DeviceInputListenerDispatcher deviceInputListenerDispatcher = this.deviceInputDispatchers.computeIfAbsent(deviceSerialNumber, arg_0 -> DeviceInputListenerManager.addDeviceInputListener$lambda$1(DeviceInputListenerManager::addDeviceInputListener$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deviceInputListenerDispatcher, (String)"computeIfAbsent(...)");
        DeviceInputListenerDispatcher dispatcher = deviceInputListenerDispatcher;
        dispatcher.addListener(listener2);
    }

    @UiThread
    public final void removeDeviceInputListener(@NotNull String deviceSerialNumber, @NotNull DeviceInputListener listener2) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DeviceInputListenerDispatcher deviceInputListenerDispatcher = this.deviceInputDispatchers.get(deviceSerialNumber);
        if (deviceInputListenerDispatcher == null) {
            return;
        }
        DeviceInputListenerDispatcher dispatcher = deviceInputListenerDispatcher;
        if (dispatcher.removeListener(listener2) && !dispatcher.hasListeners()) {
            this.deviceInputDispatchers.remove(deviceSerialNumber);
        }
    }

    public final void notifyListenersOfTouchEvent$intellij_android_streaming(@NotNull String deviceSerialNumber, int displayId, int displayWidth, int displayHeight, int displayOrientation, int x, int y, boolean endOfTouch, boolean multiTouch) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        DeviceInputListenerDispatcher deviceInputListenerDispatcher = this.deviceInputDispatchers.get(deviceSerialNumber);
        if (deviceInputListenerDispatcher == null) {
            return;
        }
        DeviceInputListenerDispatcher dispatcher = deviceInputListenerDispatcher;
        dispatcher.notifyListenersOfTouchEvent(displayId, displayWidth, displayHeight, displayOrientation, x, y, endOfTouch, multiTouch);
    }

    private static final DeviceInputListenerDispatcher addDeviceInputListener$lambda$0(String serialNumber) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        return new DeviceInputListenerDispatcher(serialNumber);
    }

    private static final DeviceInputListenerDispatcher addDeviceInputListener$lambda$1(Function1 $tmp0, Object p0) {
        return (DeviceInputListenerDispatcher)$tmp0.invoke(p0);
    }
}

