/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.mainView;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.AddColumns;
import com.android.tools.idea.sqlite.ui.mainView.AddTable;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorViewImpl;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteColumn;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.LeftPanelViewKt;
import com.android.tools.idea.sqlite.ui.mainView.RemoveColumns;
import com.android.tools.idea.sqlite.ui.mainView.RemoveTable;
import com.android.tools.idea.sqlite.ui.mainView.SchemaDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.ViewDatabase;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CollapseAllAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.NewUI;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001PB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007J \u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0016J\u001c\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\b\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00103\u001a\u00020\tH\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00108\u001a\u000209H\u0002J.\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0&H\u0002J&\u0010B\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010C\u001a\u0002002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020A0&H\u0002J\u0010\u0010E\u001a\u0002002\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010F\u001a\u0004\u0018\u0001002\u0006\u0010=\u001a\u0002002\u0006\u0010G\u001a\u00020HH\u0002J\u001a\u0010I\u001a\u0004\u0018\u0001002\u0006\u0010=\u001a\u0002002\u0006\u0010J\u001a\u00020HH\u0002J\b\u0010K\u001a\u00020\u0007H\u0002J\u000e\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u0007J\u000e\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010/\u001a\u0004\u0018\u000100*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006Q"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView;", "", "mainView", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;", "<init>", "(Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;)V", "isForceOpen", "", "rootPanel", "Ljavax/swing/JPanel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "refreshSchemaButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "runSqlButton", "keepConnectionsOpenButton", "Lcom/android/tools/adtui/stdui/CommonToggleButton;", "exportButton", "component", "getComponent", "()Ljavax/swing/JPanel;", "databasesCount", "", "getDatabasesCount", "()I", "createCollapseTreeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "updateKeepConnectionOpenButton", "", "enabled", "addDatabaseSchema", "viewDatabase", "Lcom/android/tools/idea/sqlite/ui/mainView/ViewDatabase;", "schema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "index", "updateDatabase", "diffOperations", "", "Lcom/android/tools/idea/sqlite/ui/mainView/SchemaDiffOperation;", "removeDatabaseSchema", "createNorthPanel", "updateExportButtonEnabledState", "createExportDialogParams", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "actionOrigin", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportDialogOpenedEvent$Origin;", "selectedNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getSelectedNode", "(Lcom/intellij/ui/treeStructure/Tree;)Ljavax/swing/tree/DefaultMutableTreeNode;", "createCenterPanel", "setUpSchemaTree", "setUpExportPopUp", "setUpSchemaTreeListeners", "fireAction", "e", "Ljava/awt/event/InputEvent;", "addNewTableNode", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "databaseNode", "sqliteTableToAdd", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteTable;", "sqliteColumnsToAdd", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteColumn;", "addColumnsToTableNode", "tableNode", "columnsToAdd", "findDatabaseNode", "findTableNode", "tableName", "", "findColumnNode", "columnName", "hasLiveDatabases", "setRefreshButtonState", "state", "setForceOpen", "forceOpen", "SchemaTreeCellRenderer", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nLeftPanelView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeftPanelView.kt\ncom/android/tools/idea/sqlite/ui/mainView/LeftPanelView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,582:1\n1056#2:583\n1869#2:584\n1869#2,2:585\n1870#2:587\n1563#2:588\n1634#2,3:589\n1869#2,2:592\n1869#2,2:595\n1056#2:597\n1563#2:598\n1634#2,3:599\n1869#2,2:602\n1869#2,2:604\n1869#2,2:612\n1869#2,2:614\n1869#2,2:616\n1869#2,2:618\n1#3:594\n127#4,2:606\n183#4,2:608\n183#4,2:610\n*S KotlinDebug\n*F\n+ 1 LeftPanelView.kt\ncom/android/tools/idea/sqlite/ui/mainView/LeftPanelView\n*L\n134#1:583\n135#1:584\n137#1:585,2\n135#1:587\n189#1:588\n189#1:589,3\n190#1:592,2\n384#1:595,2\n410#1:597\n411#1:598\n411#1:599,3\n412#1:602,2\n422#1:604,2\n228#1:612,2\n238#1:614,2\n257#1:616,2\n271#1:618,2\n435#1:606,2\n447#1:608,2\n459#1:610,2\n*E\n"})
public final class LeftPanelView {
    @NotNull
    private final DatabaseInspectorViewImpl mainView;
    private boolean isForceOpen;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final Tree tree;
    @NotNull
    private final CommonButton refreshSchemaButton;
    @NotNull
    private final CommonButton runSqlButton;
    @NotNull
    private final CommonToggleButton keepConnectionsOpenButton;
    @NotNull
    private final CommonButton exportButton;
    @NotNull
    private final JPanel component;

    public LeftPanelView(@NotNull DatabaseInspectorViewImpl mainView) {
        Intrinsics.checkNotNullParameter((Object)mainView, (String)"mainView");
        this.mainView = mainView;
        this.rootPanel = new JPanel(new BorderLayout());
        this.tree = new Tree();
        this.refreshSchemaButton = new CommonButton(AllIcons.Actions.Refresh);
        this.runSqlButton = new CommonButton(StudioIcons.DatabaseInspector.NEW_QUERY);
        this.keepConnectionsOpenButton = new CommonToggleButton(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        this.exportButton = new CommonButton(AllIcons.ToolbarDecorator.Export);
        this.component = this.rootPanel;
        JPanel northPanel = this.createNorthPanel();
        JPanel centerPanel = this.createCenterPanel();
        this.rootPanel.add((Component)northPanel, "North");
        this.rootPanel.add((Component)centerPanel, "Center");
        this.setUpSchemaTree(this.tree);
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    public final int getDatabasesCount() {
        Object object = this.tree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        return defaultMutableTreeNode != null ? defaultMutableTreeNode.getChildCount() : 0;
    }

    @NotNull
    public final AnAction createCollapseTreeAction() {
        return (AnAction)new CollapseAllAction(arg_0 -> LeftPanelView.createCollapseTreeAction$lambda$0(this, arg_0));
    }

    public final void updateKeepConnectionOpenButton(boolean enabled) {
        this.keepConnectionsOpenButton.setSelected(enabled);
        if (enabled) {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        } else {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.ALLOW_DATABASES_TO_CLOSE);
        }
        Icon icon = this.keepConnectionsOpenButton.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    /*
     * WARNING - void declaration
     */
    public final void addDatabaseSchema(@NotNull ViewDatabase viewDatabase, @Nullable SqliteSchema schema, int index) {
        List<SqliteTable> list;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        if (treeModel2.getRoot() == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Databases");
            treeModel2.setRoot(root);
            defaultMutableTreeNode = root;
        } else {
            Object object = treeModel2.getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        }
        DefaultMutableTreeNode root = defaultMutableTreeNode;
        DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(viewDatabase);
        if (schema != null && (list = schema.getTables()) != null) {
            Iterable $this$sortedBy$iv;
            Iterable iterable = list;
            boolean $i$f$sortedBy = false;
            List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SqliteTable it = (SqliteTable)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (SqliteTable)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            if (list2 != null) {
                void $this$forEach$iv;
                $this$sortedBy$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqliteTable table2 = (SqliteTable)element$iv;
                    boolean bl = false;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table2);
                    Iterable $this$forEach$iv2 = table2.getColumns();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SqliteColumn column2 = (SqliteColumn)element$iv2;
                        boolean bl2 = false;
                        tableNode.add(new DefaultMutableTreeNode(column2));
                    }
                    schemaNode.add(tableNode);
                }
            }
        }
        treeModel2.insertNodeInto(schemaNode, root, index);
        if (schema == null) {
            this.tree.expandPath(new TreePath(root));
        } else {
            this.tree.expandPath(new TreePath(schemaNode.getPath()));
        }
        this.refreshSchemaButton.setEnabled(true);
        this.runSqlButton.setEnabled(true);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases() && !this.isForceOpen);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDatabase(@NotNull ViewDatabase viewDatabase, @NotNull List<? extends SchemaDiffOperation> diffOperations) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        Intrinsics.checkNotNullParameter(diffOperations, (String)"diffOperations");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        databaseNode.setUserObject(viewDatabase);
        for (SchemaDiffOperation schemaDiffOperation : diffOperations) {
            DefaultMutableTreeNode tableNode;
            SchemaDiffOperation schemaDiffOperation2 = schemaDiffOperation;
            if (schemaDiffOperation2 instanceof AddTable) {
                this.addNewTableNode(treeModel2, databaseNode, ((AddTable)schemaDiffOperation).getIndexedSqliteTable(), ((AddTable)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof AddColumns) {
                if (this.findTableNode(databaseNode, ((AddColumns)schemaDiffOperation).getTableName()) == null) {
                    Object object = new String[]{((AddColumns)schemaDiffOperation).getTableName()};
                    object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                    throw new IllegalStateException(object.toString());
                }
                tableNode.setUserObject(((AddColumns)schemaDiffOperation).getNewTable());
                this.addColumnsToTableNode(treeModel2, tableNode, ((AddColumns)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof RemoveTable) {
                if (this.findTableNode(databaseNode, ((RemoveTable)schemaDiffOperation).getTableName()) == null) {
                    Object object = new String[]{((RemoveTable)schemaDiffOperation).getTableName()};
                    object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                    throw new IllegalStateException(object.toString());
                }
                treeModel2.removeNodeFromParent(tableNode);
                continue;
            }
            if (schemaDiffOperation2 instanceof RemoveColumns) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                if (this.findTableNode(databaseNode, ((RemoveColumns)schemaDiffOperation).getTableName()) == null) {
                    Object object = new String[]{((RemoveColumns)schemaDiffOperation).getTableName()};
                    object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                    throw new IllegalStateException(object.toString());
                }
                tableNode.setUserObject(((RemoveColumns)schemaDiffOperation).getNewTable());
                Iterable iterable = ((RemoveColumns)schemaDiffOperation).getColumnsToRemove();
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqliteColumn sqliteColumn = (SqliteColumn)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(this.findColumnNode(tableNode, it.getName()));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                    boolean bl = false;
                    treeModel2.removeNodeFromParent(it);
                }
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    public final int removeDatabaseSchema(@NotNull ViewDatabase viewDatabase) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        treeModel2.removeNodeFromParent(databaseNode);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases());
        if (this.getDatabasesCount() == 0) {
            this.tree.setModel((TreeModel)new DefaultTreeModel(null));
            this.refreshSchemaButton.setEnabled(false);
            this.runSqlButton.setEnabled(false);
        }
        return this.getDatabasesCount();
    }

    private final JPanel createNorthPanel() {
        JPanel northPanel = new JPanel(new FlowLayout(0));
        Icon icon = AllIcons.Actions.Refresh;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Refresh");
        this.refreshSchemaButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        this.refreshSchemaButton.setName("refresh-schema-button");
        this.refreshSchemaButton.setEnabled(false);
        this.refreshSchemaButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.refresh.schema.tooltip", new String[0]));
        northPanel.add((Component)this.refreshSchemaButton);
        this.refreshSchemaButton.addActionListener(arg_0 -> LeftPanelView.createNorthPanel$lambda$7(this, arg_0));
        Icon icon2 = StudioIcons.DatabaseInspector.NEW_QUERY;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NEW_QUERY");
        this.runSqlButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon2));
        this.runSqlButton.setName("run-sql-button");
        this.runSqlButton.setEnabled(false);
        this.runSqlButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.run.query.tooltip", new String[0]));
        northPanel.add((Component)this.runSqlButton);
        this.runSqlButton.addActionListener(arg_0 -> LeftPanelView.createNorthPanel$lambda$9(this, arg_0));
        Icon icon3 = this.keepConnectionsOpenButton.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon3));
        this.keepConnectionsOpenButton.setName("keep-connections-open-button");
        this.keepConnectionsOpenButton.setEnabled(false);
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.title", new String[0])).setDescription(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.desc", new String[0])).setLink(DatabaseInspectorBundle.INSTANCE.message("learn.more", new String[0]), LeftPanelView::createNorthPanel$lambda$10).installOn((JComponent)this.keepConnectionsOpenButton);
        northPanel.add((Component)this.keepConnectionsOpenButton);
        this.keepConnectionsOpenButton.addActionListener(arg_0 -> LeftPanelView.createNorthPanel$lambda$12(this, arg_0));
        this.exportButton.setName("export-button");
        Icon icon4 = this.exportButton.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getIcon(...)");
        this.exportButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon4));
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0])).installOn((JComponent)this.exportButton);
        northPanel.add((Component)this.exportButton);
        this.exportButton.addActionListener(arg_0 -> LeftPanelView.createNorthPanel$lambda$14(this, arg_0));
        this.updateExportButtonEnabledState();
        this.tree.addTreeSelectionListener(arg_0 -> LeftPanelView.createNorthPanel$lambda$15(this, arg_0));
        return northPanel;
    }

    private final void updateExportButtonEnabledState() {
        this.exportButton.setEnabled(this.createExportDialogParams(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_EXPORT_BUTTON) != null);
    }

    private final ExportDialogParams createExportDialogParams(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin actionOrigin) {
        Object object;
        DefaultMutableTreeNode selectedNode;
        DefaultMutableTreeNode defaultMutableTreeNode = selectedNode = this.getSelectedNode(this.tree);
        Object selected = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = selectedNode;
        if (defaultMutableTreeNode2 != null) {
            DefaultMutableTreeNode it = defaultMutableTreeNode2;
            boolean bl = false;
            TreeNode treeNode = it.getParent();
            DefaultMutableTreeNode defaultMutableTreeNode3 = treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
            object = defaultMutableTreeNode3 != null ? defaultMutableTreeNode3.getUserObject() : null;
        } else {
            object = null;
        }
        Object parent = object;
        return selected instanceof ViewDatabase ? (ExportDialogParams)new ExportDialogParams.ExportDatabaseDialogParams(((ViewDatabase)selected).getDatabaseId(), actionOrigin) : (selected instanceof SqliteTable && parent instanceof ViewDatabase ? (ExportDialogParams)new ExportDialogParams.ExportTableDialogParams(((ViewDatabase)parent).getDatabaseId(), ((SqliteTable)selected).getName(), actionOrigin) : null);
    }

    private final DefaultMutableTreeNode getSelectedNode(Tree $this$selectedNode) {
        TreePath treePath = $this$selectedNode.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        return object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
    }

    private final JPanel createCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        JBScrollPane scrollPane2 = new JBScrollPane((Component)this.tree);
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        centerPanel.add((Component)scrollPane2, "Center");
        return centerPanel;
    }

    private final void setUpSchemaTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new SchemaTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setModel((TreeModel)new DefaultTreeModel(null));
        tree.setToggleClickCount(0);
        tree.getEmptyText().setText(DatabaseInspectorBundle.INSTANCE.message("nothing.to.show", new String[0]));
        tree.getEmptyText().setShowAboveCenter(false);
        tree.setName("left-panel-tree");
        this.setUpExportPopUp(tree);
        this.setUpSchemaTreeListeners(tree);
    }

    private final void setUpExportPopUp(Tree tree) {
        AnAction[] anActionArray = DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0]);
        AnAction exportAction2 = new AnAction(this, (String)anActionArray){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ExportDialogParams exportDialogParams = LeftPanelView.access$createExportDialogParams(this.this$0, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_CONTEXT_MENU);
                if (exportDialogParams == null) {
                    return;
                }
                ExportDialogParams exportParams = exportDialogParams;
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it.showExportToFileDialogInvoked(exportParams);
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(LeftPanelView.access$createExportDialogParams(this.this$0, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_CONTEXT_MENU) != null);
                super.update(e);
            }
        };
        anActionArray = new AnAction[]{exportAction2};
        PopupHandler.installFollowingSelectionTreePopup((JTree)((JTree)tree), (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (String)"unknown");
    }

    private final void setUpSchemaTreeListeners(Tree tree) {
        KeyAdapter treeKeyAdapter2 = new KeyAdapter(this, tree){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
            }

            public void keyPressed(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 10) {
                    LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                }
            }
        };
        DoubleClickListener treeDoubleClickListener2 = new DoubleClickListener(this, tree){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
            }

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                return true;
            }
        };
        tree.addKeyListener((KeyListener)treeKeyAdapter2);
        treeDoubleClickListener2.installOn((Component)tree);
    }

    private final void fireAction(Tree tree, InputEvent e) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode(tree);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = defaultMutableTreeNode;
        Object sqliteTable = selectedNode.getUserObject();
        if (sqliteTable instanceof SqliteTable) {
            TreeNode treeNode = selectedNode.getParent();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode;
            Object object = parentNode.getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.mainView.ViewDatabase");
            ViewDatabase viewDatabase = (ViewDatabase)object;
            Iterable $this$forEach$iv = this.mainView.getListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseInspectorView.Listener l = (DatabaseInspectorView.Listener)element$iv;
                boolean bl = false;
                l.tableNodeActionInvoked(viewDatabase.getDatabaseId(), (SqliteTable)sqliteTable);
            }
            e.consume();
        } else {
            TreePath path = new TreePath(selectedNode.getPath());
            if (tree.isExpanded(path)) {
                tree.collapsePath(path);
            } else {
                tree.expandPath(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode databaseNode, IndexedSqliteTable sqliteTableToAdd, List<IndexedSqliteColumn> sqliteColumnsToAdd) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$sortedBy$iv;
        SqliteTable sqliteTable = sqliteTableToAdd.component1();
        int index = sqliteTableToAdd.component2();
        DefaultMutableTreeNode newTableNode = new DefaultMutableTreeNode(sqliteTable);
        Iterable iterable = sqliteColumnsToAdd;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedSqliteColumn it = (IndexedSqliteColumn)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedSqliteColumn)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getSqliteColumn());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteColumn column2 = (SqliteColumn)element$iv;
            boolean bl = false;
            newTableNode.add(new DefaultMutableTreeNode(column2));
        }
        treeModel.insertNodeInto(newTableNode, databaseNode, index);
    }

    private final void addColumnsToTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode tableNode, List<IndexedSqliteColumn> columnsToAdd) {
        Iterable $this$forEach$iv = columnsToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)element$iv;
            boolean bl = false;
            SqliteColumn sqliteColumn = indexedSqliteColumn.component1();
            int index = indexedSqliteColumn.component2();
            DefaultMutableTreeNode newColumnNode = new DefaultMutableTreeNode(sqliteColumn);
            treeModel.insertNodeInto(newColumnNode, tableNode, index);
        }
    }

    private final DefaultMutableTreeNode findDatabaseNode(ViewDatabase viewDatabase) {
        Object element$iv2;
        block1: {
            Object object = this.tree.getModel().getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
            Enumeration<TreeNode> enumeration = root.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
            Sequence $this$first$iv = SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), LeftPanelView::findDatabaseNode$lambda$22);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserObject(), (Object)viewDatabase)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (DefaultMutableTreeNode)element$iv2;
    }

    private final DefaultMutableTreeNode findTableNode(DefaultMutableTreeNode databaseNode, String tableName) {
        Object v2;
        block1: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), LeftPanelView::findTableNode$lambda$24), LeftPanelView::findTableNode$lambda$25);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                Object object = it.getUserObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteTable");
                if (!Intrinsics.areEqual((Object)((SqliteTable)object).getName(), (Object)tableName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final DefaultMutableTreeNode findColumnNode(DefaultMutableTreeNode databaseNode, String columnName) {
        Object v2;
        block1: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), LeftPanelView::findColumnNode$lambda$27), LeftPanelView::findColumnNode$lambda$28);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                Object object = it.getUserObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteColumn");
                if (!Intrinsics.areEqual((Object)((SqliteColumn)object).getName(), (Object)columnName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final boolean hasLiveDatabases() {
        Object object = this.tree.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        Enumeration<TreeNode> enumeration = root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        return !((Collection)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), LeftPanelView::hasLiveDatabases$lambda$30), LeftPanelView::hasLiveDatabases$lambda$31))).isEmpty();
    }

    public final void setRefreshButtonState(boolean state2) {
        this.refreshSchemaButton.setEnabled(state2);
    }

    public final void setForceOpen(boolean forceOpen) {
        this.isForceOpen = forceOpen;
    }

    private static final TreeExpander createCollapseTreeAction$lambda$0(LeftPanelView this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TreeExpander)new DefaultTreeExpander((JTree)this$0.tree);
    }

    private static final void createNorthPanel$lambda$7(LeftPanelView this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.mainView.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
            boolean bl = false;
            it2.refreshAllOpenDatabasesSchemaActionInvoked();
        }
    }

    private static final void createNorthPanel$lambda$9(LeftPanelView this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.mainView.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
            boolean bl = false;
            it2.openSqliteEvaluatorTabActionInvoked(LeftPanelViewKt.getFirstSelectedDatabaseId(this$0.tree));
        }
    }

    private static final void createNorthPanel$lambda$10() {
        BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/db-inspector-help/lock-connections");
    }

    private static final void createNorthPanel$lambda$12(LeftPanelView this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.mainView.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
            boolean bl = false;
            it2.toggleKeepConnectionOpenActionInvoked();
        }
    }

    private static final void createNorthPanel$lambda$14(LeftPanelView this$0, ActionEvent it) {
        ExportDialogParams exportDialogParams = this$0.createExportDialogParams(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_EXPORT_BUTTON);
        if (exportDialogParams == null) {
            return;
        }
        ExportDialogParams exportParams = exportDialogParams;
        Iterable $this$forEach$iv = this$0.mainView.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
            boolean bl = false;
            it2.showExportToFileDialogInvoked(exportParams);
        }
    }

    private static final void createNorthPanel$lambda$15(LeftPanelView this$0, TreeSelectionEvent it) {
        this$0.updateExportButtonEnabledState();
    }

    private static final DefaultMutableTreeNode findDatabaseNode$lambda$22(TreeNode it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return (DefaultMutableTreeNode)it;
    }

    private static final DefaultMutableTreeNode findTableNode$lambda$24(TreeNode it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return (DefaultMutableTreeNode)it;
    }

    private static final boolean findTableNode$lambda$25(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUserObject() instanceof SqliteTable;
    }

    private static final DefaultMutableTreeNode findColumnNode$lambda$27(TreeNode it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return (DefaultMutableTreeNode)it;
    }

    private static final boolean findColumnNode$lambda$28(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUserObject() instanceof SqliteColumn;
    }

    private static final ViewDatabase hasLiveDatabases$lambda$30(TreeNode it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        Object object = ((DefaultMutableTreeNode)it).getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.mainView.ViewDatabase");
        return (ViewDatabase)object;
    }

    private static final boolean hasLiveDatabases$lambda$31(ViewDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDatabaseId() instanceof SqliteDatabaseId.LiveSqliteDatabaseId;
    }

    public static final /* synthetic */ ExportDialogParams access$createExportDialogParams(LeftPanelView $this, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin actionOrigin) {
        return $this.createExportDialogParams(actionOrigin);
    }

    public static final /* synthetic */ DatabaseInspectorViewImpl access$getMainView$p(LeftPanelView $this) {
        return $this.mainView;
    }

    public static final /* synthetic */ void access$fireAction(LeftPanelView $this, Tree tree, InputEvent e) {
        $this.fireAction(tree, e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J \u0010\u0016\u001a\u00020\n*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView$SchemaTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "colorTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "formatToLabel", "Ljavax/swing/JLabel;", "label", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "configure", "icon", "Ljavax/swing/Icon;", "tag", "", "app-inspection.inspectors.database"})
    private static final class SchemaTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final SimpleTextAttributes colorTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.gray);

        @NotNull
        protected JLabel formatToLabel(@NotNull JLabel label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            JLabel jLabel = super.formatToLabel(label2);
            Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"formatToLabel(...)");
            return jLabel;
        }

        /*
         * WARNING - void declaration
         */
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            this.setToolTipText(null);
            if (value2 instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof ViewDatabase) {
                    void $this$customizeCellRenderer_u24lambda_u240;
                    StringBuilder stringBuilder;
                    SqliteDatabaseId databaseId = ((ViewDatabase)userObject).getDatabaseId();
                    String apiClassName = LeftPanelViewKt.access$getApiClassName(databaseId);
                    this.append(databaseId.getName());
                    if (apiClassName != null) {
                        this.append(" " + StringsKt.substringAfterLast$default((String)apiClassName, (char)'.', null, (int)2, null), this.colorTextAttributes);
                    }
                    if (!((ViewDatabase)userObject).isOpen()) {
                        this.configure(this, LeftPanelViewKt.access$getLIVE_DB_CLOSED_ICON$p(), "closed");
                    } else if (!(databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) {
                        SchemaTreeCellRenderer.configure$default(this, this, LeftPanelViewKt.access$getFILE_DB_ICON$p(), null, 2, null);
                    } else if (((SqliteDatabaseId.LiveSqliteDatabaseId)databaseId).isForced()) {
                        this.configure(this, LeftPanelViewKt.access$getLIVE_DB_FORCED_ICON$p(), "non-native");
                    } else if (((SqliteDatabaseId.LiveSqliteDatabaseId)databaseId).isReadOnly()) {
                        this.configure(this, LeftPanelViewKt.access$getLIVE_DB_ICON$p(), "may be read-only");
                    } else {
                        SchemaTreeCellRenderer.configure$default(this, this, LeftPanelViewKt.access$getLIVE_DB_ICON$p(), null, 2, null);
                    }
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    SchemaTreeCellRenderer schemaTreeCellRenderer = this;
                    boolean bl = false;
                    $this$customizeCellRenderer_u24lambda_u240.append("<html>");
                    $this$customizeCellRenderer_u24lambda_u240.append(databaseId.getPath());
                    if (apiClassName != null) {
                        $this$customizeCellRenderer_u24lambda_u240.append("<br>Opened with " + apiClassName);
                    }
                    $this$customizeCellRenderer_u24lambda_u240.append("</html>");
                    schemaTreeCellRenderer.setToolTipText(stringBuilder.toString());
                } else if (userObject instanceof SqliteTable) {
                    this.setIcon(((SqliteTable)userObject).isView() ? StudioIcons.DatabaseInspector.VIEW : StudioIcons.DatabaseInspector.TABLE);
                    this.append(((SqliteTable)userObject).getName());
                } else if (userObject instanceof SqliteColumn) {
                    Icon icon;
                    boolean bl = ((SqliteColumn)userObject).getInPrimaryKey();
                    if (bl) {
                        icon = StudioIcons.DatabaseInspector.PRIMARY_KEY;
                    } else if (!bl) {
                        icon = StudioIcons.DatabaseInspector.COLUMN;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    this.setIcon(icon);
                    this.append(((SqliteColumn)userObject).getName());
                    this.append("  :  ", this.colorTextAttributes);
                    String string = ((SqliteColumn)userObject).getAffinity().name();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string2 = string.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    this.append(string2, this.colorTextAttributes);
                    this.append(((SqliteColumn)userObject).isNullable() ? "" : ", NOT NULL", this.colorTextAttributes);
                } else if (userObject instanceof String) {
                    this.append((String)userObject);
                }
            }
            if (hasFocus && !NewUI.isEnabled() && this.getIcon() != null) {
                Icon icon = this.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
                this.setIcon(ColoredIconGenerator.generateWhiteIcon((Icon)icon));
            }
        }

        private final void configure(ColoredTreeCellRenderer $this$configure, Icon icon, String tag) {
            $this$configure.setIcon(icon);
            if (tag != null) {
                $this$configure.append(" (" + tag + ")", this.colorTextAttributes);
            }
        }

        static /* synthetic */ void configure$default(SchemaTreeCellRenderer schemaTreeCellRenderer, ColoredTreeCellRenderer coloredTreeCellRenderer, Icon icon, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            schemaTreeCellRenderer.configure(coloredTreeCellRenderer, icon, string);
        }
    }
}

