/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.SqliteEvaluatorController;
import com.android.tools.idea.sqlite.controllers.SqliteEvaluatorControllerKt;
import com.android.tools.idea.sqlite.controllers.TableController;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.DatabaseInspectorModel;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.ModelKt;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.UtilsKt;
import com.android.tools.idea.sqlite.repository.DatabaseRepository;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0095\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0001-\b\u0007\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0012\u0010/\u001a\u00020\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u00010(J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f02H\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\u000e\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020%J\u000e\u00107\u001a\u00020\u000f2\u0006\u00106\u001a\u00020%J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f022\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020(J\b\u0010=\u001a\u00020\u0018H\u0016J\b\u0010>\u001a\u00020\u001aH\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f022\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010@\u001a\u00020\u000fH\u0002J\b\u0010A\u001a\u00020\u000fH\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000f022\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020;H\u0002J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000f022\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010D\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.\u00a8\u0006I"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;", "databaseRepository", "Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;", "initialDatabaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "view", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "showSuccessfulExecutionNotification", "Lkotlin/Function1;", "", "", "closeTabInvoked", "Lkotlin/Function0;", "showExportDialog", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "isLiveUpdatesEnabled", "", "rowBatchSize", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;ZI)V", "getCloseTabInvoked", "()Lkotlin/jvm/functions/Function0;", "currentTableController", "Lcom/android/tools/idea/sqlite/controllers/TableController;", "sqliteEvaluatorViewListener", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "listeners", "", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "openDatabases", "currentEvaluationParams", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$EvaluationParams;", "lastUsedEvaluationParams", "queryHistory", "Ljava/util/LinkedList;", "modelListener", "com/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$modelListener$1", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$modelListener$1;", "setUp", "evaluationParams", "refreshData", "Lcom/google/common/util/concurrent/ListenableFuture;", "notifyDataMightBeStale", "dispose", "addListener", "listener", "removeListener", "showAndExecuteSqlStatement", "databaseId", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "saveEvaluationParams", "isLiveUpdateEnabled", "getRowBatchSize", "executeSqlStatement", "resetTable", "updateRunSqliteStatementButtonState", "runQuery", "runUpdate", "updateDefaultMessage", "Companion", "SqliteEvaluatorViewListenerImpl", "Listener", "EvaluationParams", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nSqliteEvaluatorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteEvaluatorController.kt\ncom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,381:1\n1869#2,2:382\n1869#2,2:385\n1#3:384\n*S KotlinDebug\n*F\n+ 1 SqliteEvaluatorController.kt\ncom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController\n*L\n126#1:382,2\n297#1:385,2\n*E\n"})
public final class SqliteEvaluatorController
implements DatabaseInspectorController.TabController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseInspectorModel model;
    @NotNull
    private final DatabaseRepository databaseRepository;
    @Nullable
    private final SqliteDatabaseId initialDatabaseId;
    @NotNull
    private final SqliteEvaluatorView view;
    @NotNull
    private final Function1<String, Unit> showSuccessfulExecutionNotification;
    @NotNull
    private final Function0<Unit> closeTabInvoked;
    @NotNull
    private final Function1<ExportDialogParams, Unit> showExportDialog;
    @NotNull
    private final Executor edtExecutor;
    @NotNull
    private final Executor taskExecutor;
    private boolean isLiveUpdatesEnabled;
    private int rowBatchSize;
    @Nullable
    private TableController currentTableController;
    @NotNull
    private final SqliteEvaluatorView.Listener sqliteEvaluatorViewListener;
    @NotNull
    private final List<Listener> listeners;
    @NotNull
    private final List<SqliteDatabaseId> openDatabases;
    @NotNull
    private EvaluationParams currentEvaluationParams;
    @Nullable
    private EvaluationParams lastUsedEvaluationParams;
    @NotNull
    private final LinkedList<String> queryHistory;
    @NotNull
    private final modelListener.1 modelListener;
    @NotNull
    private static final String QUERY_HISTORY_KEY = "com.android.tools.idea.sqlite.queryhistory";
    private static final int MAX_QUERY_HISTORY_SIZE = 5;

    public SqliteEvaluatorController(@NotNull Project project, @NotNull DatabaseInspectorModel model, @NotNull DatabaseRepository databaseRepository, @Nullable SqliteDatabaseId initialDatabaseId, @NotNull SqliteEvaluatorView view, @NotNull Function1<? super String, Unit> showSuccessfulExecutionNotification, @NotNull Function0<Unit> closeTabInvoked, @NotNull Function1<? super ExportDialogParams, Unit> showExportDialog2, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor, boolean isLiveUpdatesEnabled, int rowBatchSize) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)databaseRepository, (String)"databaseRepository");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(showSuccessfulExecutionNotification, (String)"showSuccessfulExecutionNotification");
        Intrinsics.checkNotNullParameter(closeTabInvoked, (String)"closeTabInvoked");
        Intrinsics.checkNotNullParameter(showExportDialog2, (String)"showExportDialog");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.project = project;
        this.model = model;
        this.databaseRepository = databaseRepository;
        this.initialDatabaseId = initialDatabaseId;
        this.view = view;
        this.showSuccessfulExecutionNotification = showSuccessfulExecutionNotification;
        this.closeTabInvoked = closeTabInvoked;
        this.showExportDialog = showExportDialog2;
        this.edtExecutor = edtExecutor;
        this.taskExecutor = taskExecutor;
        this.isLiveUpdatesEnabled = isLiveUpdatesEnabled;
        this.rowBatchSize = rowBatchSize;
        this.sqliteEvaluatorViewListener = new SqliteEvaluatorViewListenerImpl();
        this.listeners = new ArrayList();
        this.openDatabases = new ArrayList();
        this.currentEvaluationParams = new EvaluationParams(null, "");
        this.queryHistory = new LinkedList();
        this.modelListener = new DatabaseInspectorModel.Listener(this){
            final /* synthetic */ SqliteEvaluatorController this$0;
            {
                this.this$0 = $receiver;
            }

            @UiThread
            public void onDatabasesChanged(List<? extends SqliteDatabaseId> openDatabaseIds, List<? extends SqliteDatabaseId> closeDatabaseIds) {
                Intrinsics.checkNotNullParameter(openDatabaseIds, (String)"openDatabaseIds");
                Intrinsics.checkNotNullParameter(closeDatabaseIds, (String)"closeDatabaseIds");
                SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0).clear();
                Iterable $this$sortedBy$iv = openDatabaseIds;
                boolean $i$f$sortedBy = false;
                SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0).addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SqliteDatabaseId it = (SqliteDatabaseId)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (SqliteDatabaseId)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                }));
                if (!CollectionsKt.contains((Iterable)openDatabaseIds, (Object)SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0).getDatabaseId())) {
                    SqliteDatabaseId sqliteDatabaseId = SqliteEvaluatorController.access$getInitialDatabaseId$p(this.this$0);
                    if (sqliteDatabaseId == null) {
                        sqliteDatabaseId = SqliteEvaluatorControllerKt.access$getDefault(SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0));
                    }
                    SqliteDatabaseId db = sqliteDatabaseId;
                    SqliteEvaluatorController.access$setCurrentEvaluationParams$p(this.this$0, EvaluationParams.copy$default(SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0), db, null, 2, null));
                }
                EvaluationParams evaluationParams = SqliteEvaluatorController.access$getLastUsedEvaluationParams$p(this.this$0);
                if (!CollectionsKt.contains((Iterable)openDatabaseIds, (Object)(evaluationParams != null ? evaluationParams.getDatabaseId() : null))) {
                    SqliteEvaluatorController.access$resetTable(this.this$0);
                }
                SqliteEvaluatorController.access$getView$p(this.this$0).setDatabases((List<? extends SqliteDatabaseId>)new ArrayList<E>(SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0)), SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0).getDatabaseId());
                SqliteEvaluatorController.access$updateRunSqliteStatementButtonState(this.this$0);
            }

            @UiThread
            public void onSchemaChanged(SqliteDatabaseId databaseId, SqliteSchema oldSchema, SqliteSchema newSchema) {
                Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
                Intrinsics.checkNotNullParameter((Object)oldSchema, (String)"oldSchema");
                Intrinsics.checkNotNullParameter((Object)newSchema, (String)"newSchema");
                SqliteEvaluatorController.access$getView$p(this.this$0).schemaChanged(databaseId);
            }
        };
    }

    public /* synthetic */ SqliteEvaluatorController(Project project, DatabaseInspectorModel databaseInspectorModel, DatabaseRepository databaseRepository, SqliteDatabaseId sqliteDatabaseId, SqliteEvaluatorView sqliteEvaluatorView2, Function1 function1, Function0 function0, Function1 function12, Executor executor, Executor executor2, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x400) != 0) {
            bl = false;
        }
        if ((n2 & 0x800) != 0) {
            n = DatabaseInspectorController.Companion.getDEFAULT_ROW_BATCH_SIZE();
        }
        this(project, databaseInspectorModel, databaseRepository, sqliteDatabaseId, sqliteEvaluatorView2, (Function1<? super String, Unit>)function1, (Function0<Unit>)function0, (Function1<? super ExportDialogParams, Unit>)function12, executor, executor2, bl, n);
    }

    @Override
    @NotNull
    public Function0<Unit> getCloseTabInvoked() {
        return this.closeTabInvoked;
    }

    public final void setUp(@Nullable EvaluationParams evaluationParams) {
        this.model.addListener(this.modelListener);
        this.view.addListener(this.sqliteEvaluatorViewListener);
        this.updateDefaultMessage();
        List list = PropertiesComponent.getInstance((Project)this.project).getList(QUERY_HISTORY_KEY);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkNotNull((Object)string);
                this.queryHistory.add(string);
            }
        }
        this.view.setQueryHistory(CollectionsKt.toList((Iterable)this.queryHistory));
        if (evaluationParams != null) {
            SqliteStatement statement = UtilsKt.createSqliteStatement$default(this.project, evaluationParams.getStatementText(), null, 4, null);
            if (CollectionsKt.contains((Iterable)this.openDatabases, (Object)evaluationParams.getDatabaseId()) && ModelKt.isQueryStatement(statement)) {
                SqliteDatabaseId sqliteDatabaseId = evaluationParams.getDatabaseId();
                Intrinsics.checkNotNull((Object)sqliteDatabaseId);
                this.showAndExecuteSqlStatement(sqliteDatabaseId, statement);
            } else {
                this.currentEvaluationParams = EvaluationParams.copy$default(this.currentEvaluationParams, null, evaluationParams.getStatementText(), 1, null);
                this.view.showSqliteStatement(this.currentEvaluationParams.getStatementText());
            }
        }
    }

    public static /* synthetic */ void setUp$default(SqliteEvaluatorController sqliteEvaluatorController2, EvaluationParams evaluationParams, int n, Object object) {
        if ((n & 1) != 0) {
            evaluationParams = null;
        }
        sqliteEvaluatorController2.setUp(evaluationParams);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> refreshData() {
        ListenableFuture listenableFuture = this.currentTableController;
        if (listenableFuture == null || (listenableFuture = listenableFuture.refreshData()) == null) {
            ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)Unit.INSTANCE);
            listenableFuture = listenableFuture2;
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"immediateFuture(...)");
        }
        return listenableFuture;
    }

    @Override
    public void notifyDataMightBeStale() {
        block0: {
            TableController tableController2 = this.currentTableController;
            if (tableController2 == null) break block0;
            tableController2.notifyDataMightBeStale();
        }
    }

    public void dispose() {
        this.view.removeListener(this.sqliteEvaluatorViewListener);
        this.listeners.clear();
        this.model.removeListener(this.modelListener);
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @NotNull
    public final ListenableFuture<Unit> showAndExecuteSqlStatement(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        if (!this.openDatabases.contains(databaseId)) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new IllegalStateException("Can't evaluate SQLite statement, unknown database: '" + databaseId.getPath() + "'"));
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFailedFuture(...)");
            return listenableFuture;
        }
        this.currentEvaluationParams = new EvaluationParams(databaseId, sqliteStatement.getSqliteStatementWithInlineParameters());
        this.view.showSqliteStatement(sqliteStatement.getSqliteStatementWithInlineParameters());
        this.view.setDatabases(new ArrayList(this.openDatabases), this.currentEvaluationParams.getDatabaseId());
        return this.executeSqlStatement(databaseId, sqliteStatement);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final EvaluationParams saveEvaluationParams() {
        var2_1 = this.lastUsedEvaluationParams;
        if (var2_1 == null) ** GOTO lbl-1000
        it = var4_2 = var2_1;
        $i$a$-takeIf-SqliteEvaluatorController$saveEvaluationParams$databaseId$1 = false;
        v0 = var3_5 = Intrinsics.areEqual((Object)this.currentEvaluationParams.getStatementText(), (Object)it.getStatementText()) != false ? var4_2 : null;
        if (var3_5 != null) {
            v1 = var3_5.getDatabaseId();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        databaseId = v1;
        return new EvaluationParams(databaseId, this.currentEvaluationParams.getStatementText());
    }

    @Override
    public boolean isLiveUpdateEnabled() {
        TableController tableController2 = this.currentTableController;
        return tableController2 != null ? tableController2.isLiveUpdateEnabled() : this.isLiveUpdatesEnabled;
    }

    @Override
    public int getRowBatchSize() {
        TableController tableController2 = this.currentTableController;
        return tableController2 != null ? tableController2.getRowBatchSize() : this.rowBatchSize;
    }

    private final ListenableFuture<Unit> executeSqlStatement(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        ListenableFuture listenableFuture;
        this.resetTable();
        String newEntry = sqliteStatement.getSqliteStatementWithInlineParameters();
        if (this.queryHistory.contains(newEntry)) {
            this.queryHistory.remove(newEntry);
        } else if (this.queryHistory.size() >= 5) {
            this.queryHistory.removeLast();
        }
        this.queryHistory.addFirst(newEntry);
        this.view.setQueryHistory(CollectionsKt.toList((Iterable)this.queryHistory));
        PropertiesComponent.getInstance((Project)this.project).setList(QUERY_HISTORY_KEY, (Collection)this.queryHistory);
        this.lastUsedEvaluationParams = new EvaluationParams(databaseId, sqliteStatement.getSqliteStatementWithInlineParameters());
        if (ModelKt.isQueryStatement(sqliteStatement)) {
            this.view.showTableView();
            listenableFuture = this.runQuery(databaseId, sqliteStatement);
        } else if (!(databaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId)) {
            listenableFuture = this.runUpdate(databaseId, sqliteStatement);
        } else {
            this.view.showMessagePanel("Modifier statements are disabled on offline databases.");
            ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)Unit.INSTANCE);
            Intrinsics.checkNotNull((Object)listenableFuture2);
            listenableFuture = listenableFuture2;
        }
        return listenableFuture;
    }

    private final void resetTable() {
        TableController controller2;
        if (this.lastUsedEvaluationParams != null) {
            this.lastUsedEvaluationParams = null;
            this.view.getTableView().resetView();
        }
        if ((controller2 = this.currentTableController) != null) {
            this.rowBatchSize = controller2.getRowBatchSize();
            this.isLiveUpdatesEnabled = controller2.isLiveUpdateEnabled();
            Disposer.dispose((Disposable)controller2);
            this.currentTableController = null;
        }
    }

    private final void updateRunSqliteStatementButtonState() {
        this.view.setRunSqliteStatementEnabled(this.currentEvaluationParams.getDatabaseId() != null && !com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.hasParsingError(this.project, this.currentEvaluationParams.getStatementText()));
    }

    private final ListenableFuture<Unit> runQuery(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        this.currentTableController = new TableController(this.project, this.rowBatchSize, this.view.getTableView(), databaseId, (Function0<SqliteTable>)((Function0)SqliteEvaluatorController::runQuery$lambda$2), this.databaseRepository, sqliteStatement, this.getCloseTabInvoked(), this.showExportDialog, this.edtExecutor, this.taskExecutor, this.isLiveUpdatesEnabled);
        Disposable disposable = this;
        TableController tableController2 = this.currentTableController;
        Intrinsics.checkNotNull((Object)tableController2);
        Disposer.register((Disposable)disposable, (Disposable)tableController2);
        TableController tableController3 = this.currentTableController;
        Intrinsics.checkNotNull((Object)tableController3);
        return FutureUtils.catching((ListenableFuture)FutureUtils.transform(tableController3.setUp(), (Executor)this.edtExecutor, arg_0 -> SqliteEvaluatorController.runQuery$lambda$3(this, arg_0)), (Executor)this.edtExecutor, Throwable.class, arg_0 -> SqliteEvaluatorController.runQuery$lambda$4(this, arg_0));
    }

    private final ListenableFuture<Unit> runUpdate(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.catching((ListenableFuture)FutureUtils.transform(this.databaseRepository.executeStatement(databaseId, sqliteStatement), (Executor)this.edtExecutor, arg_0 -> SqliteEvaluatorController.runUpdate$lambda$6(this, databaseId, arg_0)), (Executor)this.edtExecutor, Throwable.class, arg_0 -> SqliteEvaluatorController.runUpdate$lambda$7(this, arg_0)), (Disposable)this);
    }

    private final void updateDefaultMessage() {
        SqliteDatabaseId sqliteDatabaseId = this.currentEvaluationParams.getDatabaseId();
        if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
            this.view.showMessagePanel("Write a query and run it to see results from the selected database.");
        } else if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
            this.view.showMessagePanel("The inspector is not connected to an app process.\nYou can inspect and query data, but data is read-only.");
        } else if (sqliteDatabaseId == null) {
            this.view.showMessagePanel("Select a database from the drop down.");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final SqliteTable runQuery$lambda$2() {
        return null;
    }

    private static final Unit runQuery$lambda$3(SqliteEvaluatorController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showSuccessfulExecutionNotification.invoke((Object)DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
        return Unit.INSTANCE;
    }

    private static final Unit runQuery$lambda$4(SqliteEvaluatorController this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.view.showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]));
        return Unit.INSTANCE;
    }

    private static final Unit runUpdate$lambda$6(SqliteEvaluatorController this$0, SqliteDatabaseId $databaseId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.view.showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
        this$0.showSuccessfulExecutionNotification.invoke((Object)DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it2 = (Listener)element$iv;
            boolean bl = false;
            it2.onSqliteStatementExecuted($databaseId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit runUpdate$lambda$7(SqliteEvaluatorController this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this$0.view.showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]));
        this$0.view.reportError(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]), throwable);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getOpenDatabases$p(SqliteEvaluatorController $this) {
        return $this.openDatabases;
    }

    public static final /* synthetic */ SqliteDatabaseId access$getInitialDatabaseId$p(SqliteEvaluatorController $this) {
        return $this.initialDatabaseId;
    }

    public static final /* synthetic */ void access$resetTable(SqliteEvaluatorController $this) {
        $this.resetTable();
    }

    public static final /* synthetic */ SqliteEvaluatorView access$getView$p(SqliteEvaluatorController $this) {
        return $this.view;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Companion;", "", "<init>", "()V", "QUERY_HISTORY_KEY", "", "MAX_QUERY_HISTORY_SIZE", "", "app-inspection.inspectors.database"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$EvaluationParams;", "", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "statementText", "", "<init>", "(Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Ljava/lang/String;)V", "getDatabaseId", "()Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "getStatementText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "app-inspection.inspectors.database"})
    public static final class EvaluationParams {
        @Nullable
        private final SqliteDatabaseId databaseId;
        @NotNull
        private final String statementText;

        public EvaluationParams(@Nullable SqliteDatabaseId databaseId, @NotNull String statementText) {
            Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
            this.databaseId = databaseId;
            this.statementText = statementText;
        }

        @Nullable
        public final SqliteDatabaseId getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getStatementText() {
            return this.statementText;
        }

        @Nullable
        public final SqliteDatabaseId component1() {
            return this.databaseId;
        }

        @NotNull
        public final String component2() {
            return this.statementText;
        }

        @NotNull
        public final EvaluationParams copy(@Nullable SqliteDatabaseId databaseId, @NotNull String statementText) {
            Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
            return new EvaluationParams(databaseId, statementText);
        }

        public static /* synthetic */ EvaluationParams copy$default(EvaluationParams evaluationParams, SqliteDatabaseId sqliteDatabaseId, String string, int n, Object object) {
            if ((n & 1) != 0) {
                sqliteDatabaseId = evaluationParams.databaseId;
            }
            if ((n & 2) != 0) {
                string = evaluationParams.statementText;
            }
            return evaluationParams.copy(sqliteDatabaseId, string);
        }

        @NotNull
        public String toString() {
            return "EvaluationParams(databaseId=" + this.databaseId + ", statementText=" + this.statementText + ")";
        }

        public int hashCode() {
            int result2 = this.databaseId == null ? 0 : this.databaseId.hashCode();
            result2 = result2 * 31 + this.statementText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EvaluationParams)) {
                return false;
            }
            EvaluationParams evaluationParams = (EvaluationParams)other;
            if (!Intrinsics.areEqual((Object)this.databaseId, (Object)evaluationParams.databaseId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.statementText, (Object)evaluationParams.statementText);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "", "onSqliteStatementExecuted", "", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "app-inspection.inspectors.database"})
    public static interface Listener {
        public void onSqliteStatementExecuted(@NotNull SqliteDatabaseId var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$SqliteEvaluatorViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "<init>", "(Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;)V", "evaluateCurrentStatement", "", "sqliteStatementTextChangedInvoked", "newSqliteStatement", "", "onDatabaseSelected", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "app-inspection.inspectors.database"})
    private final class SqliteEvaluatorViewListenerImpl
    implements SqliteEvaluatorView.Listener {
        @Override
        public void evaluateCurrentStatement() {
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState;
            SqliteDatabaseId databaseId;
            SqliteDatabaseId sqliteDatabaseId = SqliteEvaluatorController.this.currentEvaluationParams.getDatabaseId();
            Intrinsics.checkNotNull((Object)sqliteDatabaseId);
            SqliteDatabaseId sqliteDatabaseId2 = databaseId = sqliteDatabaseId;
            if (sqliteDatabaseId2 instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_OFFLINE;
            } else if (sqliteDatabaseId2 instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_ONLINE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState2 = connectivityState;
            DatabaseInspectorAnalyticsTracker.Companion.getInstance(SqliteEvaluatorController.this.project).trackStatementExecuted(connectivityState2, AppInspectionEvent.DatabaseInspectorEvent.StatementContext.USER_DEFINED_STATEMENT_CONTEXT);
            SqliteEvaluatorController.this.executeSqlStatement(databaseId, UtilsKt.createSqliteStatement$default(SqliteEvaluatorController.this.project, SqliteEvaluatorController.this.currentEvaluationParams.getStatementText(), null, 4, null));
        }

        @Override
        public void sqliteStatementTextChangedInvoked(@NotNull String newSqliteStatement) {
            Intrinsics.checkNotNullParameter((Object)newSqliteStatement, (String)"newSqliteStatement");
            SqliteEvaluatorController.this.currentEvaluationParams = EvaluationParams.copy$default(SqliteEvaluatorController.this.currentEvaluationParams, null, newSqliteStatement, 1, null);
            SqliteEvaluatorController.this.updateRunSqliteStatementButtonState();
        }

        @Override
        public void onDatabaseSelected(@NotNull SqliteDatabaseId databaseId) {
            Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
            SqliteEvaluatorController.this.currentEvaluationParams = EvaluationParams.copy$default(SqliteEvaluatorController.this.currentEvaluationParams, databaseId, null, 2, null);
            if (SqliteEvaluatorController.this.lastUsedEvaluationParams == null) {
                SqliteEvaluatorController.this.updateDefaultMessage();
            }
        }
    }
}

