/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0002\u001a$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"EXPERIMENTAL_AGENT_FILE", "", "EXPERIMENTAL_AGENT_DEV_DIR", "AGENT_FILE", "AGENT_DEV_DIR", "getAgentName", "getAgentDevDir", "createErrorSideChannel", "Lkotlin/Function2;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$ErrorOccurredResponse;", "", "Lcom/android/tools/idea/sqlite/ErrorsSideChannel;", "project", "Lcom/intellij/openapi/project/Project;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nDatabaseInspectorTabProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseInspectorTabProvider.kt\ncom/android/tools/idea/sqlite/DatabaseInspectorTabProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,161:1\n14#2:162\n*S KotlinDebug\n*F\n+ 1 DatabaseInspectorTabProvider.kt\ncom/android/tools/idea/sqlite/DatabaseInspectorTabProviderKt\n*L\n150#1:162\n*E\n"})
public final class DatabaseInspectorTabProviderKt {
    @NotNull
    private static final String EXPERIMENTAL_AGENT_FILE = "database-inspector.jar";
    @NotNull
    private static final String EXPERIMENTAL_AGENT_DEV_DIR = "bazel-bin/tools/base/app-inspection/inspectors/database";
    @NotNull
    private static final String AGENT_FILE = "sqlite-inspection.jar";
    @NotNull
    private static final String AGENT_DEV_DIR = "prebuilts/tools/common/app-inspection/androidx/sqlite";

    private static final String getAgentName() {
        String string;
        Boolean bl = (Boolean)StudioFlags.APP_INSPECTION_USE_EXPERIMENTAL_DATABASE_INSPECTOR.get();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            string = EXPERIMENTAL_AGENT_FILE;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string = AGENT_FILE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String getAgentDevDir() {
        String string;
        Boolean bl = (Boolean)StudioFlags.APP_INSPECTION_USE_EXPERIMENTAL_DATABASE_INSPECTOR.get();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            string = EXPERIMENTAL_AGENT_DEV_DIR;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string = AGENT_DEV_DIR;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final Function2<SqliteInspectorProtocol.Command, SqliteInspectorProtocol.ErrorOccurredResponse, Unit> createErrorSideChannel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (arg_0, arg_1) -> DatabaseInspectorTabProviderKt.createErrorSideChannel$lambda$0(project, arg_0, arg_1);
    }

    private static final Unit createErrorSideChannel$lambda$0(Project $project, SqliteInspectorProtocol.Command command, SqliteInspectorProtocol.ErrorOccurredResponse errorResponse) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)errorResponse, (String)"errorResponse");
        SqliteInspectorProtocol.ErrorContent errorContent = errorResponse.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)errorContent, (String)"getContent(...)");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DatabaseInspectorMessenger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UtilsKt.handleError($project, command, errorContent, logger);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getAgentName() {
        return DatabaseInspectorTabProviderKt.getAgentName();
    }

    public static final /* synthetic */ String access$getAgentDevDir() {
        return DatabaseInspectorTabProviderKt.getAgentDevDir();
    }
}

