/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.settingssync;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.settingssync.DriveFileMetadata;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/settingssync/GoogleDriveClient;", "", "credentialProvider", "Lkotlin/Function0;", "Lcom/google/api/client/auth/oauth2/Credential;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "transport", "Lcom/google/api/client/http/HttpTransport;", "drive", "Lcom/google/api/services/drive/Drive;", "initDrive", "write", "Lcom/android/tools/idea/settingssync/DriveFileMetadata;", "filePath", "", "content", "Ljava/io/InputStream;", "read", "Lkotlin/Pair;", "", "delete", "", "getLatestUpdatedFileMetadata", "deleteOldestFilesOverLimit", "listAllFilesLatestFirst", "", "Lcom/google/api/services/drive/model/File;", "readByFileId", "fileId", "getAllFileIds", "deleteByFileId", "intellij.android.settings-sync"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGoogleDriveClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleDriveClient.kt\ncom/android/tools/idea/settingssync/GoogleDriveClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n24#3:185\n1869#4,2:186\n1869#4,2:188\n1563#4:190\n1634#4,3:191\n*S KotlinDebug\n*F\n+ 1 GoogleDriveClient.kt\ncom/android/tools/idea/settingssync/GoogleDriveClient\n*L\n81#1:185\n109#1:186,2\n139#1:188,2\n169#1:190\n169#1:191,3\n*E\n"})
public final class GoogleDriveClient {
    @NotNull
    private final Function0<Credential> credentialProvider;
    @NotNull
    private final JsonFactory jsonFactory;
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final Drive drive;
    public static final int $stable = 8;

    public GoogleDriveClient(@NotNull Function0<? extends Credential> credentialProvider) {
        Intrinsics.checkNotNullParameter(credentialProvider, (String)"credentialProvider");
        this.credentialProvider = credentialProvider;
        this.jsonFactory = (JsonFactory)new GsonFactory();
        this.transport = (HttpTransport)new NetHttpTransport();
        this.drive = this.initDrive();
    }

    private final Drive initDrive() {
        Drive.Builder builder;
        HttpRequestInitializer initializer = arg_0 -> GoogleDriveClient.initDrive$lambda$1(this, arg_0);
        Drive.Builder $this$initDrive_u24lambda_u242 = builder = new Drive.Builder(this.transport, this.jsonFactory, initializer);
        boolean bl = false;
        $this$initDrive_u24lambda_u242.setApplicationName("Google IDE Settings Sync");
        Drive drive = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)drive, (String)"build(...)");
        return drive;
    }

    @NotNull
    public final DriveFileMetadata write(@NotNull String filePath, @NotNull InputStream content2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        InputStreamContent fileContent = new InputStreamContent("application/zip", content2);
        File fileMetadata = new File().setName(filePath).setParents(CollectionsKt.listOf((Object)"appDataFolder"));
        File file = (File)this.drive.files().create(fileMetadata, (AbstractInputStreamContent)fileContent).setFields("id").execute();
        GoogleDriveClient $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GoogleDriveClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Successfully write " + filePath + " to the google drive, reference file id = " + file.getId());
        String string = file.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return new DriveFileMetadata(string);
    }

    @Nullable
    public final Pair<byte[], DriveFileMetadata> read(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        DriveFileMetadata driveFileMetadata = this.getLatestUpdatedFileMetadata(filePath);
        if (driveFileMetadata == null) {
            return null;
        }
        DriveFileMetadata fileInfo = driveFileMetadata;
        return new Pair((Object)this.readByFileId(fileInfo.getVersionId()), (Object)fileInfo);
    }

    public final void delete(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Iterable $this$forEach$iv = this.getAllFileIds(filePath);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.deleteByFileId(it);
        }
    }

    @Nullable
    public final DriveFileMetadata getLatestUpdatedFileMetadata(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = this.listAllFilesLatestFirst(filePath);
        if (file == null || (file = (File)CollectionsKt.firstOrNull(file)) == null) {
            return null;
        }
        File file2 = file;
        String string = file2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return new DriveFileMetadata(string);
    }

    public final void deleteOldestFilesOverLimit(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List<File> list = this.listAllFilesLatestFirst(filePath);
        if (list == null) {
            return;
        }
        List<File> files2 = list;
        if (files2.size() <= 10) {
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.takeLast(files2, (int)(files2.size() - 10));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            this.delete(string);
        }
    }

    private final List<File> listAllFilesLatestFirst(String filePath) {
        return ((FileList)this.drive.files().list().setQ("name = '" + filePath + "'").setSpaces("appDataFolder").setFields("nextPageToken, files(id, name, modifiedTime, version)").setOrderBy("modifiedTime desc").execute()).getFiles();
    }

    private final byte[] readByFileId(String fileId) {
        byte[] byArray = this.drive.files().get(fileId).executeMediaAsInputStream().readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllFileIds(String filePath) {
        List list;
        FileList fileList = (FileList)this.drive.files().list().setQ("name = '" + filePath + "'").setSpaces("appDataFolder").setFields("nextPageToken, files(id, name, modifiedTime, version)").execute();
        List list2 = fileList.getFiles();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getId());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void deleteByFileId(String fileId) {
        this.drive.files().delete(fileId).execute();
    }

    private static final void initDrive$lambda$1(GoogleDriveClient this$0, HttpRequest httpRequest) {
        HttpRequest httpRequest2;
        HttpRequest $this$initDrive_u24lambda_u241_u24lambda_u240 = httpRequest2 = httpRequest;
        boolean bl = false;
        $this$initDrive_u24lambda_u241_u24lambda_u240.setConnectTimeout(5000);
        $this$initDrive_u24lambda_u241_u24lambda_u240.setReadTimeout(5000);
        $this$initDrive_u24lambda_u241_u24lambda_u240.setHeaders(new HttpHeaders());
        ((Credential)this$0.credentialProvider.invoke()).initialize($this$initDrive_u24lambda_u241_u24lambda_u240);
    }
}

