/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LaunchUtils {
    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet, @NotNull IDevice device2) {
        return LaunchUtils.canDebugApp(facet) || LaunchUtils.isDebuggableDevice(device2);
    }

    public static boolean canDebugApp(@NotNull AndroidFacet facet) {
        return ProjectSystemUtil.getModuleSystem(facet).isDebuggable();
    }

    public static boolean isDebuggableDevice(@NotNull IDevice device2) {
        String buildType = device2.getProperty("ro.build.type");
        return "userdebug".equals(buildType) || "eng".equals(buildType);
    }

    @Slow
    @WorkerThread
    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet) {
        if (!ExternalSystemUtil.isNoBackgroundMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        if (AndroidFacet.getInstance((Module)facet.getModule()) == null) {
            Logger.getInstance(LaunchUtils.class).warn("calling isWatchFeatureRequired when facet is not ready yet");
            return false;
        }
        try {
            MergedManifestSnapshot info;
            ListenableFuture<MergedManifestSnapshot> future2 = MergedManifestManager.getMergedManifest(facet.getModule());
            while (true) {
                try {
                    info = (MergedManifestSnapshot)future2.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    ProgressManager.checkCanceled();
                    continue;
                }
                break;
            }
            Element usesFeatureElem = info.findUsedFeature("android.hardware.type.watch");
            if (usesFeatureElem != null) {
                String required = usesFeatureElem.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                return StringUtil.isEmpty((String)required) || "true".equals(required);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getInstance(LaunchUtils.class).warn((Throwable)ex);
        }
        return false;
    }

    public static void initiateDismissKeyguard(@NotNull IDevice device2) {
        if (device2.getVersion().isAtLeast(23)) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    device2.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                }
            });
        }
    }
}

