/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.DeployTargetConfigurableWrapper;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.RunConfigurationEditorContext;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class DeploymentTargetOptions {
    @NotNull
    private final List<DeployTargetProvider> myProviders;
    @NotNull
    private final Map<String, DeployTargetConfigurableWrapper> myIdToConfigurableMap;
    @NotNull
    private final Component mySeparator;
    @NotNull
    private final Component myTargetLabel;
    @NotNull
    private final JComboBox<DeployTargetProvider> myTargetComboBox;
    @NotNull
    private final CardLayoutPanel<Configurable, Configurable, JComponent> myCardLayoutPanel;

    DeploymentTargetOptions(@NotNull List<DeployTargetProvider> providers, @NotNull AndroidRunConfigurationEditor editor, @NotNull Project project) {
        this.myProviders = providers;
        this.myIdToConfigurableMap = this.newIdToConfigurableMap(editor, project);
        this.mySeparator = new TitledSeparator("Deployment Target Options");
        this.myTargetLabel = new JBLabel("Target:");
        this.myTargetComboBox = this.newTargetComboBox();
        this.myCardLayoutPanel = new ConfigurableCardPanel();
    }

    @NotNull
    private Map<String, DeployTargetConfigurableWrapper> newIdToConfigurableMap(@NotNull AndroidRunConfigurationEditor editor, @NotNull Project project) {
        RunConfigurationEditorContext context = new RunConfigurationEditorContext(editor.getModuleSelector(), editor.getModuleComboBox());
        return this.myProviders.stream().collect(Collectors.toMap(DeployTargetProvider::getId, provider -> new DeployTargetConfigurableWrapper(project, (Disposable)editor, context, (DeployTargetProvider)provider)));
    }

    @NotNull
    private JComboBox<DeployTargetProvider> newTargetComboBox() {
        ComboBox comboBox2 = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(this.myProviders));
        comboBox2.setRenderer(new DeployTargetProvider.Renderer());
        comboBox2.addActionListener(arg_0 -> this.lambda$newTargetComboBox$1((JComboBox)comboBox2, arg_0));
        return comboBox2;
    }

    void addTo(@NotNull Container container) {
        container.add(this.mySeparator, DeploymentTargetOptions.newSeparatorConstraints());
        container.add(this.myTargetLabel, DeploymentTargetOptions.newTargetLabelConstraints());
        container.add(this.myTargetComboBox, DeploymentTargetOptions.newTargetComboBoxConstraints());
        container.add((Component)this.myCardLayoutPanel, DeploymentTargetOptions.newCardLayoutPanelConstraints());
    }

    @NotNull
    private static Object newSeparatorConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(3);
        constraints.setColSpan(3);
        constraints.setVSizePolicy(0);
        constraints.setFill(1);
        return constraints;
    }

    @NotNull
    private static Object newTargetLabelConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(4);
        constraints.setVSizePolicy(0);
        constraints.setHSizePolicy(0);
        constraints.setFill(1);
        constraints.setIndent(2);
        return constraints;
    }

    @NotNull
    private static Object newTargetComboBoxConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(4);
        constraints.setColumn(1);
        constraints.setFill(1);
        return constraints;
    }

    @NotNull
    private static Object newCardLayoutPanelConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(5);
        constraints.setColSpan(3);
        constraints.setFill(3);
        constraints.setIndent(4);
        return constraints;
    }

    void resetFrom(@NotNull AndroidRunConfigurationBase configuration2) {
        DeployTargetContext context = configuration2.getDeployTargetContext();
        this.myTargetComboBox.setSelectedItem(context.getCurrentDeployTargetProvider());
        int id2 = configuration2.hashCode();
        this.myProviders.forEach(provider -> this.myIdToConfigurableMap.get(provider.getId()).resetFrom(context.getDeployTargetState((DeployTargetProvider)provider), id2));
    }

    void applyTo(@NotNull AndroidRunConfigurationBase configuration2) {
        DeployTargetContext context = configuration2.getDeployTargetContext();
        context.setTargetSelectionMode((DeployTargetProvider)Objects.requireNonNull(this.myTargetComboBox.getSelectedItem()));
        int id2 = configuration2.hashCode();
        this.myProviders.forEach(provider -> this.myIdToConfigurableMap.get(provider.getId()).applyTo(context.getDeployTargetState((DeployTargetProvider)provider), id2));
    }

    @NotNull
    @VisibleForTesting
    JComboBox getTargetComboBox() {
        return this.myTargetComboBox;
    }

    private /* synthetic */ void lambda$newTargetComboBox$1(JComboBox comboBox2, ActionEvent event) {
        DeployTargetProvider provider = (DeployTargetProvider)comboBox2.getSelectedItem();
        if (provider != null) {
            this.myCardLayoutPanel.select((Object)this.myIdToConfigurableMap.get(provider.getId()), true);
        }
    }
}

