/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployTargetProvider {
    @VisibleForTesting
    public static final ExtensionPointName<DeployTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.android.run.deployTargetProvider");
    private static List<DeployTargetProvider> ourTargets;

    @NotNull
    public static List<DeployTargetProvider> getProviders() {
        if (ourTargets == null) {
            ourTargets = Arrays.stream((DeployTargetProvider[])EP_NAME.getExtensions()).filter(DeployTargetProvider::isEnabled).toList();
        }
        return ourTargets;
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract DeployTargetState createState();

    protected boolean isApplicable(boolean testConfiguration) {
        return true;
    }

    public abstract DeployTargetConfigurable createConfigurable(@NotNull Project var1, @NotNull Disposable var2, @NotNull DeployTargetConfigurableContext var3);

    public boolean requiresRuntimePrompt(@NotNull Project project) {
        return false;
    }

    @Nullable
    public DeployTarget showPrompt(@NotNull Project project) {
        throw new IllegalStateException();
    }

    @NotNull
    public abstract DeployTarget getDeployTarget(@NotNull Project var1);

    public abstract boolean canDeployToLocalDevice();

    public static class Renderer
    extends ColoredListCellRenderer<DeployTargetProvider> {
        protected void customizeCellRenderer(@NotNull JList list, DeployTargetProvider value2, int index, boolean selected, boolean hasFocus) {
            this.append(value2.getDisplayName());
        }
    }
}

