/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerPanel;
import com.android.tools.idea.run.editor.AndroidProfilersPanel;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeploymentTargetOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor,
ActionListener {
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private JBLabel myModuleJBLabel;
    private ModulesComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private final DeploymentTargetOptions myDeploymentTargetOptions;
    private JCheckBox myClearLogCheckBox;
    private JCheckBox myShowLogcatCheckBox;
    private JComponent anchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;
    private AndroidDebuggerPanel myAndroidDebuggerPanel;
    private final AndroidProfilersPanel myAndroidProfilersPanel;

    public AndroidRunConfigurationEditor(Project project, Predicate<Module> moduleValidator, T config, boolean showLogcatCheckbox, boolean isAndroidTest, Function<ConfigurationModuleSelector, ConfigurationSpecificEditor<T>> configurationSpecificEditorFactory) {
        Disposer.register((Disposable)project, (Disposable)this);
        this.setupUI();
        this.myModuleSelector = new ConfigurationModuleSelector(this, project, this.myModulesComboBox, (Predicate)moduleValidator, (AndroidRunConfigurationBase)config){
            final /* synthetic */ Predicate val$moduleValidator;
            final /* synthetic */ AndroidRunConfigurationBase val$config;
            {
                this.val$moduleValidator = predicate;
                this.val$config = androidRunConfigurationBase;
                super(project, modulesComboBox);
            }

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                return this.val$moduleValidator.apply((Object)module);
            }

            public JavaRunConfigurationModule getConfigurationModule() {
                AndroidRunConfigurationModule configurationModule = new AndroidRunConfigurationModule(this.getProject(), this.val$config.isTestConfiguration());
                configurationModule.setModule(this.getModule());
                return configurationModule;
            }
        };
        this.myModulesComboBox.addActionListener((ActionListener)this);
        List<DeployTargetProvider> providers = ((AndroidRunConfigurationBase)config).getApplicableDeployTargetProviders();
        switch (providers.size()) {
            case 0: 
            case 1: {
                this.myDeploymentTargetOptions = null;
                break;
            }
            default: {
                this.myDeploymentTargetOptions = new DeploymentTargetOptions(providers, this, project);
                this.myDeploymentTargetOptions.addTo((Container)this.myTabbedPane.getComponentAt(0));
            }
        }
        AndroidDebuggerContext androidDebuggerContext = ((AndroidRunConfigurationBase)config).getAndroidDebuggerContext();
        if (androidDebuggerContext.getAndroidDebuggers().size() > 1) {
            this.myAndroidDebuggerPanel = new AndroidDebuggerPanel((RunConfiguration)config, androidDebuggerContext);
            this.myTabbedPane.add("Debugger", (Component)this.myAndroidDebuggerPanel.getComponent());
        }
        this.myAndroidProfilersPanel = new AndroidProfilersPanel(project, ((AndroidRunConfigurationBase)config).getProfilerState());
        if (!((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
            this.myTabbedPane.add("Profiling", (Component)this.myAndroidProfilersPanel.getComponent());
        }
        this.myConfigurationSpecificEditor = configurationSpecificEditorFactory.apply(this.myModuleSelector);
        Disposer.register((Disposable)this, this.myConfigurationSpecificEditor);
        this.myConfigurationSpecificPanel.add(this.myConfigurationSpecificEditor.getComponent());
        this.myShowLogcatCheckBox.setVisible(showLogcatCheckbox);
        this.checkValidationResults(((AndroidRunConfigurationBase)config).validate(null, () -> this.fireEditorStateChanged()));
    }

    private void checkValidationResults(@NotNull List<ValidationError> errors) {
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        if (ValidationError.Category.PROFILER.equals((Object)topError.getCategory())) {
            this.myTabbedPane.setSelectedComponent((Component)this.myAndroidProfilersPanel.getComponent());
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    protected void resetEditorFrom(@NotNull T configuration2) {
        this.myModuleSelector.reset(configuration2);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.resetFrom((AndroidRunConfigurationBase)configuration2);
        }
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)configuration2).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)configuration2).SHOW_LOGCAT_AUTOMATICALLY);
        this.myConfigurationSpecificEditor.resetFrom(configuration2);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.resetFrom(((AndroidRunConfigurationBase)configuration2).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.resetFrom(((AndroidRunConfigurationBase)configuration2).getProfilerState());
    }

    protected void applyEditorTo(@NotNull T configuration2) {
        this.myModuleSelector.applyTo(configuration2);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.applyTo((AndroidRunConfigurationBase)configuration2);
        }
        ((AndroidRunConfigurationBase)configuration2).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration2).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        this.myConfigurationSpecificEditor.applyTo(configuration2);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.applyTo(((AndroidRunConfigurationBase)configuration2).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.applyTo(((AndroidRunConfigurationBase)configuration2).getProfilerState());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.myPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    @NotNull
    JComboBox getModuleComboBox() {
        return this.myModulesComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myModulesComboBox && this.myConfigurationSpecificEditor instanceof ApplicationRunParameters) {
            ((ApplicationRunParameters)this.myConfigurationSpecificEditor).onModuleChanged();
        }
    }

    @Nullable
    @VisibleForTesting
    DeploymentTargetOptions getDeploymentTargetOptions() {
        return this.myDeploymentTargetOptions;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(46, 14), null, 0, false));
        this.myTabbedPane = new JBTabbedPane();
        this.myPanel.add((Component)this.myTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabbedPane.addTab(AndroidBundle.message("android.run.configuration.general.tab.title", new Object[0]), (Component)panel1);
        this.myModuleJBLabel = new JBLabel();
        this.myModuleJBLabel.setText("Module:");
        this.myModuleJBLabel.setDisplayedMnemonic('M');
        this.myModuleJBLabel.setDisplayedMnemonicIndex(0);
        panel1.add((Component)this.myModuleJBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myModulesComboBox = new ModulesComboBox();
        panel1.add((Component)this.myModulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myConfigurationSpecificPanel = new JPanel();
        this.myConfigurationSpecificPanel.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)this.myConfigurationSpecificPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabbedPane.addTab(AndroidBundle.message("android.run.configuration.misc.tab.title", new Object[0]), (Component)panel2);
        Spacer spacer4 = new Spacer();
        panel2.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel2.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Logcat", (int)0, (int)0, null, null));
        Spacer spacer5 = new Spacer();
        panel3.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myClearLogCheckBox = new JCheckBox();
        this.loadButtonText(this.myClearLogCheckBox, AndroidBundle.message("android.run.configuration.logcat.skip.content.label", new Object[0]));
        panel3.add((Component)this.myClearLogCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myShowLogcatCheckBox = new JCheckBox();
        this.myShowLogcatCheckBox.setText("Show logcat automatically");
        this.myShowLogcatCheckBox.setMnemonic('S');
        this.myShowLogcatCheckBox.setDisplayedMnemonicIndex(0);
        panel3.add((Component)this.myShowLogcatCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myModuleJBLabel.setLabelFor((Component)this.myModulesComboBox);
    }

    private void loadButtonText(AbstractButton component, String text2) {
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text2);
        component.setText(text2);
        if (textWithMnemonic.hasMnemonic()) {
            component.setMnemonic(textWithMnemonic.getMnemonicIndex());
            component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
        }
    }
}

