/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.tasks.LiveUpdateDeployer;
import com.android.tools.idea.editors.liveedit.LiveEditAdvancedConfiguration;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.editors.liveedit.LiveEditService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.projectsystem.ApplicationProjectContext;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.deployment.liveedit.DeviceEventWatcher;
import com.android.tools.idea.run.deployment.liveedit.ErrorReporterKt;
import com.android.tools.idea.run.deployment.liveedit.LiveEditAdbEventsListener;
import com.android.tools.idea.run.deployment.liveedit.LiveEditApp;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompiler;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerInput;
import com.android.tools.idea.run.deployment.liveedit.LiveEditDeviceInfo;
import com.android.tools.idea.run.deployment.liveedit.LiveEditDevices;
import com.android.tools.idea.run.deployment.liveedit.LiveEditStatus;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.MutableIrClassCache;
import com.android.tools.idea.run.deployment.liveedit.PrebuildChecksKt;
import com.android.tools.idea.run.deployment.liveedit.PsiState;
import com.android.tools.idea.run.deployment.liveedit.PsiValidatorKt;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrClass;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarResponse;
import com.android.tools.idea.run.deployment.liveedit.tokens.ApplicationLiveEditServices;
import com.android.tools.idea.run.deployment.liveedit.tokens.BuildSystemLiveEditServices;
import com.android.tools.idea.util.LocalInstallerPathManager;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LiveEditEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class LiveEditProjectMonitor
implements Disposable {
    private static final LogWrapper LOGGER = new LogWrapper(Logger.getInstance(LiveEditProjectMonitor.class));
    @NotNull
    private final Project project;
    @Nullable
    private ApplicationProjectContext applicationProjectContext;
    @Nullable
    private ApplicationLiveEditServices applicationLiveEditServices;
    private final ScheduledExecutorService mainThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private final LiveEditDevices liveEditDevices = new LiveEditDevices();
    private final DeviceEventWatcher deviceWatcher = new DeviceEventWatcher();
    private final ArrayList<PsiFile> bufferedFiles = new ArrayList();
    private final Set<String> filesWithCompilationErrors = new HashSet<String>();
    private final AtomicReference<Boolean> intermediateSyncs = new AtomicReference<Boolean>(Boolean.FALSE);
    private final LiveEditCompiler compiler;
    private final double LE_LOG_FRACTION = 0.1;
    private static final Random randomForLogging = new Random();
    private boolean hasLoggedSinceReset = false;
    private final LiveEditAdbEventsListener adbEventsListener;
    private final ConcurrentLinkedQueue<PsiFile> changedFileQueue = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<PsiFile, PsiState> psiSnapshots = new ConcurrentHashMap();
    private final MutableIrClassCache irClassCache = new MutableIrClassCache();
    private final AtomicInteger pendingRecompositionStatusPolls = new AtomicInteger(0);
    public static final int NUM_RECOMPOSITION_STATUS_POLLS_PER_EDIT = 5;

    public LiveEditProjectMonitor(@NotNull LiveEditService liveEditService, @NotNull Project project) {
        this.project = project;
        this.compiler = new LiveEditCompiler(project, this.irClassCache);
        this.adbEventsListener = liveEditService.getAdbEventsListener();
        Disposer.register((Disposable)liveEditService, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> this.intermediateSyncs.set(Boolean.TRUE));
        this.deviceWatcher.addListener(this.liveEditDevices::handleDeviceLifecycleEvents);
        this.adbEventsListener.addListener(this.deviceWatcher);
        this.liveEditDevices.addListener(this::handleDeviceStatusChange);
    }

    public void resetState() {
        this.bufferedFiles.clear();
        this.filesWithCompilationErrors.clear();
        this.compiler.resetState(this.applicationLiveEditServices);
        this.hasLoggedSinceReset = false;
    }

    @VisibleForTesting
    int numFilesWithCompilationErrors() {
        return this.filesWithCompilationErrors.size();
    }

    @VisibleForTesting
    MutableIrClassCache getIrClassCache() {
        return this.irClassCache;
    }

    @NotNull
    public Set<IDevice> devices() {
        return this.liveEditDevices.devices();
    }

    @NotNull
    public LiveEditStatus status(@NotNull IDevice device2) {
        LiveEditDeviceInfo info = this.liveEditDevices.getInfo(device2);
        return info == null ? LiveEditStatus.Disabled.INSTANCE : info.getStatus();
    }

    private void processQueuedChanges() {
        if (this.changedFileQueue.isEmpty()) {
            return;
        }
        ArrayList<PsiFile> copy = new ArrayList<PsiFile>();
        this.changedFileQueue.removeIf(e -> {
            copy.add((PsiFile)e);
            return true;
        });
        this.updateEditableStatus(LiveEditStatus.InProgress.INSTANCE);
        if (!this.handleChangedMethods(this.project, copy)) {
            this.changedFileQueue.addAll(copy);
            this.mainThreadExecutor.schedule(this::processQueuedChanges, (long)LiveEditAdvancedConfiguration.getInstance().getRefreshRateMs(), TimeUnit.MILLISECONDS);
        }
    }

    public void dispose() {
        this.adbEventsListener.removeListener(this.deviceWatcher);
        this.changedFileQueue.clear();
        this.liveEditDevices.clear();
        this.deviceWatcher.clearListeners();
        this.mainThreadExecutor.shutdownNow();
    }

    public LiveEditCompiler getCompiler() {
        return this.compiler;
    }

    public boolean notifyExecution(@NotNull Collection<IDevice> devices2) {
        HashSet<IDevice> newDevices = new HashSet<IDevice>(devices2);
        newDevices.removeIf(d -> !LiveEditProjectMonitor.supportLiveEdits(d));
        Ref multiDeploy = new Ref((Object)false);
        this.liveEditDevices.update((Function2<? super IDevice, ? super LiveEditStatus, ? extends LiveEditStatus>)((Function2)(oldDevice, status2) -> {
            if (newDevices.contains(oldDevice)) {
                return status2 == LiveEditStatus.NoMultiDeploy.INSTANCE ? LiveEditStatus.Disabled.INSTANCE : status2;
            }
            if (status2 == LiveEditStatus.Disabled.INSTANCE) {
                return status2;
            }
            multiDeploy.set((Object)true);
            return LiveEditStatus.NoMultiDeploy.INSTANCE;
        }));
        return (Boolean)multiDeploy.get();
    }

    public boolean notifyAppRefresh(@NotNull IDevice device2) {
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit() || !LiveEditProjectMonitor.supportLiveEdits(device2)) {
            return false;
        }
        this.liveEditDevices.update(device2, LiveEditStatus.UpToDate.INSTANCE);
        return true;
    }

    public boolean notifyAppDeploy(ApplicationProjectContext applicationProjectContext, IDevice device2, @NotNull LiveEditApp app, List<VirtualFile> openFiles, @NotNull Supplier<Boolean> isLiveEditable) throws ExecutionException, InterruptedException {
        if (!isLiveEditable.get().booleanValue()) {
            LOGGER.info("Can not live edit the app due to either non-debuggability or does not use Compose", new Object[0]);
            this.liveEditDevices.clear(device2);
            return false;
        }
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
            if (LiveEditProjectMonitor.supportLiveEdits(device2) && LiveEditService.usesCompose(this.project)) {
                LiveEditService.getInstance(this.project).notifyLiveEditAvailability(device2);
            }
            LOGGER.info("Live Edit on device disabled via settings.", new Object[0]);
            return false;
        }
        if (!LiveEditProjectMonitor.supportLiveEdits(device2)) {
            LOGGER.info("Live edit not support for device API %d targeting app %s", new Object[]{device2.getVersion().getApiLevel(), this.applicationId()});
            this.liveEditDevices.addDevice(device2, LiveEditStatus.UnsupportedVersion.INSTANCE, app);
            return false;
        }
        LOGGER.info("Creating monitor for project %s targeting app %s", new Object[]{this.project.getName(), this.applicationId()});
        this.liveEditDevices.addDevice(device2, LiveEditStatus.Loading.INSTANCE, app);
        ApplicationLiveEditServices applicationLiveEditServices = BuildSystemLiveEditServices.getApplicationLiveEditServices(applicationProjectContext);
        if (applicationLiveEditServices == null) {
            LOGGER.warning("Build system for live edit is not available for " + String.valueOf(applicationProjectContext), new Object[0]);
            return false;
        }
        this.mainThreadExecutor.submit(() -> {
            this.applicationProjectContext = applicationProjectContext;
            this.applicationLiveEditServices = applicationLiveEditServices;
            this.intermediateSyncs.set(Boolean.FALSE);
            this.resetState();
            if (device2.getClient(this.applicationId()) != null) {
                this.updateEditStatus(device2, LiveEditStatus.UpToDate.INSTANCE);
            }
            this.deviceWatcher.setApplicationId(this.applicationId());
            this.psiSnapshots.clear();
            this.updatePsiSnapshots(openFiles);
            this.irClassCache.clear();
        }).get();
        return true;
    }

    public void updatePsiSnapshot(VirtualFile file) {
        if (!this.shouldLiveEdit()) {
            return;
        }
        this.mainThreadExecutor.submit(() -> this.updatePsiSnapshots(List.of(file)));
    }

    private void updatePsiSnapshots(List<VirtualFile> files2) {
        ReadAction.run(() -> {
            for (VirtualFile file : files2) {
                PsiFile psiFile = this.getPsiInProject(file);
                if (psiFile == null || psiFile.getFileType() != KotlinFileType.INSTANCE || this.psiSnapshots.containsKey(psiFile)) continue;
                this.psiSnapshots.put(psiFile, PsiValidatorKt.getPsiValidationState(psiFile));
            }
        });
    }

    public void fileChanged(VirtualFile file) {
        if (this.liveEditDevices.hasUnsupportedApi()) {
            this.liveEditDevices.update(LiveEditStatus.UnsupportedVersionOtherDevice.INSTANCE);
            return;
        }
        if (!this.shouldLiveEdit()) {
            return;
        }
        if (file instanceof LightVirtualFile) {
            LOGGER.info("Ignoring LightVirtualFiles %s", new Object[]{file.getName()});
            return;
        }
        this.mainThreadExecutor.submit(() -> {
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> this.getPsiInProject(file));
            if (psiFile == null) {
                return;
            }
            this.changedFileQueue.add(psiFile);
            if (ProjectSystemUtil.getProjectSystem(this.project).getSyncManager().isSyncNeeded() || this.intermediateSyncs.get().booleanValue()) {
                this.updateEditStatus(LiveEditStatus.SyncNeeded.INSTANCE);
                return;
            }
            this.processQueuedChanges();
        });
    }

    @RequiresReadLock
    @Nullable
    private PsiFile getPsiInProject(VirtualFile file) {
        if (this.project.isDisposed() || !file.isValid() || !file.isWritable()) {
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)this.project).isInProject(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile != null) {
            return psiFile.getOriginalFile();
        }
        return null;
    }

    private boolean shouldLiveEdit() {
        return LiveEditApplicationConfiguration.getInstance().isLiveEdit() && StringUtil.isNotEmpty((String)this.applicationId()) && this.applicationLiveEditServices != null && !this.liveEditDevices.isUnrecoverable() && !this.liveEditDevices.isDisabled();
    }

    @Nullable
    private String applicationId() {
        if (this.applicationProjectContext == null) {
            return null;
        }
        return this.applicationProjectContext.getApplicationId();
    }

    @VisibleForTesting
    @NotNull
    public LiveEditDevices getLiveEditDevices() {
        return this.liveEditDevices;
    }

    @Trace
    public void onManualLETrigger() {
        this.mainThreadExecutor.schedule(this::doOnManualLETrigger, 0L, TimeUnit.MILLISECONDS);
    }

    @Trace
    public String onAgentTrigger(String path, String vibe) {
        if (this.liveEditDevices.devices().isEmpty()) {
            throw LiveEditUpdateException.Companion.internalErrorVibeEdit("No running application available for Live Edit.");
        }
        if (this.liveEditDevices.isDisabled()) {
            throw LiveEditUpdateException.Companion.internalErrorVibeEdit("Live Edit is not enabled.");
        }
        this.doOnManualLETrigger();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            throw LiveEditUpdateException.Companion.internalErrorVibeEdit(path + " not found in local file system.");
        }
        PsiFile file = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
        while (!this.processChanges(this.project, List.of(file), LiveEditEvent.Mode.MANUAL, vibe)) {
            LOGGER.info("Vibe Edit ProcessChanges was interrupted", new Object[0]);
        }
        return "The runtime behavior has been changed. Check the running device.";
    }

    @VisibleForTesting
    void doOnManualLETrigger() {
        if (this.bufferedFiles.isEmpty()) {
            return;
        }
        this.updateEditableStatus(LiveEditStatus.InProgress.INSTANCE);
        while (!this.processChanges(this.project, this.bufferedFiles, LiveEditService.isLeTriggerOnSave() ? LiveEditEvent.Mode.ON_SAVE : LiveEditEvent.Mode.MANUAL)) {
            LOGGER.info("ProcessChanges was interrupted", new Object[0]);
        }
        this.bufferedFiles.clear();
    }

    @Trace
    boolean handleChangedMethods(Project project, List<PsiFile> changedFiles) {
        LOGGER.info("Change detected for project %s targeting app %s", new Object[]{project.getName(), this.applicationId()});
        if (LiveEditService.Companion.isLeTriggerManual()) {
            if (this.bufferedFiles.size() < 2000) {
                this.bufferedFiles.addAll(changedFiles);
                this.updateEditableStatus(LiveEditStatus.OutOfDate.INSTANCE);
            } else {
                this.updateEditableStatus(LiveEditStatus.createErrorStatus("Too many buffered LE keystrokes. Redeploy app."));
            }
            return true;
        }
        return this.processChanges(project, changedFiles, LiveEditEvent.Mode.AUTO);
    }

    @VisibleForTesting
    boolean processChangesForTest(Project project, List<PsiFile> changedFiles, LiveEditEvent.Mode mode) throws Exception {
        return this.mainThreadExecutor.submit(() -> this.processChanges(project, changedFiles, mode)).get();
    }

    @VisibleForTesting
    void waitForThreadInTest(long timeoutMillis) throws Exception {
        this.mainThreadExecutor.submit(() -> {}).get(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private boolean processChanges(Project project, List<PsiFile> changedFiles, LiveEditEvent.Mode mode) {
        return this.processChanges(project, changedFiles, mode, null);
    }

    @Trace
    private boolean processChanges(Project project, List<PsiFile> changedFiles, LiveEditEvent.Mode mode, String vibe) {
        Optional<LiveEditDesugarResponse> compiled;
        if (vibe != null && changedFiles.size() != 1) {
            throw LiveEditUpdateException.Companion.internalErrorVibeEdit("Vibe Edit mode only support one change at time.");
        }
        LiveEditEvent.Builder event = LiveEditEvent.newBuilder().setMode(mode);
        long start2 = System.nanoTime();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project);
        try {
            PrebuildChecksKt.prebuildChecks(project, changedFiles);
            ArrayList<LiveEditCompilerInput> inputs = new ArrayList<LiveEditCompilerInput>();
            for (PsiFile psiFile : changedFiles) {
                Document doc = psiManager.getDocument(psiFile);
                if (doc != null && psiManager.isUncommited(doc)) {
                    return false;
                }
                PsiState state2 = this.psiSnapshots.get(psiFile);
                inputs.add(new LiveEditCompilerInput(psiFile, state2, vibe));
            }
            boolean unrestricted = LiveEditAdvancedConfiguration.getInstance().getAllowClassStructuralRedefinition();
            compiled = this.compiler.compile(inputs, !LiveEditService.isLeTriggerManual(), unrestricted, this.getDevicesApiLevels());
            if (compiled.isEmpty()) {
                return false;
            }
            for (PsiFile file : changedFiles) {
                this.filesWithCompilationErrors.remove(file.getName());
            }
        }
        catch (LiveEditUpdateException e) {
            boolean recoverable = e.getError().getRecoverable();
            this.updateEditableStatus(recoverable ? LiveEditStatus.createPausedStatus(ErrorReporterKt.errorMessage(e)) : LiveEditStatus.createRerunnableErrorStatus(ErrorReporterKt.errorMessage(e)));
            if (recoverable) {
                for (PsiFile file : changedFiles) {
                    this.filesWithCompilationErrors.add(file.getName());
                }
            }
            if (e.getError() == LiveEditUpdateException.Error.UNABLE_TO_INLINE || e.getError() == LiveEditUpdateException.Error.NON_PRIVATE_INLINE_FUNCTION || !recoverable) {
                event.setStatus(e.getError().getMetric());
                this.logLiveEditEvent(event);
            }
            LOGGER.warning("Live Edit Update Error %s %s", new Object[]{e.getMessage(), e.getDetails()});
            return true;
        }
        if (mode == LiveEditEvent.Mode.AUTO && !this.filesWithCompilationErrors.isEmpty() && !((Boolean)StudioFlags.COMPOSE_DEPLOY_LIVE_EDIT_CONFINED_ANALYSIS.get()).booleanValue()) {
            Optional errorFilename = this.filesWithCompilationErrors.stream().findFirst();
            String errorMsg = ErrorReporterKt.leErrorMessage(LiveEditUpdateException.Error.COMPILATION_ERROR, (String)errorFilename.get());
            this.updateEditStatus(LiveEditStatus.createPausedStatus(errorMsg));
            return true;
        }
        LiveEditDesugarResponse desugaredResponse = compiled.get();
        event.setHasNonCompose(desugaredResponse.getHasNonComposeChanges());
        long compileFinish = System.nanoTime();
        event.setCompileDurationMs(TimeUnit.NANOSECONDS.toMillis(compileFinish - start2));
        LOGGER.info("LiveEdit compile completed in %dms", new Object[]{event.getCompileDurationMs()});
        List errors = this.editableDeviceIterator().map(device2 -> this.pushUpdatesToDevice((String)this.applicationId(), (IDevice)device2, (LiveEditDesugarResponse)desugaredResponse).errors).flatMap(Collection::stream).toList();
        LiveEditEvent.Device device3 = switch (this.devices().size()) {
            case 0 -> LiveEditEvent.Device.NONE;
            case 1 -> {
                if (this.devices().iterator().next().isEmulator()) {
                    yield LiveEditEvent.Device.EMULATOR;
                }
                yield LiveEditEvent.Device.PHYSICAL;
            }
            default -> LiveEditEvent.Device.MULTI;
        };
        event.setTargetDevice(device3);
        if (!errors.isEmpty()) {
            event.setStatus(LiveEditProjectMonitor.errorToStatus((LiveUpdateDeployer.UpdateLiveEditError)errors.get(0)));
        } else {
            event.setStatus(LiveEditEvent.Status.SUCCESS);
            for (IrClass irClass : desugaredResponse.getCompilerOutput().getIrClasses()) {
                this.irClassCache.update(irClass);
            }
        }
        long pushFinish = System.nanoTime();
        event.setPushDurationMs(TimeUnit.NANOSECONDS.toMillis(pushFinish - compileFinish));
        LOGGER.info("LiveEdit push completed in %dms", new Object[]{event.getPushDurationMs()});
        this.logLiveEditEvent(event);
        return true;
    }

    @NotNull
    private Set<Integer> getDevicesApiLevels() {
        return this.editableDeviceIterator().map(device2 -> this.liveEditDevices.getInfo((IDevice)device2).getApp().getMinAPI()).collect(Collectors.toSet());
    }

    public void requestRerun() {
        for (IDevice device2 : AndroidDebugBridge.getBridge().getDevices()) {
            this.liveEditDevices.addDevice(device2, LiveEditStatus.createRerunnableErrorStatus("Re-run application to start Live Edit updates."));
        }
    }

    @VisibleForTesting
    void scheduleErrorPolling(LiveUpdateDeployer deployer, Installer installer, AdbClient adb, String packageName) {
        if (this.pendingRecompositionStatusPolls.getAndSet(5) < 1) {
            this.scheduleNextErrorPolling(deployer, installer, adb, packageName);
        }
    }

    private void scheduleNextErrorPolling(LiveUpdateDeployer deployer, Installer installer, AdbClient adb, String packageName) {
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        scheduler.schedule(() -> {
            int pollsLeft = this.pendingRecompositionStatusPolls.decrementAndGet();
            try {
                List errors = deployer.retrieveComposeStatus(installer, adb, packageName);
                if (!errors.isEmpty()) {
                    Deploy.ComposeException error = (Deploy.ComposeException)errors.get(0);
                    this.updateEditableStatus(LiveEditStatus.createRecomposeErrorStatus(error.getExceptionClassName(), error.getMessage(), error.getRecoverable()));
                }
                if (pollsLeft > 0) {
                    this.scheduleNextErrorPolling(deployer, installer, adb, packageName);
                }
            }
            catch (IOException e) {
                this.updateEditableStatus(LiveEditStatus.createRecomposeRetrievalErrorStatus(e));
                LOGGER.warning(e.toString(), new Object[0]);
            }
        }, 2L, TimeUnit.SECONDS);
    }

    public void clearDevices() {
        this.liveEditDevices.clear();
    }

    private static LiveEditEvent.Status errorToStatus(LiveUpdateDeployer.UpdateLiveEditError error) {
        switch (error.getType()) {
            case ADDED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_METHOD;
            }
            case REMOVED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_METHOD;
            }
            case ADDED_CLASS: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_CLASS;
            }
            case ADDED_FIELD: 
            case MODIFIED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_FIELD;
            }
            case REMOVED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_FIELD;
            }
            case MODIFIED_SUPER: 
            case ADDED_INTERFACE: 
            case REMOVED_INTERFACE: {
                return LiveEditEvent.Status.UNSUPPORTED_MODIFY_INHERITANCE;
            }
            case UNSUPPORTED_COMPOSE_VERSION: {
                return LiveEditEvent.Status.UNSUPPORTED_COMPOSE_RUNTIME_VERSION;
            }
        }
        return LiveEditEvent.Status.UNKNOWN_LIVE_UPDATE_DEPLOYER_ERROR;
    }

    private void logLiveEditEvent(LiveEditEvent.Builder event) {
        if (!this.hasLoggedSinceReset || randomForLogging.nextDouble() < 0.1) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.LIVE_EDIT_EVENT).setLiveEditEvent(event), this.project));
            this.hasLoggedSinceReset = true;
        }
    }

    private void updateEditStatus(@NotNull IDevice device2, @NotNull LiveEditStatus status2) {
        this.liveEditDevices.update(device2, status2);
    }

    private void updateEditStatus(@NotNull LiveEditStatus status2) {
        this.liveEditDevices.update(status2);
    }

    @VisibleForTesting
    void updateEditableStatus(@NotNull LiveEditStatus newStatus) {
        this.liveEditDevices.update((Function2<? super IDevice, ? super LiveEditStatus, ? extends LiveEditStatus>)((Function2)(device2, prevStatus) -> prevStatus.unrecoverable() || prevStatus == LiveEditStatus.Disabled.INSTANCE || prevStatus == LiveEditStatus.NoMultiDeploy.INSTANCE ? prevStatus : newStatus));
    }

    private void handleDeviceStatusChange(Map<IDevice, LiveEditStatus> map2) {
        ActivityTracker.getInstance().inc();
    }

    private Stream<IDevice> editableDeviceIterator() {
        return this.liveEditDevices.devices().stream().filter(IDevice::isOnline).filter(device2 -> this.liveEditDevices.getInfo((IDevice)device2).getStatus() != LiveEditStatus.Disabled.INSTANCE && this.liveEditDevices.getInfo((IDevice)device2).getStatus() != LiveEditStatus.NoMultiDeploy.INSTANCE);
    }

    @VisibleForTesting
    static Installer newInstaller(IDevice device2) {
        MetricsRecorder metrics = new MetricsRecorder();
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        return new AdbInstaller(LocalInstallerPathManager.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)LOGGER, AdbInstaller.Mode.DAEMON);
    }

    private LiveUpdateDeployer.UpdateLiveEditResult pushUpdatesToDevice(String applicationId2, IDevice device2, LiveEditDesugarResponse update2) {
        LiveUpdateDeployer deployer = new LiveUpdateDeployer((ILogger)LOGGER);
        Installer installer = LiveEditProjectMonitor.newInstaller(device2);
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        LiveEditAdvancedConfiguration config = LiveEditAdvancedConfiguration.getInstance();
        boolean useDebugMode = config.getUseDebugMode();
        boolean useStructureRedefintion = config.getAllowClassStructuralRedefinition();
        int apiLevel = this.liveEditDevices.getInfo(device2).getApp().getMinAPI();
        LiveUpdateDeployer.UpdateLiveEditsParam param = new LiveUpdateDeployer.UpdateLiveEditsParam(update2.classes(apiLevel), update2.supportClasses(apiLevel), update2.getGroupIds(), update2.getInvalidateMode(), useDebugMode, useStructureRedefintion);
        LiveUpdateDeployer.UpdateLiveEditResult result2 = deployer.updateLiveEdit(installer, adb, applicationId2, param);
        if (this.filesWithCompilationErrors.isEmpty() || ((Boolean)StudioFlags.COMPOSE_DEPLOY_LIVE_EDIT_CONFINED_ANALYSIS.get()).booleanValue()) {
            this.updateEditStatus(device2, LiveEditStatus.UpToDate.INSTANCE);
        } else {
            Optional errorFilename = ((Stream)this.filesWithCompilationErrors.stream().sequential()).findFirst();
            String errorMsg = ErrorReporterKt.leErrorMessage(LiveEditUpdateException.Error.COMPILATION_ERROR, (String)errorFilename.get());
            this.updateEditStatus(device2, LiveEditStatus.createPausedStatus(errorMsg));
        }
        this.scheduleErrorPolling(deployer, installer, adb, applicationId2);
        if (!result2.errors.isEmpty()) {
            LiveUpdateDeployer.UpdateLiveEditError firstProblem = (LiveUpdateDeployer.UpdateLiveEditError)result2.errors.get(0);
            if (firstProblem.getType() == Deploy.UnsupportedChange.Type.UNSUPPORTED_COMPOSE_VERSION) {
                this.updateEditStatus(device2, LiveEditStatus.createComposeVersionError(firstProblem.getMessage()));
            } else {
                this.updateEditStatus(device2, LiveEditStatus.createRerunnableErrorStatus(firstProblem.getMessage()));
            }
        }
        return result2;
    }

    @VisibleForTesting
    boolean isGradleSyncNeeded() {
        return ProjectSystemUtil.getProjectSystem(this.project).getSyncManager().isSyncNeeded() || this.intermediateSyncs.get() != false;
    }

    public static boolean supportLiveEdits(IDevice device2) {
        return device2.getVersion().isAtLeast(30);
    }
}

