/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.annotations.Trace;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.deployment.liveedit.IrClassCache;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerForK1;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerInput;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerOutput;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerUtilsKt;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditOutputBuilder;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.android.tools.idea.run.deployment.liveedit.VibeTransformer;
import com.android.tools.idea.run.deployment.liveedit.VibeTransformerProvider;
import com.android.tools.idea.run.deployment.liveedit.VibeTransformerResult;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugar;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarRequest;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarResponse;
import com.android.tools.idea.run.deployment.liveedit.k2.LiveEditCompilerForK2;
import com.android.tools.idea.run.deployment.liveedit.tokens.ApplicationLiveEditServices;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JD\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\u0012\b\u0002\u0010$\u001a\f\u0012\b\u0012\u00060&j\u0002`'0%H\u0007J$\u0010(\u001a\u0010\u0012\f\u0012\n\u0018\u00010*j\u0004\u0018\u0001`+0)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010/\u001a\u00020.2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u00100\u001a\u00020.2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompiler;", "", "project", "Lcom/intellij/openapi/project/Project;", "irClassCache", "Lcom/android/tools/idea/run/deployment/liveedit/IrClassCache;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/run/deployment/liveedit/IrClassCache;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "applicationLiveEditServices", "Lcom/android/tools/idea/run/deployment/liveedit/tokens/ApplicationLiveEditServices;", "LOGGER", "Lcom/android/tools/idea/log/LogWrapper;", "inlineCandidateCache", "Ljava/util/LinkedHashMap;", "", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidate;", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidateCache;", "getInlineCandidateCache", "()Ljava/util/LinkedHashMap;", "setInlineCandidateCache", "(Ljava/util/LinkedHashMap;)V", "desugarer", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar;", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "compile", "Ljava/util/Optional;", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarResponse;", "inputs", "", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompilerInput;", "giveWritePriority", "", "unrestricted", "apiVersions", "", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "toComputable", "Lcom/intellij/openapi/util/Computable;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cmd", "Lkotlin/Function0;", "", "setApplicationLiveEditServicesForTests", "resetState", "LiveEditCompilerForKotlinVersion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditCompiler.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1761#2,3:222\n1617#2,9:225\n1869#2:234\n1870#2:236\n1626#2:237\n1#3:235\n1#3:238\n*S KotlinDebug\n*F\n+ 1 LiveEditCompiler.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditCompiler\n*L\n141#1:222,3\n159#1:225,9\n159#1:234\n159#1:236\n159#1:237\n159#1:235\n*E\n"})
public final class LiveEditCompiler {
    @NotNull
    private final Project project;
    @NotNull
    private final IrClassCache irClassCache;
    @Nullable
    private ApplicationLiveEditServices applicationLiveEditServices;
    @NotNull
    private final LogWrapper LOGGER;
    @NotNull
    private LinkedHashMap<String, SourceInlineCandidate> inlineCandidateCache;
    @Nullable
    private LiveEditDesugar desugarer;
    @NotNull
    private final LiveEditLogger logger;

    public LiveEditCompiler(@NotNull Project project, @NotNull IrClassCache irClassCache) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)irClassCache, (String)"irClassCache");
        this.project = project;
        this.irClassCache = irClassCache;
        this.LOGGER = new LogWrapper(Logger.getInstance(LiveEditCompiler.class));
        this.inlineCandidateCache = new LinkedHashMap();
        this.logger = new LiveEditLogger("LE Compiler");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LinkedHashMap<String, SourceInlineCandidate> getInlineCandidateCache() {
        return this.inlineCandidateCache;
    }

    public final void setInlineCandidateCache(@NotNull LinkedHashMap<String, SourceInlineCandidate> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, (String)"<set-?>");
        this.inlineCandidateCache = linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    @Trace
    @NotNull
    public final Optional<LiveEditDesugarResponse> compile(@NotNull List<LiveEditCompilerInput> inputs, boolean giveWritePriority, boolean unrestricted, @NotNull Set<Integer> apiVersions) {
        Optional<Object> optional;
        boolean needVibeImplementations;
        boolean success;
        Function0 compileCmd;
        Ref.ObjectRef desugaredOutputs;
        ProgressManager progressManager;
        HashMultimap changedFiles;
        block14: {
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter(apiVersions, (String)"apiVersions");
            changedFiles = HashMultimap.create();
            for (LiveEditCompilerInput input2 : inputs) {
                if (!(input2.getFile() instanceof KtFile)) continue;
                changedFiles.put((Object)input2.getFile(), (Object)input2);
            }
            ProgressManager progressManager2 = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager2, (String)"getInstance(...)");
            progressManager = progressManager2;
            desugaredOutputs = new Ref.ObjectRef();
            compileCmd = () -> LiveEditCompiler.compile$lambda$0(changedFiles, this, unrestricted, apiVersions, desugaredOutputs);
            success = true;
            Collection collection2 = changedFiles.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"values(...)");
            Iterable $this$any$iv = collection2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LiveEditCompilerInput it = (LiveEditCompilerInput)element$iv;
                    boolean bl = false;
                    if (!(it.getVibe() != null)) continue;
                    v2 = true;
                    break block14;
                }
                v2 = needVibeImplementations = false;
            }
        }
        if (needVibeImplementations) {
            VibeTransformer transformer;
            VibeTransformerProvider vibeTransformerProvider = (VibeTransformerProvider)ArraysKt.firstOrNull((Object[])VibeTransformerProvider.Companion.getEP_NAME().getExtensions());
            VibeTransformer vibeTransformer = transformer = vibeTransformerProvider != null ? vibeTransformerProvider.createVibeTransformer() : null;
            if (transformer == null) {
                throw LiveEditUpdateException.Companion.internalErrorVibeEdit("No extension for: " + VibeTransformerProvider.Companion.getEP_NAME().getName());
            }
            for (KtFile file : changedFiles.keySet()) {
                void $this$mapNotNullTo$iv$iv;
                Set changes = changedFiles.get((Object)file);
                Intrinsics.checkNotNull((Object)changes);
                Iterable $this$mapNotNull$iv = changes;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    LiveEditCompilerInput it = (LiveEditCompilerInput)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getVibe() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                String prompt = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
                VibeTransformerResult result2 = (VibeTransformerResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VibeTransformerResult>, Object>(transformer, file, prompt, null){
                    int label;
                    final /* synthetic */ VibeTransformer $transformer;
                    final /* synthetic */ KtFile $file;
                    final /* synthetic */ String $prompt;
                    {
                        this.$transformer = $transformer;
                        this.$file = $file;
                        this.$prompt = $prompt;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                KtFile ktFile = this.$file;
                                Intrinsics.checkNotNull((Object)ktFile);
                                this.label = 1;
                                Object object3 = this.$transformer.transformVibe((PsiFile)ktFile, this.$prompt, (Continuation<? super VibeTransformerResult>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super VibeTransformerResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                if (((CharSequence)result2.getError()).length() > 0) {
                    throw LiveEditUpdateException.Companion.internalErrorVibeEdit(result2.getError());
                }
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> LiveEditCompiler.compile$lambda$3(file, result2));
            }
            Thread.sleep(1000L);
        }
        if (giveWritePriority) {
            success = progressManager.runInReadActionWithWriteActionPriority(() -> LiveEditCompiler.compile$lambda$4(compileCmd), progressManager.getProgressIndicator());
        } else {
            Exception exception = (Exception)ApplicationManager.getApplication().runReadAction(this.toComputable((Function0<Unit>)compileCmd));
            if (exception != null) {
                Exception it = exception;
                boolean bl = false;
                throw it;
            }
        }
        if (success) {
            Object object = desugaredOutputs.element;
            Intrinsics.checkNotNull((Object)object);
            Optional<Object> optional2 = Optional.of(object);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else {
            Optional<LiveEditDesugarResponse> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
        }
        return optional;
    }

    public static /* synthetic */ Optional compile$default(LiveEditCompiler liveEditCompiler, List list, boolean bl, boolean bl2, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        return liveEditCompiler.compile(list, bl, bl2, set2);
    }

    private final Computable<Exception> toComputable(Function0<Unit> cmd) {
        return () -> LiveEditCompiler.toComputable$lambda$6(cmd);
    }

    private final ApplicationLiveEditServices applicationLiveEditServices() {
        ApplicationLiveEditServices applicationLiveEditServices = this.applicationLiveEditServices;
        if (applicationLiveEditServices == null) {
            throw new IllegalStateException("not yet initialized".toString());
        }
        return applicationLiveEditServices;
    }

    public final void setApplicationLiveEditServicesForTests(@NotNull ApplicationLiveEditServices applicationLiveEditServices) {
        Intrinsics.checkNotNullParameter((Object)applicationLiveEditServices, (String)"applicationLiveEditServices");
        if (this.applicationLiveEditServices != null) {
            throw new IllegalStateException("applicationLiveEditServices must not be already set".toString());
        }
        this.applicationLiveEditServices = applicationLiveEditServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetState(@NotNull ApplicationLiveEditServices applicationLiveEditServices) {
        Intrinsics.checkNotNullParameter((Object)applicationLiveEditServices, (String)"applicationLiveEditServices");
        this.inlineCandidateCache.clear();
        this.applicationLiveEditServices = applicationLiveEditServices;
        try {
            LiveEditDesugar liveEditDesugar = this.desugarer;
            if (liveEditDesugar != null) {
                liveEditDesugar.close();
            }
        }
        finally {
            this.desugarer = new LiveEditDesugar(applicationLiveEditServices);
        }
    }

    private static final Unit compile$lambda$0(HashMultimap $changedFiles, LiveEditCompiler this$0, boolean $unrestricted, Set $apiVersions, Ref.ObjectRef $desugaredOutputs) {
        LiveEditCompilerOutput.Builder outputBuilder = new LiveEditCompilerOutput.Builder();
        Map map2 = $changedFiles.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"asMap(...)");
        for (Map.Entry entry : map2.entrySet()) {
            KtFile file = (KtFile)entry.getKey();
            Collection input2 = (Collection)entry.getValue();
            if (file.isScript()) continue;
            try {
                LiveEditCompilerForKotlinVersion liveEditCompilerForKotlinVersion;
                if (KotlinPluginModeProvider.Companion.isK2Mode()) {
                    Project project = this$0.project;
                    Intrinsics.checkNotNull((Object)file);
                    Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)file));
                    Intrinsics.checkNotNull((Object)module);
                    liveEditCompilerForKotlinVersion = new LiveEditCompilerForK2(project, module);
                } else {
                    liveEditCompilerForKotlinVersion = new LiveEditCompilerForK1(this$0.project, this$0.inlineCandidateCache);
                }
                ApplicationLiveEditServices applicationLiveEditServices = this$0.applicationLiveEditServices();
                Intrinsics.checkNotNull((Object)file);
                Intrinsics.checkNotNull((Object)input2);
                List<OutputFile> compilerOutput = liveEditCompilerForKotlinVersion.compileKtFile(applicationLiveEditServices, file, input2);
                LiveEditCompilerUtilsKt.validatePsiDiff(input2, file);
                LiveEditOutputBuilder liveEditOutputBuilder = new LiveEditOutputBuilder($unrestricted);
                ApplicationLiveEditServices applicationLiveEditServices2 = this$0.applicationLiveEditServices;
                Intrinsics.checkNotNull((Object)applicationLiveEditServices2);
                liveEditOutputBuilder.getGeneratedCode$intellij_android_core(applicationLiveEditServices2, file, compilerOutput, this$0.irClassCache, this$0.inlineCandidateCache, outputBuilder);
                LiveEditCompilerOutput outputs = outputBuilder.build();
                this$0.logger.dumpCompilerOutputs$intellij_android_core(outputs.getClasses$intellij_android_core());
                LiveEditDesugarRequest request = new LiveEditDesugarRequest(outputs, $apiVersions);
                LiveEditDesugar liveEditDesugar = this$0.desugarer;
                Intrinsics.checkNotNull((Object)liveEditDesugar);
                $desugaredOutputs.element = liveEditDesugar.desugar$intellij_android_core(request);
                LiveEditLogger liveEditLogger = this$0.logger;
                Object object = $desugaredOutputs.element;
                Intrinsics.checkNotNull((Object)object);
                liveEditLogger.dumpDesugarOutputs$intellij_android_core(((LiveEditDesugarResponse)object).getClasses());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (LiveEditUpdateException e) {
                throw e;
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{e.getMessage(), StringsKt.prependIndent((String)ExceptionsKt.stackTraceToString((Throwable)e), (String)"\t")};
                this$0.LOGGER.warning("Internal error during compilation command: %s\n%s", objectArray);
                Intrinsics.checkNotNull((Object)file);
                throw LiveEditUpdateException.Companion.internalErrorCompileCommandException((PsiFile)file, e);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void compile$lambda$3(KtFile $file, VibeTransformerResult $result) {
        $file.getViewProvider().getDocument().setText((CharSequence)$result.getResult());
    }

    private static final void compile$lambda$4(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Exception toComputable$lambda$6(Function0 $cmd) {
        try {
            $cmd.invoke();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompiler$LiveEditCompilerForKotlinVersion;", "", "compileKtFile", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "applicationLiveEditServices", "Lcom/android/tools/idea/run/deployment/liveedit/tokens/ApplicationLiveEditServices;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "inputs", "", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompilerInput;", "intellij.android.core"})
    public static interface LiveEditCompilerForKotlinVersion {
        @NotNull
        public List<OutputFile> compileKtFile(@NotNull ApplicationLiveEditServices var1, @NotNull KtFile var2, @NotNull Collection<LiveEditCompilerInput> var3);
    }
}

