/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.deployable.Process;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Device {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^package:(\\S+)\\s+.*");
    @NotNull
    private final ExecutorService myResolverExecutor;
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final Map<Integer, Process> myPidToProcess = new ConcurrentHashMap<Integer, Process>();
    @NotNull
    private final Map<String, Future<Void>> myResolutions = new ConcurrentHashMap<String, Future<Void>>();

    Device(@NotNull ExecutorService resolverExecutor, @NotNull IDevice device2) {
        this.myResolverExecutor = resolverExecutor;
        this.myIDevice = device2;
    }

    @NotNull
    public List<Client> findClientWithApplicationId(@NotNull String applicationId2) {
        List<Client> clients;
        if (!this.myIDevice.getSystemProperty("ro.build.version.sdk").isDone() || !this.myIDevice.getSystemProperty("ro.build.version.codename").isDone()) {
            return Collections.emptyList();
        }
        if (this.myIDevice.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            return Arrays.stream(this.myIDevice.getClients()).filter(client -> applicationId2.equals(client.getClientData().getPackageName())).collect(Collectors.toList());
        }
        if (this.isLegacyDevice()) {
            this.myResolutions.computeIfAbsent(applicationId2, ignored -> this.resolveLegacyPid(applicationId2));
        }
        if ((clients = this.myPidToProcess.values().stream().filter(process2 -> process2.containsApplicationId(applicationId2)).map(process2 -> process2.getClient()).collect(Collectors.toList())).isEmpty()) {
            for (Client client2 : this.myIDevice.getClients()) {
                if (!applicationId2.equals(client2.getClientData().getProcessName()) && !applicationId2.equals(client2.getClientData().getPackageName())) continue;
                clients.add(client2);
            }
        }
        return clients;
    }

    synchronized void refresh() {
        if (this.myIDevice.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            return;
        }
        HashMap<Integer, Client> clients = new HashMap<Integer, Client>(this.myIDevice.getClients().length);
        for (Client client : this.myIDevice.getClients()) {
            clients.put(client.getClientData().getPid(), client);
        }
        this.myPidToProcess.keySet().retainAll(clients.keySet());
        this.myPidToProcess.keySet().forEach(pid -> {
            Client client = (Client)clients.get(pid);
            if (client != null) {
                this.myPidToProcess.get(pid).setClient(client);
            }
        });
        HashSet addedPids = new HashSet(clients.keySet());
        addedPids.removeAll(this.myPidToProcess.keySet());
        addedPids.forEach(pid -> {
            Client client = (Client)clients.get(pid);
            Process process2 = new Process(client);
            this.myPidToProcess.put((Integer)pid, process2);
            if (!this.isLegacyDevice()) {
                this.resolveApplicationId((int)pid);
            }
        });
        if (this.isLegacyDevice() && !addedPids.isEmpty()) {
            this.myResolutions.values().removeIf(resolution -> {
                resolution.cancel(true);
                return true;
            });
        }
    }

    private boolean isLegacyDevice() {
        return this.myIDevice.getVersion().getFeatureLevel() < 26;
    }

    private void resolveApplicationId(int pid) {
        this.myResolverExecutor.execute(() -> {
            String command = String.format(Locale.US, "stat -c %%u /proc/%d | xargs -n 1 cmd package list packages --uid", pid);
            CollectingOutputReceiver receiver2 = new CollectingOutputReceiver();
            try {
                this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver2);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                Logger.getInstance(Device.class).warn("Could not resolve application ID", e);
                return;
            }
            String output = receiver2.getOutput();
            if (output.isEmpty()) {
                return;
            }
            Matcher m = PACKAGE_NAME_PATTERN.matcher(output);
            ArrayList<String> packageNames = new ArrayList<String>();
            while (m.find()) {
                packageNames.add(m.group(1));
            }
            this.myPidToProcess.computeIfPresent(pid, (key, process2) -> {
                packageNames.forEach(packageName -> process2.addApplicationId((String)packageName));
                return process2;
            });
        });
    }

    @NotNull
    private Future<Void> resolveLegacyPid(@NotNull String applicationId2) {
        return this.myResolverExecutor.submit(() -> {
            String command = String.format("uid=`run-as %s whoami` && for pid in `run-as %s ps | grep -o \"$uid[[:space:]]\\{1,\\}[[:digit:]]\\{1,\\}\" | tr -s ' ' ' ' | cut -d ' ' -f2`; do   if [[ `run-as %s readlink /proc/$pid/exe` == /system/bin/app_process* ]]; then     echo $pid;   fi; done", applicationId2, applicationId2, applicationId2);
            CollectingOutputReceiver receiver2 = new CollectingOutputReceiver();
            this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver2);
            String output = receiver2.getOutput();
            if (output.isEmpty()) {
                return null;
            }
            String[] lines = output.split("\n");
            try {
                for (String line : lines) {
                    int pid = Integer.parseInt(line.trim());
                    this.myPidToProcess.computeIfPresent(pid, (ignored, process2) -> {
                        process2.addApplicationId(applicationId2);
                        return process2;
                    });
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        });
    }
}

