/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.launch;

import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.activity.launch.SpecificActivityLaunch;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidTreeClassChooserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecificActivityConfigurable
implements LaunchOptionConfigurable<SpecificActivityLaunch.State> {
    private final Project myProject;
    private final LaunchOptionConfigurableContext myContext;
    private JPanel myPanel;
    private ComponentWithBrowseButton<EditorTextField> myActivityField;
    private JCheckBox mySkipActivityValidationCheckBox;

    public SpecificActivityConfigurable(final @NotNull Project project, final @NotNull LaunchOptionConfigurableContext context) {
        this.myProject = project;
        this.myContext = context;
        this.setupUI();
        this.myActivityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!project.isInitialized()) {
                    return;
                }
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass activityBaseClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
                if (activityBaseClass == null) {
                    Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.find.activity.class.error", new Object[0]), (String)"Specific Activity Launcher");
                    return;
                }
                Module module = context.getModule();
                if (module == null) {
                    Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)"Specific Activity Launcher");
                    return;
                }
                PsiClass initialSelection = facade.findClass(((EditorTextField)SpecificActivityConfigurable.this.myActivityField.getChildComponent()).getText(), module.getModuleWithDependenciesScope());
                TreeJavaClassChooserDialog chooser = AndroidTreeClassChooserFactory.INSTANCE.createInheritanceClassChooser(project, "Select Activity Class", module.getModuleWithDependenciesScope(), activityBaseClass, initialSelection, null);
                chooser.showDialog();
                PsiClass selClass = chooser.getSelected();
                if (selClass != null) {
                    ((EditorTextField)SpecificActivityConfigurable.this.myActivityField.getChildComponent()).setText(ActivityLocatorUtils.getQualifiedActivityName(selClass));
                }
            }
        });
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Activity:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myPanel.add((Component)this.myActivityField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.mySkipActivityValidationCheckBox = new JCheckBox();
        this.mySkipActivityValidationCheckBox.setText("Skip Activity validation");
        this.myPanel.add((Component)this.mySkipActivityValidationCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }

    private void createUIComponents() {
        LanguageTextField editorTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, this.myProject, ""){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                PsiFile file = PsiDocumentManager.getInstance((Project)SpecificActivityConfigurable.this.myProject).getPsiFile((Document)editor.getDocument());
                if (file != null) {
                    DaemonCodeAnalyzer.getInstance((Project)SpecificActivityConfigurable.this.myProject).setHighlightingEnabled(file, false);
                }
                editor.putUserData(LaunchOptionConfigurableContext.KEY, (Object)SpecificActivityConfigurable.this.myContext);
                return editor;
            }
        };
        this.myActivityField = new ComponentWithBrowseButton((JComponent)editorTextField, null);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public void resetFrom(@NotNull SpecificActivityLaunch.State state2) {
        ((EditorTextField)this.myActivityField.getChildComponent()).setText(StringUtil.notNullize((String)state2.ACTIVITY_CLASS));
        this.mySkipActivityValidationCheckBox.setSelected(state2.SKIP_ACTIVITY_VALIDATION);
    }

    @Override
    public void applyTo(@NotNull SpecificActivityLaunch.State state2) {
        state2.ACTIVITY_CLASS = StringUtil.notNullize((String)((EditorTextField)this.myActivityField.getChildComponent()).getText());
        state2.SKIP_ACTIVITY_VALIDATION = this.mySkipActivityValidationCheckBox.isSelected();
    }
}

