/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.update;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class EntityUpdate {
    private EntityBundle oldState;
    private EntityBundle newState;
    private List<FieldBundle> allFields;
    private Map<String, FieldBundle> unmodifiedFields;
    private Map<String, FieldBundle> modifiedFields;
    private Map<String, FieldBundle> deletedFields;
    private Map<String, FieldBundle> newFields;
    private Map<FieldBundle, String> valuesForUninitializedFields;
    private Map<FieldBundle, String> renamedFields;
    private boolean containsUninitializedNotNullFields;
    private boolean containsRenamedAndModifiedFields;
    private List<IndexBundle> unmodifiedIndices;
    private List<IndexBundle> deletedIndices;
    private List<IndexBundle> newOrModifiedIndices;
    private boolean primaryKeyUpdate;
    private boolean foreignKeysUpdate;

    public EntityUpdate(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        this.checkEntity(oldEntity);
        this.checkEntity(newEntity);
        this.oldState = oldEntity;
        this.newState = newEntity;
        this.allFields = new ArrayList<FieldBundle>(newEntity.getFields());
        this.unmodifiedFields = new HashMap<String, FieldBundle>();
        this.deletedFields = new HashMap<String, FieldBundle>();
        this.modifiedFields = new HashMap<String, FieldBundle>();
        this.newFields = new HashMap<String, FieldBundle>();
        this.renamedFields = new HashMap<FieldBundle, String>();
        this.valuesForUninitializedFields = new HashMap<FieldBundle, String>();
        this.containsUninitializedNotNullFields = false;
        HashMap<String, FieldBundle> oldEntityFields = new HashMap<String, FieldBundle>(oldEntity.getFieldsByColumnName());
        for (FieldBundle newField : newEntity.getFields()) {
            if (oldEntityFields.containsKey(newField.getColumnName())) {
                FieldBundle oldField = (FieldBundle)oldEntityFields.remove(newField.getColumnName());
                if (!oldField.isSchemaEqual(newField)) {
                    this.modifiedFields.put(newField.getColumnName(), newField);
                    continue;
                }
                this.unmodifiedFields.put(newField.getColumnName(), newField);
                continue;
            }
            this.newFields.put(newField.getColumnName(), newField);
            if (!newField.isNonNull() || newField.getDefaultValue() != null && !newField.getDefaultValue().isEmpty()) continue;
            this.containsUninitializedNotNullFields = true;
        }
        this.deletedFields = oldEntityFields;
        this.unmodifiedIndices = new ArrayList<IndexBundle>();
        this.deletedIndices = new ArrayList<IndexBundle>();
        this.newOrModifiedIndices = new ArrayList<IndexBundle>();
        if (oldEntity.getIndices().isEmpty()) {
            this.newOrModifiedIndices.addAll(newEntity.getIndices());
        } else if (newEntity.getIndices().isEmpty()) {
            this.deletedIndices.addAll(oldEntity.getIndices());
        } else {
            Map<String, IndexBundle> oldIndices = oldEntity.getIndices().stream().collect(Collectors.toMap(IndexBundle::getName, index -> index));
            if (newEntity.getIndices() != null) {
                for (IndexBundle newIndex : newEntity.getIndices()) {
                    IndexBundle oldIndex = oldIndices.get(newIndex.getName());
                    if (oldIndex != null) {
                        if (!oldIndex.isSchemaEqual(newIndex)) {
                            this.newOrModifiedIndices.add(newIndex);
                            continue;
                        }
                        this.unmodifiedIndices.add(newIndex);
                        oldIndices.remove(newIndex.getName());
                        continue;
                    }
                    this.newOrModifiedIndices.add(newIndex);
                }
            }
            this.deletedIndices.addAll(oldIndices.values());
        }
        this.primaryKeyUpdate = !oldEntity.getPrimaryKey().isSchemaEqual(newEntity.getPrimaryKey());
        this.foreignKeysUpdate = !SchemaDiffUtil.tablesHaveSameForeignKeyConstraints(oldEntity, newEntity);
        this.containsRenamedAndModifiedFields = false;
    }

    @NotNull
    public EntityBundle getOldState() {
        return this.oldState;
    }

    @NotNull
    public EntityBundle getNewState() {
        return this.newState;
    }

    @NotNull
    public String getOldTableName() {
        return this.oldState.getTableName();
    }

    @NotNull
    public String getNewTableName() {
        return this.newState.getTableName();
    }

    public boolean shouldCreateAnFtsEntity() {
        return this.newState instanceof FtsEntityBundle;
    }

    public boolean shouldRenameTable() {
        return !this.newState.getTableName().equals(this.oldState.getTableName());
    }

    @NotNull
    public List<FieldBundle> getAllFields() {
        return this.allFields;
    }

    @NotNull
    public Map<String, FieldBundle> getUnmodifiedFields() {
        return this.unmodifiedFields;
    }

    @NotNull
    public Map<String, FieldBundle> getModifiedFields() {
        return this.modifiedFields;
    }

    @NotNull
    public Map<String, FieldBundle> getDeletedFields() {
        return this.deletedFields;
    }

    @NotNull
    public Map<String, FieldBundle> getNewFields() {
        return this.newFields;
    }

    @NotNull
    public List<IndexBundle> getIndicesToBeDropped() {
        return this.deletedIndices;
    }

    @NotNull
    public List<IndexBundle> getIndicesToBeCreated() {
        if (this.isComplexUpdate()) {
            ArrayList<IndexBundle> indicesToCreate = new ArrayList<IndexBundle>();
            Stream.of(this.unmodifiedIndices, this.newOrModifiedIndices).forEach(indicesToCreate::addAll);
            return indicesToCreate;
        }
        return this.newOrModifiedIndices;
    }

    public void setValuesForUninitializedFields(@NotNull Map<FieldBundle, String> valuesForUninitializedFields) {
        this.valuesForUninitializedFields = valuesForUninitializedFields;
    }

    @NotNull
    public Map<FieldBundle, String> getValuesForUninitializedFields() {
        return this.valuesForUninitializedFields;
    }

    public void applyRenameMapping(@NotNull Map<String, String> oldToNewNameMapping) {
        for (Map.Entry<String, String> columnNames : oldToNewNameMapping.entrySet()) {
            FieldBundle oldField = this.deletedFields.remove(columnNames.getKey());
            FieldBundle newField = this.newFields.remove(columnNames.getValue());
            if (oldField == null || newField == null) {
                throw new IllegalArgumentException("Invalid old column name to new column name mapping");
            }
            if (!SchemaDiffUtil.isFieldStructureTheSame(oldField, newField)) {
                this.containsRenamedAndModifiedFields = true;
            }
            this.renamedFields.put(newField, oldField.getColumnName());
        }
    }

    @NotNull
    public Map<FieldBundle, String> getRenamedFields() {
        return this.renamedFields;
    }

    public boolean keysWereUpdated() {
        return this.primaryKeyUpdate || this.foreignKeysUpdate;
    }

    public boolean foreignKeysWereUpdated() {
        return this.foreignKeysUpdate;
    }

    public boolean isComplexUpdate() {
        return !this.deletedFields.isEmpty() || !this.modifiedFields.isEmpty() || this.keysWereUpdated() || this.containsUninitializedNotNullFields || this.containsRenamedAndModifiedFields || this.shouldCreateAnFtsEntity();
    }

    private void checkEntity(@NotNull EntityBundle entityBundle) {
        Preconditions.checkArgument((entityBundle.getFields() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the field list is null.");
        Preconditions.checkArgument((entityBundle.getIndices() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the list of indices is null.");
        Preconditions.checkArgument((entityBundle.getPrimaryKey() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the primary key is null.");
        Preconditions.checkArgument((entityBundle.getForeignKeys() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the foreign key list is null.");
    }
}

