/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GenerateMigrationWizardData {
    private Project project;
    private PsiPackage targetPackage;
    private PsiDirectory migrationClassDirectory;
    private PsiDirectory migrationTestDirectory;
    private DatabaseUpdate databaseUpdate;
    private List<EntityUpdate> userIdentifiedEntityUpdates;
    private Map<String, String> renamedTables;
    private Map<String, Map<String, String>> tableToRenamedColumnsMapping;

    GenerateMigrationWizardData(@NotNull Project project, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory migrationClassDirectory, @NotNull PsiDirectory migrationTestDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        this.project = project;
        this.targetPackage = targetPackage;
        this.migrationClassDirectory = migrationClassDirectory;
        this.migrationTestDirectory = migrationTestDirectory;
        this.databaseUpdate = databaseUpdate;
        this.userIdentifiedEntityUpdates = new ArrayList<EntityUpdate>();
        this.renamedTables = new HashMap<String, String>();
        this.tableToRenamedColumnsMapping = new HashMap<String, Map<String, String>>();
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public PsiPackage getTargetPackage() {
        return this.targetPackage;
    }

    @NotNull
    public PsiDirectory getMigrationClassDirectory() {
        return this.migrationClassDirectory;
    }

    @NotNull
    public PsiDirectory getMigrationTestDirectory() {
        return this.migrationTestDirectory;
    }

    @NotNull
    public DatabaseUpdate getDatabaseUpdate() {
        return this.databaseUpdate;
    }

    @NotNull
    public List<EntityUpdate> getUserIdentifiedEntityUpdates() {
        return this.userIdentifiedEntityUpdates;
    }

    @NotNull
    public DatabaseUpdate getUserReviewedDatabaseUpdate() {
        this.databaseUpdate.applyRenameMapping(this.renamedTables);
        for (EntityUpdate entityUpdate : this.databaseUpdate.getModifiedEntities().values()) {
            Map<String, String> renamedColumns = this.tableToRenamedColumnsMapping.get(entityUpdate.getNewTableName());
            if (renamedColumns == null) continue;
            entityUpdate.applyRenameMapping(renamedColumns);
        }
        return this.databaseUpdate;
    }

    public void updateTargetPackage(@NotNull PsiPackage targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void updateMigrationClassDirectory(@NotNull PsiDirectory migrationClassDirectory) {
        this.migrationClassDirectory = migrationClassDirectory;
    }

    public void updateMigrationTestDirectory(PsiDirectory migrationTestDirectory) {
        this.migrationTestDirectory = migrationTestDirectory;
    }

    public void updateRenamedTables(@NotNull Map<String, String> userInput) {
        this.renamedTables = userInput;
    }

    public void updateTableToRenamedColumnsMapping(@NotNull Map<String, Map<String, String>> tableToRenamedColumnsMapping) {
        this.tableToRenamedColumnsMapping = tableToRenamedColumnsMapping;
    }

    public void updateUserIdentifiedEntityUpdates(@NotNull List<EntityUpdate> userIdentifiedEntityUpdates) {
        this.userIdentifiedEntityUpdates = userIdentifiedEntityUpdates;
    }
}

