/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.json;

import com.android.tools.idea.room.migrations.json.DatabaseBundle;
import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.SchemaEquality;
import com.android.tools.idea.room.migrations.json.SchemaEqualityUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SchemaBundle
implements SchemaEquality<SchemaBundle> {
    @SerializedName(value="formatVersion")
    private int mFormatVersion;
    @SerializedName(value="database")
    private DatabaseBundle mDatabase;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapterFactory((TypeAdapterFactory)new EntityTypeAdapterFactory()).create();
    private static final String CHARSET = "UTF-8";
    public static final int LATEST_FORMAT = 1;

    public SchemaBundle(int formatVersion, DatabaseBundle database) {
        this.mFormatVersion = formatVersion;
        this.mDatabase = database;
    }

    public int getFormatVersion() {
        return this.mFormatVersion;
    }

    public DatabaseBundle getDatabase() {
        return this.mDatabase;
    }

    public static SchemaBundle deserialize(InputStream fis) throws UnsupportedEncodingException {
        InputStreamReader is = new InputStreamReader(fis, CHARSET);
        try {
            SchemaBundle schemaBundle = (SchemaBundle)GSON.fromJson((Reader)is, SchemaBundle.class);
            return schemaBundle;
        }
        finally {
            SchemaBundle.safeClose(is);
            SchemaBundle.safeClose(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(SchemaBundle bundle, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
        try {
            GSON.toJson((Object)bundle, (Appendable)osw);
        }
        finally {
            SchemaBundle.safeClose(osw);
            SchemaBundle.safeClose(fos);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSchemaEqual(SchemaBundle other) {
        return SchemaEqualityUtil.checkSchemaEquality(this.mDatabase, other.mDatabase) && this.mFormatVersion == other.mFormatVersion;
    }

    private static class EntityTypeAdapterFactory
    implements TypeAdapterFactory {
        EntityTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> type) {
            if (!EntityBundle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter jsonElementAdapter = gson2.getAdapter(JsonElement.class);
            TypeAdapter entityBundleAdapter = gson2.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EntityBundle.class));
            TypeAdapter ftsEntityBundleAdapter = gson2.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FtsEntityBundle.class));
            return new EntityTypeAdapter((TypeAdapter<JsonElement>)jsonElementAdapter, (TypeAdapter<EntityBundle>)entityBundleAdapter, (TypeAdapter<FtsEntityBundle>)ftsEntityBundleAdapter);
        }

        private static class EntityTypeAdapter
        extends TypeAdapter<EntityBundle> {
            private final TypeAdapter<JsonElement> mJsonElementAdapter;
            private final TypeAdapter<EntityBundle> mEntityBundleAdapter;
            private final TypeAdapter<FtsEntityBundle> mFtsEntityBundleAdapter;

            EntityTypeAdapter(TypeAdapter<JsonElement> jsonElementAdapter, TypeAdapter<EntityBundle> entityBundleAdapter, TypeAdapter<FtsEntityBundle> ftsEntityBundleAdapter) {
                this.mJsonElementAdapter = jsonElementAdapter;
                this.mEntityBundleAdapter = entityBundleAdapter;
                this.mFtsEntityBundleAdapter = ftsEntityBundleAdapter;
            }

            public void write(JsonWriter out, EntityBundle value2) throws IOException {
                if (value2 instanceof FtsEntityBundle) {
                    this.mFtsEntityBundleAdapter.write(out, (Object)((FtsEntityBundle)value2));
                } else {
                    this.mEntityBundleAdapter.write(out, (Object)value2);
                }
            }

            public EntityBundle read(JsonReader in) throws IOException {
                JsonObject jsonObject = ((JsonElement)this.mJsonElementAdapter.read(in)).getAsJsonObject();
                if (jsonObject.has("ftsVersion")) {
                    return (EntityBundle)this.mFtsEntityBundleAdapter.fromJsonTree((JsonElement)jsonObject);
                }
                return (EntityBundle)this.mEntityBundleAdapter.fromJsonTree((JsonElement)jsonObject);
            }
        }
    }
}

