/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.SampleDataHelperKt;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.res.MultiResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SampleDataResourceRepository
extends LocalResourceRepository<VirtualFile>
implements SingleNamespaceResourceRepository,
Disposable {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceRepository.class);
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    private final AtomicReference<CompletableFuture<List<SampleDataResourceItem>>> myUpdateTaskReference = Atomics.newReference(CompletableFuture.completedFuture(ImmutableList.of()));
    private final Executor myUpdateExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"SampleDataResourceRepositoryUpdate", (int)1);

    public SampleDataResourceRepository(@NotNull AndroidFacet androidFacet, @NotNull Disposable parentDisposable) {
        super("Sample Data");
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myAndroidFacet = androidFacet;
        StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(androidFacet);
        this.myNamespace = repositoryManager.getNamespace();
        this.loadItems();
        SampleDataListener.getInstance(androidFacet.getModule().getProject());
    }

    @Override
    public void addParent(@NotNull MultiResourceRepository<VirtualFile> parent) {
        if (!this.myAndroidFacet.isDisposed()) {
            super.addParent(parent);
        }
    }

    void reload() {
        this.loadItems();
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myAndroidFacet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (SampleDataResourceRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return ImmutableSet.of();
    }

    public void dispose() {
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(@NotNull Executor executor, @NotNull Runnable callback2) {
        this.myUpdateTaskReference.get().whenComplete((items, exception) -> executor.execute(callback2));
    }

    private void loadItems() {
        if (this.myAndroidFacet.isDisposed()) {
            return;
        }
        CompletionStage newUpdate = SampleDataHelperKt.loadSampleDataItemsAsync(this.myAndroidFacet, this, this.myUpdateExecutor).whenComplete((items, exception) -> {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (exception != null) {
                    LOG.warn(exception);
                }
                if (items == null || exception != null) {
                    return;
                }
                this.myResourceTable.clear();
                if (!items.isEmpty()) {
                    HashSet<String> alreadyParsedItems = new HashSet<String>();
                    ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
                    for (ResourceItem item : items) {
                        assert (item.getNamespace().equals((Object)this.myNamespace));
                        if (!alreadyParsedItems.add(item.getName())) continue;
                        mapBuilder.put((Object)item.getName(), (Object)item);
                    }
                    this.myResourceTable.put(ResourceType.SAMPLE_DATA, (ListMultimap<String, ResourceItem>)mapBuilder.build());
                }
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches(this, ResourceType.SAMPLE_DATA);
            }
        });
        this.myUpdateTaskReference.getAndSet((CompletableFuture<List<SampleDataResourceItem>>)newUpdate).cancel(true);
    }
}

