/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistryKt;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.res.ids.ResourceClassGenerator;
import com.android.tools.res.ids.ResourceIdManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TimeoutCachedValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0011J \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\"\u0010\"\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f #*\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e0\rH\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/res/ResourceClassRegistry;", "", "packageTimeout", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "()V", "J", "repoMap", "Ljava/util/WeakHashMap;", "Lcom/android/ide/common/resources/ResourceRepository;", "Lcom/android/tools/idea/res/ResourceClassRegistry$ResourceRepositoryInfo;", "packages", "Lcom/intellij/openapi/util/TimeoutCachedValue;", "", "", "addLibrary", "", "repo", "idManager", "Lcom/android/tools/res/ids/ResourceIdManager;", "packageName", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "findClassDefinition", "", "className", "repositoryManager", "Lcom/android/tools/res/ResourceRepositoryManager;", "clearCache", "findClassGenerator", "Lcom/android/tools/res/ids/ResourceClassGenerator;", "repositories", "", "createPackageCache", "kotlin.jvm.PlatformType", "removeRepository", "ResourceRepositoryInfo", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceClassRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceClassRegistry.kt\ncom/android/tools/idea/res/ResourceClassRegistry\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n2396#2,7:158\n1#3:165\n1869#4,2:166\n*S KotlinDebug\n*F\n+ 1 ResourceClassRegistry.kt\ncom/android/tools/idea/res/ResourceClassRegistry\n*L\n116#1:158,7\n127#1:166,2\n*E\n"})
public final class ResourceClassRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long packageTimeout;
    @NotNull
    private final WeakHashMap<ResourceRepository, ResourceRepositoryInfo> repoMap;
    @NotNull
    private TimeoutCachedValue<Set<String>> packages;

    private ResourceClassRegistry(long packageTimeout) {
        this.packageTimeout = packageTimeout;
        this.repoMap = new WeakHashMap();
        this.packages = this.createPackageCache();
    }

    public ResourceClassRegistry() {
        this(ResourceClassRegistryKt.access$getPACKAGE_TIMEOUT$p(), null);
    }

    public final void addLibrary(@NotNull ResourceRepository repo, @NotNull ResourceIdManager idManager, @Nullable String packageName, @NotNull ResourceNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)idManager, (String)"idManager");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        CharSequence charSequence = packageName;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        ResourceRepositoryInfo info = this.repoMap.get(repo);
        if (info == null) {
            info = new ResourceRepositoryInfo(repo, idManager, namespace);
            ((Map)this.repoMap).put(repo, info);
            if (repo instanceof Disposable && !Disposer.tryRegister((Disposable)((Disposable)repo), () -> ResourceClassRegistry.addLibrary$lambda$0(this, repo))) {
                this.removeRepository(repo);
                return;
            }
        }
        info.getPackages().add(packageName);
        this.packages = this.createPackageCache();
    }

    @Nullable
    public final byte[] findClassDefinition(@NotNull String className, @NotNull ResourceRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)repositoryManager, (String)"repositoryManager");
        if (!ResourceClassRegistryKt.access$isRClassName(className)) {
            return null;
        }
        String pkg = StringsKt.substringBeforeLast((String)className, (String)".", (String)"");
        if (((Set)this.packages.get()).contains(pkg)) {
            ResourceNamespace namespace = ResourceNamespace.fromPackageName((String)pkg);
            Intrinsics.checkNotNull((Object)namespace);
            List<ResourceRepository> repositories = repositoryManager.getAppResourcesForNamespace(namespace);
            ResourceClassGenerator resourceClassGenerator = this.findClassGenerator(repositories, className);
            return (byte[])(resourceClassGenerator != null ? resourceClassGenerator.generate(className) : null);
        }
        return null;
    }

    public final void clearCache() {
        this.repoMap.clear();
        this.packages = this.createPackageCache();
    }

    private final ResourceClassGenerator findClassGenerator(List<? extends ResourceRepository> repositories, String className) {
        Object v0;
        Sequence $this$reduceOrNull$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)repositories), arg_0 -> ResourceClassRegistry.findClassGenerator$lambda$1(this, arg_0));
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                ResourceClassGenerator cfr_ignored_0 = (ResourceClassGenerator)iterator$iv.next();
                ResourceClassGenerator cfr_ignored_1 = (ResourceClassGenerator)accumulator$iv;
                boolean bl = false;
                throw new NoClassDefFoundError(className + " class could not be loaded because of package name collision between libraries");
            }
            v0 = accumulator$iv;
        }
        return v0;
    }

    private final TimeoutCachedValue<Set<String>> createPackageCache() {
        return new TimeoutCachedValue(Duration.getInWholeMilliseconds-impl((long)this.packageTimeout), TimeUnit.MILLISECONDS, () -> ResourceClassRegistry.createPackageCache$lambda$5(this));
    }

    private final void removeRepository(ResourceRepository repo) {
        this.repoMap.remove(repo);
        this.packages = this.createPackageCache();
    }

    private static final void addLibrary$lambda$0(ResourceClassRegistry this$0, ResourceRepository $repo) {
        this$0.removeRepository($repo);
    }

    private static final ResourceClassGenerator findClassGenerator$lambda$1(ResourceClassRegistry this$0, ResourceRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceRepositoryInfo resourceRepositoryInfo = this$0.repoMap.get(it);
        return resourceRepositoryInfo != null ? resourceRepositoryInfo.getResourceClassGenerator() : null;
    }

    private static final Set createPackageCache$lambda$5(ResourceClassRegistry this$0) {
        Set set2;
        Set $this$createPackageCache_u24lambda_u245_u24lambda_u244 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        Collection<ResourceRepositoryInfo> collection2 = this$0.repoMap.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceRepositoryInfo it = (ResourceRepositoryInfo)element$iv;
            boolean bl2 = false;
            $this$createPackageCache_u24lambda_u245_u24lambda_u244.addAll((Collection)it.getPackages());
        }
        return SetsKt.build((Set)set2);
    }

    @JvmStatic
    @NotNull
    public static final ResourceClassRegistry get(@NotNull Project project) {
        return Companion.get(project);
    }

    @JvmStatic
    @Nullable
    public static final ResourceClassRegistry getInstanceIfCreated(@NotNull Project project) {
        return Companion.getInstanceIfCreated(project);
    }

    @TestOnly
    public /* synthetic */ ResourceClassRegistry(long packageTimeout, DefaultConstructorMarker $constructor_marker) {
        this(packageTimeout);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/res/ResourceClassRegistry$Companion;", "", "<init>", "()V", "get", "Lcom/android/tools/idea/res/ResourceClassRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nResourceClassRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceClassRegistry.kt\ncom/android/tools/idea/res/ResourceClassRegistry$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,157:1\n30#2,2:158\n58#2:160\n*S KotlinDebug\n*F\n+ 1 ResourceClassRegistry.kt\ncom/android/tools/idea/res/ResourceClassRegistry$Companion\n*L\n146#1:158,2\n154#1:160\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceClassRegistry get(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ResourceClassRegistry> serviceClass$iv = ResourceClassRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceClassRegistry)object;
        }

        @JvmStatic
        @Nullable
        public final ResourceClassRegistry getInstanceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (ResourceClassRegistry)$this$serviceIfCreated$iv.getServiceIfCreated(ResourceClassRegistry.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/ResourceClassRegistry$ResourceRepositoryInfo;", "", "repo", "Lcom/android/ide/common/resources/ResourceRepository;", "idManager", "Lcom/android/tools/res/ids/ResourceIdManager;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "<init>", "(Lcom/android/ide/common/resources/ResourceRepository;Lcom/android/tools/res/ids/ResourceIdManager;Lcom/android/ide/common/rendering/api/ResourceNamespace;)V", "resourceClassGenerator", "Lcom/android/tools/res/ids/ResourceClassGenerator;", "Lorg/jetbrains/annotations/NotNull;", "getResourceClassGenerator", "()Lcom/android/tools/res/ids/ResourceClassGenerator;", "packages", "", "", "getPackages", "()Ljava/util/Set;", "intellij.android.core"})
    private static final class ResourceRepositoryInfo {
        @NotNull
        private final ResourceClassGenerator resourceClassGenerator;
        @NotNull
        private final Set<String> packages;

        public ResourceRepositoryInfo(@NotNull ResourceRepository repo, @NotNull ResourceIdManager idManager, @NotNull ResourceNamespace namespace) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)idManager, (String)"idManager");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            ResourceClassGenerator resourceClassGenerator = ResourceClassGenerator.create(idManager, repo, namespace);
            Intrinsics.checkNotNullExpressionValue((Object)resourceClassGenerator, (String)"create(...)");
            this.resourceClassGenerator = resourceClassGenerator;
            this.packages = new LinkedHashSet();
        }

        @NotNull
        public final ResourceClassGenerator getResourceClassGenerator() {
            return this.resourceClassGenerator;
        }

        @NotNull
        public final Set<String> getPackages() {
            return this.packages;
        }
    }
}

