/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.util.PathString;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.fonts.StudioDownloadableFontCacheService;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.PsiIncludeReference;
import com.android.tools.idea.rendering.ShowFixFactory;
import com.android.tools.idea.rendering.StudioEnvironmentContextKt;
import com.android.tools.idea.rendering.StudioLayoutlibContext;
import com.android.tools.idea.rendering.StudioRenderSecurityManager;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.layoutlib.LayoutlibContext;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.api.EnvironmentContext;
import com.android.tools.rendering.api.IncludeReference;
import com.android.tools.rendering.api.NavGraphResolver;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ApplicationKt;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.navigation.NavXmlHelperKt;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00192\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lcom/android/tools/idea/rendering/StudioEnvironmentContext;", "Lcom/android/tools/rendering/api/EnvironmentContext;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "layoutlibContext", "Lcom/android/tools/layoutlib/LayoutlibContext;", "getLayoutlibContext", "()Lcom/android/tools/layoutlib/LayoutlibContext;", "actionFixFactory", "Lcom/android/tools/rendering/RenderProblem$ActionFixFactory;", "getActionFixFactory", "()Lcom/android/tools/rendering/RenderProblem$ActionFixFactory;", "reportMissingSdkDependency", "", "logger", "Lcom/android/tools/rendering/IRenderLogger;", "createIncludeReference", "Lcom/android/tools/rendering/api/IncludeReference;", "xmlFile", "Lcom/android/tools/rendering/parsers/RenderXmlFile;", "resolver", "Lcom/android/ide/common/rendering/api/RenderResources;", "getFileText", "", "fileName", "getXmlFile", "filePath", "Lcom/android/ide/common/util/PathString;", "getNavGraphResolver", "Lcom/android/tools/rendering/api/NavGraphResolver;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "createRenderSecurityManager", "Lcom/android/tools/rendering/security/RenderSecurityManager;", "projectPath", "platform", "Lcom/android/tools/sdk/AndroidPlatform;", "getOriginalFile", "Lcom/intellij/psi/PsiFile;", "psiFile", "getModuleClassLoaderManager", "Lorg/jetbrains/android/uipreview/StudioModuleClassLoaderManager;", "getCrashReporter", "Lcom/android/tools/analytics/crash/CrashReporter;", "createCrashReport", "Lcom/android/tools/analytics/crash/CrashReport;", "t", "", "isInTest", "", "cleanLayoutlibNativeMemory", "downloadableFontCacheService", "Lcom/android/tools/fonts/DownloadableFontCacheService;", "getDownloadableFontCacheService", "()Lcom/android/tools/fonts/DownloadableFontCacheService;", "useRBytecodeParser", "getUseRBytecodeParser", "()Z", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nStudioEnvironmentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioEnvironmentContext.kt\ncom/android/tools/idea/rendering/StudioEnvironmentContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,180:1\n1#2:181\n30#3,2:182\n*S KotlinDebug\n*F\n+ 1 StudioEnvironmentContext.kt\ncom/android/tools/idea/rendering/StudioEnvironmentContext\n*L\n144#1:182,2\n*E\n"})
public final class StudioEnvironmentContext
implements EnvironmentContext {
    @NotNull
    private final Module module;
    @NotNull
    private final LayoutlibContext layoutlibContext;
    @NotNull
    private final RenderProblem.ActionFixFactory actionFixFactory;

    public StudioEnvironmentContext(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.layoutlibContext = new StudioLayoutlibContext(project);
        this.actionFixFactory = ShowFixFactory.INSTANCE;
    }

    @Override
    @NotNull
    public LayoutlibContext getLayoutlibContext() {
        return this.layoutlibContext;
    }

    @Override
    @NotNull
    public RenderProblem.ActionFixFactory getActionFixFactory() {
        return this.actionFixFactory;
    }

    @Override
    public void reportMissingSdkDependency(@NotNull IRenderLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        RenderProblem.Html html = RenderProblem.create(ProblemSeverity.ERROR);
        Intrinsics.checkNotNullExpressionValue((Object)html, (String)"create(...)");
        RenderProblem.Html message = html;
        logger.addMessage(message);
        message.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createActionLink(StudioEnvironmentContext::reportMissingSdkDependency$lambda$0));
    }

    @Override
    @NotNull
    public IncludeReference createIncludeReference(@NotNull RenderXmlFile xmlFile, @NotNull RenderResources resolver) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        IncludeReference includeReference = PsiIncludeReference.get(xmlFile, resolver);
        Intrinsics.checkNotNullExpressionValue((Object)includeReference, (String)"get(...)");
        return includeReference;
    }

    @Override
    @Nullable
    public String getFileText(@NotNull String fileName) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.module.getProject(), (VirtualFile)virtualFile)) != null) {
            String string;
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                string = psiFile.getText();
            } else {
                Application application = ApplicationManager.getApplication();
                Computable computable = () -> StudioEnvironmentContext.getFileText$lambda$1(psiFile);
                Intrinsics.checkNotNull((Object)computable, (String)"null cannot be cast to non-null type com.intellij.openapi.util.Computable<kotlin.String>");
                string = (String)application.runReadAction(computable);
            }
            return string;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public RenderXmlFile getXmlFile(@NotNull PathString filePath) {
        PsiXmlFile psiXmlFile;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        VirtualFile file = FileExtensions.toVirtualFile$default(filePath, false, 1, null);
        VirtualFile virtualFile = file;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.module.getProject(), (VirtualFile)it);
            XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            virtualFile = xmlFile;
            if (xmlFile != null) {
                it = virtualFile;
                boolean bl2 = false;
                psiXmlFile = new PsiXmlFile((XmlFile)it);
                return psiXmlFile;
            }
        }
        psiXmlFile = null;
        return psiXmlFile;
    }

    @Override
    @NotNull
    public NavGraphResolver getNavGraphResolver(@NotNull ResourceResolver resourceResolver) {
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        WeakReference<Project> projectRef = new WeakReference<Project>(this.module.getProject());
        return arg_0 -> StudioEnvironmentContext.getNavGraphResolver$lambda$5(projectRef, this, resourceResolver, arg_0);
    }

    @Override
    @NotNull
    public RenderSecurityManager createRenderSecurityManager(@Nullable String projectPath, @Nullable AndroidPlatform platform) {
        Object object = platform;
        String sdkPath = object != null && (object = ((AndroidPlatform)object).getSdkData()) != null && (object = ((AndroidSdkData)object).getLocation()) != null ? object.toString() : null;
        StudioRenderSecurityManager securityManager = new StudioRenderSecurityManager(sdkPath, projectPath, false);
        securityManager.setLogger((ILogger)new LogWrapper(Logger.getInstance(StudioRenderSecurityManager.class)).alwaysLogAsDebug(true).allowVerbose(false));
        securityManager.setAppTempDir(PathManager.getTempPath());
        return securityManager;
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile(@NotNull PsiFile psiFile) {
        PsiFile sourcePsiFile;
        VirtualFile renderedVirtualFile;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = renderedVirtualFile = psiFile.getVirtualFile();
        boolean bl = virtualFile != null ? !virtualFile.isInLocalFileSystem() : false;
        if (bl && renderedVirtualFile instanceof BackedVirtualFile && (sourcePsiFile = AndroidPsiUtils.getPsiFileSafely((Project)psiFile.getProject(), (VirtualFile)((BackedVirtualFile)renderedVirtualFile).getOriginFile())) != null) {
            return sourcePsiFile;
        }
        return psiFile;
    }

    @NotNull
    public final StudioModuleClassLoaderManager getModuleClassLoaderManager() {
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<StudioModuleClassLoaderManager> serviceClass$iv = StudioModuleClassLoaderManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (StudioModuleClassLoaderManager)object;
    }

    @Override
    @NotNull
    public CrashReporter getCrashReporter() {
        StudioCrashReporter studioCrashReporter = StudioCrashReporter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioCrashReporter), (String)"getInstance(...)");
        return (CrashReporter)studioCrashReporter;
    }

    @Override
    @NotNull
    public CrashReport createCrashReport(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StudioExceptionReport studioExceptionReport = new StudioExceptionReport.Builder().setThrowable(t, false, true).build();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioExceptionReport), (String)"build(...)");
        return studioExceptionReport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInTest() {
        boolean bl;
        GuiTestingService guiTestingService = GuiTestingService.getInstance();
        if (guiTestingService != null) {
            if (guiTestingService.isGuiTestingMode()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        Application application = ApplicationManager.getApplication();
        if (application == null) return false;
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    @Override
    public void cleanLayoutlibNativeMemory() {
        StudioEnvironmentContextKt.access$getLOG$p().warn("Native memory usage by layoutlib is high, run GC to reclaim what is associated with Java objects.");
        if (!((Boolean)StudioFlags.LAYOUTLIB_NATIVE_MEMORY_CLEAN.get()).booleanValue()) {
            return;
        }
        if (AnalyticsSettings.getOptedIn()) {
            LayoutEditorEvent.Builder layoutEditorEventBuilder = LayoutEditorEvent.newBuilder().setType(LayoutEditorEvent.LayoutEditorEventType.NATIVE_MEMORY_GC);
            AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(layoutEditorEventBuilder.build());
            Intrinsics.checkNotNull((Object)studioEvent);
            UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
        }
        System.gc();
    }

    @Override
    @NotNull
    public DownloadableFontCacheService getDownloadableFontCacheService() {
        return StudioDownloadableFontCacheService.Companion.getInstance();
    }

    @Override
    public boolean getUseRBytecodeParser() {
        Object t = StudioFlags.USE_BYTECODE_R_CLASS_PARSING.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    private static final void reportMissingSdkDependency$lambda$0(Module module) {
        Module module2 = module;
        if (module2 == null || (module2 = module2.getProject()) == null) {
            return;
        }
        Module project = module2;
        ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
        if (ProjectSystemUtil.requiresAndroidModel((Project)project) && service instanceof AndroidProjectSettingsService) {
            ((AndroidProjectSettingsService)service).openSdkSettings();
            return;
        }
        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
    }

    private static final String getFileText$lambda$1(PsiFile $psiFile) {
        return $psiFile.getText();
    }

    private static final String getNavGraphResolver$lambda$5(WeakReference $projectRef, StudioEnvironmentContext this$0, ResourceResolver $resourceResolver, String navGraph) {
        Intrinsics.checkNotNullParameter((Object)navGraph, (String)"navGraph");
        Project project = (Project)$projectRef.get();
        if (project == null) {
            StudioEnvironmentContext $this$getNavGraphResolver_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            Logger.getInstance(StudioRenderSecurityManager.class).warn("getNavGraphResolver for disposed project");
            return null;
        }
        Project project2 = project;
        return NavXmlHelperKt.getStartDestLayoutId(navGraph, project2, $resourceResolver);
    }
}

