/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.rendering.api.IncludeReference;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiIncludeReference
implements IncludeReference {
    @NotNull
    private final VirtualFile myFromFile;

    PsiIncludeReference(@NotNull VirtualFile fromFile) {
        this.myFromFile = fromFile;
    }

    @Override
    @Nullable
    public RenderXmlFile getFromXmlFile(@NotNull Project project) {
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)this.myFromFile);
        return psiFile instanceof XmlFile ? new PsiXmlFile((XmlFile)psiFile) : null;
    }

    @Override
    @NotNull
    public File getFromPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
    }

    @NotNull
    @VisibleForTesting
    String getFromResourceName() {
        return SdkUtils.fileNameToResourceName((String)this.myFromFile.getName());
    }

    @Override
    @NotNull
    public String getFromResourceUrl() {
        return "@layout/" + this.getFromResourceName();
    }

    @NotNull
    public static IncludeReference get(@NotNull RenderXmlFile file, @NotNull RenderResources resolver) {
        VirtualFile source2;
        ResourceValue resValue;
        ResourceUrl layoutUrl;
        String layoutRef;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (IncludeReference)ApplicationManager.getApplication().runReadAction(() -> PsiIncludeReference.get(file, resolver));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RenderXmlTag rootTag = file.getRootTag();
        if (rootTag != null && rootTag.isValid() && (layoutRef = rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools")) != null && (layoutUrl = ResourceUrl.parse((String)layoutRef)) != null && (resValue = IdeResourcesUtil.resolve(resolver, layoutUrl, (XmlElement)((PsiXmlTag)rootTag).getPsiXmlTag())) != null && (source2 = IdeResourcesUtil.resolveLayout(resolver, resValue)) != null) {
            return new PsiIncludeReference(source2);
        }
        return NONE;
    }
}

