/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.project.hyperlink.SyncMessageFragment;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SyncMessage {
    public static final String DEFAULT_GROUP = "Gradle Sync Issues";
    @NotNull
    private final String myGroup;
    @NotNull
    private final MessageType myType;
    @NotNull
    private final String myText;
    @NotNull
    private final Navigatable myNavigatable;
    @Nullable
    private final PositionInFile myPosition;
    @NotNull
    private final List<SyncMessageFragment> myQuickFixes = new ArrayList<SyncMessageFragment>();

    public SyncMessage(@NotNull String group2, @NotNull MessageType type, String ... text2) {
        this(group2, type, NonNavigatable.INSTANCE, text2);
    }

    public SyncMessage(@NotNull Project project, @NotNull String group2, @NotNull MessageType type, @NotNull PositionInFile position, String ... text2) {
        this(group2, type, (Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column), SyncMessage.joinText(text2), position);
    }

    public SyncMessage(@NotNull String group2, @NotNull MessageType type, @NotNull Navigatable navigatable2, String ... text2) {
        this(group2, type, navigatable2, SyncMessage.joinText(text2), (PositionInFile)null);
    }

    private SyncMessage(@NotNull String group2, @NotNull MessageType type, @NotNull Navigatable navigatable2, @NotNull String text2, @Nullable PositionInFile position) {
        this.myGroup = group2;
        this.myType = type;
        this.myNavigatable = navigatable2;
        this.myText = text2;
        this.myPosition = position;
    }

    @NotNull
    public String getGroup() {
        return this.myGroup;
    }

    @NotNull
    public MessageType getType() {
        return this.myType;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    @Nullable
    public PositionInFile getPosition() {
        return this.myPosition;
    }

    public void add(@NotNull Collection<? extends SyncMessageFragment> quickFixes) {
        for (SyncMessageFragment syncMessageFragment : quickFixes) {
            this.add(syncMessageFragment);
        }
    }

    public void add(@NotNull SyncMessageFragment quickFix) {
        this.myQuickFixes.add(quickFix);
    }

    @NotNull
    public List<SyncMessageFragment> getQuickFixes() {
        return ImmutableList.copyOf(this.myQuickFixes);
    }

    @NotNull
    public String toString() {
        return this.myText;
    }

    @TestOnly
    @NotNull
    public String getMessage() {
        String quickFixesPart = this.getQuickFixes().stream().map(it -> it.toHtml()).filter(it -> !it.isEmpty()).collect(Collectors.joining("\n"));
        return this.myText + (String)(quickFixesPart.isEmpty() ? "" : "\n" + quickFixesPart);
    }

    @NotNull
    private static String joinText(@NotNull String[] text2) {
        return String.join((CharSequence)"\n", text2);
    }

    public SyncMessage copy() {
        SyncMessage copy = new SyncMessage(this.myGroup, this.myType, this.myNavigatable, this.myText, this.myPosition);
        copy.add(this.myQuickFixes);
        return copy;
    }
}

