/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.ide.common.blame.Message;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MessageType {
    SIMPLE(1),
    INFO(3),
    ERROR(4),
    WARNING(5);

    private final int myCategoryCode;

    private MessageType(int categoryCode) {
        this.myCategoryCode = categoryCode;
    }

    @Nullable
    public static MessageType findByName(@NotNull String name2) {
        for (MessageType type : MessageType.values()) {
            if (!type.name().equalsIgnoreCase(name2)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static MessageType findMatching(@NotNull Message.Kind kind) {
        String name2 = kind.name();
        MessageType type = MessageType.findByName(name2);
        return type != null ? type : INFO;
    }

    @NotNull
    public NotificationCategory convertToCategory() {
        return NotificationCategory.convert((int)this.myCategoryCode);
    }
}

