/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.LegacyCpuProfilingHandler;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/profilers/commands/LegacyCpuTraceCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "transportStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "eventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "filePathCache", "", "", "<init>", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;)V", "getDevice", "()Lcom/android/ddmlib/IDevice;", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "legacyProfilingRecord", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "Lkotlin/collections/HashMap;", "shouldHandle", "", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "startTrace", "", "stopTrace", "getDeviceTimestamp", "", "record", "sendStartStatusEvent", "startStatus", "Lcom/android/tools/profiler/proto/Trace$TraceStartStatus;", "sendStartTraceEvent", "traceInfo", "Lcom/android/tools/profiler/proto/Trace$TraceInfo;", "sendStopStatusEvent", "Lcom/android/tools/profiler/proto/Trace$TraceStopStatus;", "sendStopTraceEvent", "intellij.android.profilersAndroid"})
public final class LegacyCpuTraceCommandHandler
implements TransportProxy.ProxyCommandHandler {
    @NotNull
    private final IDevice device;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportStub;
    @NotNull
    private final BlockingDeque<Common.Event> eventQueue;
    @NotNull
    private final HashMap<Integer, LegacyCpuTraceRecord> legacyProfilingRecord;

    public LegacyCpuTraceCommandHandler(@NotNull IDevice device2, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub, @NotNull BlockingDeque<Common.Event> eventQueue, @NotNull Map<String, String> filePathCache) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)transportStub, (String)"transportStub");
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        Intrinsics.checkNotNullParameter(filePathCache, (String)"filePathCache");
        this.device = device2;
        this.transportStub = transportStub;
        this.eventQueue = eventQueue;
        this.legacyProfilingRecord = new HashMap();
        LegacyCpuProfilingHandler.INSTANCE.registerDevice(this.device, (Map<Integer, LegacyCpuTraceRecord>)this.legacyProfilingRecord, filePathCache);
    }

    @NotNull
    public final IDevice getDevice() {
        return this.device;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(LegacyCpuTraceCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Override
    public boolean shouldHandle(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        return switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1 -> {
                if (ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)command.getStartTrace().getConfiguration()) == ProfilingConfiguration.TraceType.ART) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)command.getStopTrace().getConfiguration()) == ProfilingConfiguration.TraceType.ART) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1: {
                this.startTrace(command);
                break;
            }
            case 2: {
                this.stopTrace(command);
            }
        }
        Transport.ExecuteResponse executeResponse = Transport.ExecuteResponse.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"getDefaultInstance(...)");
        return executeResponse;
    }

    private final void startTrace(Commands.Command command) {
        Client client;
        Trace.TraceConfiguration traceConfiguration = command.getStartTrace().getConfiguration();
        boolean bl = traceConfiguration.hasArtOptions();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Trace.ArtOptions artOptions = traceConfiguration.getArtOptions();
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client == null) {
            Trace.TraceStartStatus.Builder builder;
            Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u240 = builder = Trace.TraceStartStatus.newBuilder();
            boolean bl2 = false;
            $this$startTrace_u24lambda_u240.setStatus(Trace.TraceStartStatus.Status.FAILURE);
            $this$startTrace_u24lambda_u240.setErrorMessage("App is not running");
            Trace.TraceStartStatus status2 = builder.build();
            Intrinsics.checkNotNull((Object)status2);
            this.sendStartStatusEvent(command, status2);
        } else if (!LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(this.legacyProfilingRecord.get(pid), client)) {
            Trace.TraceStartStatus.Builder builder;
            Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u241 = builder = Trace.TraceStartStatus.newBuilder();
            boolean bl3 = false;
            $this$startTrace_u24lambda_u241.setStatus(Trace.TraceStartStatus.Status.FAILURE);
            $this$startTrace_u24lambda_u241.setErrorMessage("Start request ignored. The app has an on-going profiling session.");
            Trace.TraceStartStatus status3 = builder.build();
            Intrinsics.checkNotNull((Object)status3);
            this.sendStartStatusEvent(command, status3);
        } else {
            DdmPreferences.setProfilerBufferSizeMb((int)artOptions.getBufferSizeInMb());
            long requestTimeNs = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
            LegacyCpuTraceRecord record = new LegacyCpuTraceRecord();
            this.legacyProfilingRecord.put(pid, record);
            try {
                if (artOptions.getTraceMode() == Trace.TraceMode.SAMPLED) {
                    client.startSamplingProfiler(artOptions.getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    client.startMethodTracer();
                }
                record.getStartLatch().await(100L, TimeUnit.MILLISECONDS);
                record.getStartLatch().countDown();
                if (record.isStartFailed()) {
                    Trace.TraceStartStatus.Builder builder;
                    Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u242 = builder = Trace.TraceStartStatus.newBuilder();
                    boolean bl4 = false;
                    $this$startTrace_u24lambda_u242.setStatus(Trace.TraceStartStatus.Status.FAILURE);
                    $this$startTrace_u24lambda_u242.setErrorMessage("Failed to start profiling: " + record.getStartFailureMessage());
                    Trace.TraceStartStatus status4 = builder.build();
                    this.legacyProfilingRecord.remove(pid);
                    Intrinsics.checkNotNull((Object)status4);
                    this.sendStartStatusEvent(command, status4);
                } else {
                    Trace.TraceInfo.Builder builder;
                    Trace.TraceStartStatus.Builder builder2;
                    Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u243 = builder2 = Trace.TraceStartStatus.newBuilder();
                    boolean bl5 = false;
                    $this$startTrace_u24lambda_u243.setStatus(Trace.TraceStartStatus.Status.SUCCESS);
                    Trace.TraceStartStatus status5 = builder2.build();
                    Intrinsics.checkNotNull((Object)status5);
                    this.sendStartStatusEvent(command, status5);
                    Trace.TraceInfo.Builder $this$startTrace_u24lambda_u244 = builder = Trace.TraceInfo.newBuilder();
                    boolean bl6 = false;
                    $this$startTrace_u24lambda_u244.setTraceId(requestTimeNs);
                    $this$startTrace_u24lambda_u244.setConfiguration(traceConfiguration);
                    $this$startTrace_u24lambda_u244.setFromTimestamp(requestTimeNs);
                    $this$startTrace_u24lambda_u244.setToTimestamp(-1L);
                    $this$startTrace_u24lambda_u244.setStartStatus(status5);
                    Trace.TraceInfo.Builder traceInfo = builder;
                    record.setTraceInfo(traceInfo);
                    Trace.TraceInfo traceInfo2 = traceInfo.build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceInfo2, (String)"build(...)");
                    this.sendStartTraceEvent(command, traceInfo2);
                }
            }
            catch (Exception e) {
                Trace.TraceStartStatus.Builder builder;
                Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u245 = builder = Trace.TraceStartStatus.newBuilder();
                boolean bl7 = false;
                $this$startTrace_u24lambda_u245.setStatus(Trace.TraceStartStatus.Status.FAILURE);
                $this$startTrace_u24lambda_u245.setErrorMessage("Failed: " + e);
                Trace.TraceStartStatus status6 = builder.build();
                this.legacyProfilingRecord.remove(pid);
                Intrinsics.checkNotNull((Object)status6);
                this.sendStartStatusEvent(command, status6);
                this.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
    }

    private final void stopTrace(Commands.Command command) {
        Client client;
        Trace.TraceConfiguration traceConfiguration = command.getStopTrace().getConfiguration();
        boolean bl = traceConfiguration.hasArtOptions();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Trace.ArtOptions artOptions = traceConfiguration.getArtOptions();
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client == null) {
            Trace.TraceStopStatus.Builder builder;
            Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u246 = builder = Trace.TraceStopStatus.newBuilder();
            boolean bl2 = false;
            $this$stopTrace_u24lambda_u246.setStatus(Trace.TraceStopStatus.Status.APP_PROCESS_DIED);
            $this$stopTrace_u24lambda_u246.setErrorMessage("App is not running");
            Trace.TraceStopStatus status2 = builder.build();
            Intrinsics.checkNotNull((Object)status2);
            this.sendStopStatusEvent(command, status2);
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (record != null) {
                long endTimeNs = this.getDeviceTimestamp(record);
                Trace.TraceInfo.Builder builder2 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder2);
                Trace.TraceInfo traceInfo = builder2.setToTimestamp(endTimeNs).build();
                Intrinsics.checkNotNullExpressionValue((Object)traceInfo, (String)"build(...)");
                this.sendStopTraceEvent(command, traceInfo);
            }
        } else {
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(record, client)) {
                Trace.TraceStopStatus.Builder endTimeNs;
                Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u247 = endTimeNs = Trace.TraceStopStatus.newBuilder();
                boolean bl3 = false;
                $this$stopTrace_u24lambda_u247.setStatus(Trace.TraceStopStatus.Status.NO_ONGOING_PROFILING);
                $this$stopTrace_u24lambda_u247.setErrorMessage("The app is not being profiled.");
                Trace.TraceStopStatus status3 = endTimeNs.build();
                Intrinsics.checkNotNull((Object)status3);
                this.sendStopStatusEvent(command, status3);
            } else {
                try {
                    if (artOptions.getTraceMode() == Trace.TraceMode.SAMPLED) {
                        client.stopSamplingProfiler();
                    } else {
                        client.stopMethodTracer();
                    }
                    LegacyCpuTraceRecord legacyCpuTraceRecord = record;
                    Intrinsics.checkNotNull((Object)legacyCpuTraceRecord);
                    legacyCpuTraceRecord.getStopLatch().await();
                    long endTimeNs = this.getDeviceTimestamp(record);
                    Trace.TraceInfo.Builder builder = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder);
                    Trace.TraceStopStatus traceStopStatus = builder.getStopStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"getStopStatus(...)");
                    this.sendStopStatusEvent(command, traceStopStatus);
                    Trace.TraceInfo.Builder builder3 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder3);
                    Trace.TraceInfo traceInfo = builder3.setToTimestamp(endTimeNs).build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceInfo, (String)"build(...)");
                    this.sendStopTraceEvent(command, traceInfo);
                }
                catch (Exception e) {
                    Trace.TraceStopStatus.Builder builder;
                    Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u248 = builder = Trace.TraceStopStatus.newBuilder();
                    boolean bl4 = false;
                    $this$stopTrace_u24lambda_u248.setStatus(Trace.TraceStopStatus.Status.STOP_COMMAND_FAILED);
                    $this$stopTrace_u24lambda_u248.setErrorMessage("Failed: " + e);
                    Trace.TraceStopStatus status4 = builder.build();
                    Intrinsics.checkNotNull((Object)status4);
                    this.sendStopStatusEvent(command, status4);
                    this.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
                }
            }
        }
        long requestTime = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
        this.addSessionEndedEvent(this.eventQueue, requestTime, command.getPid(), command.getSessionId());
        this.legacyProfilingRecord.remove(pid);
    }

    private final long getDeviceTimestamp(LegacyCpuTraceRecord record) {
        long endTimeNs = 0L;
        try {
            endTimeNs = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            Trace.TraceInfo.Builder builder = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder);
            endTimeNs = builder.getFromTimestamp() + 1L;
        }
        return endTimeNs;
    }

    private final void sendStartStatusEvent(Commands.Command command, Trace.TraceStartStatus startStatus) {
        Common.Event.Builder builder;
        Common.Event.Builder $this$sendStartStatusEvent_u24lambda_u249 = builder = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStartStatusEvent_u24lambda_u249.setPid(command.getPid());
        $this$sendStartStatusEvent_u24lambda_u249.setKind(Common.Event.Kind.TRACE_STATUS);
        $this$sendStartStatusEvent_u24lambda_u249.setCommandId(command.getCommandId());
        $this$sendStartStatusEvent_u24lambda_u249.setTimestamp(this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs());
        $this$sendStartStatusEvent_u24lambda_u249.setTraceStatus(Trace.TraceStatusData.newBuilder().setTraceStartStatus(startStatus).build());
        Common.Event statusEvent = builder.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStartTraceEvent(Commands.Command command, Trace.TraceInfo traceInfo) {
        Common.Event.Builder builder;
        Common.Event.Builder $this$sendStartTraceEvent_u24lambda_u2410 = builder = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStartTraceEvent_u24lambda_u2410.setPid(command.getPid());
        $this$sendStartTraceEvent_u24lambda_u2410.setKind(Common.Event.Kind.CPU_TRACE);
        $this$sendStartTraceEvent_u24lambda_u2410.setTimestamp(traceInfo.getFromTimestamp());
        $this$sendStartTraceEvent_u24lambda_u2410.setGroupId(traceInfo.getTraceId());
        $this$sendStartTraceEvent_u24lambda_u2410.setTraceData(Trace.TraceData.newBuilder().setTraceStarted(Trace.TraceData.TraceStarted.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder.build();
        this.eventQueue.offer(traceStartEvent);
    }

    private final void sendStopStatusEvent(Commands.Command command, Trace.TraceStopStatus startStatus) {
        Common.Event.Builder builder;
        Common.Event.Builder $this$sendStopStatusEvent_u24lambda_u2411 = builder = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStopStatusEvent_u24lambda_u2411.setPid(command.getPid());
        $this$sendStopStatusEvent_u24lambda_u2411.setKind(Common.Event.Kind.TRACE_STATUS);
        $this$sendStopStatusEvent_u24lambda_u2411.setCommandId(command.getCommandId());
        $this$sendStopStatusEvent_u24lambda_u2411.setTimestamp(this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs());
        $this$sendStopStatusEvent_u24lambda_u2411.setTraceStatus(Trace.TraceStatusData.newBuilder().setTraceStopStatus(startStatus).build());
        Common.Event statusEvent = builder.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStopTraceEvent(Commands.Command command, Trace.TraceInfo traceInfo) {
        Common.Event.Builder builder;
        Common.Event.Builder $this$sendStopTraceEvent_u24lambda_u2412 = builder = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStopTraceEvent_u24lambda_u2412.setPid(command.getPid());
        $this$sendStopTraceEvent_u24lambda_u2412.setKind(Common.Event.Kind.CPU_TRACE);
        $this$sendStopTraceEvent_u24lambda_u2412.setTimestamp(traceInfo.getToTimestamp());
        $this$sendStopTraceEvent_u24lambda_u2412.setGroupId(traceInfo.getTraceId());
        $this$sendStopTraceEvent_u24lambda_u2412.setIsEnded(true);
        $this$sendStopTraceEvent_u24lambda_u2412.setTraceData(Trace.TraceData.newBuilder().setTraceEnded(Trace.TraceData.TraceEnded.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder.build();
        this.eventQueue.offer(traceStartEvent);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Commands.Command.CommandType.values().length];
            try {
                nArray[Commands.Command.CommandType.START_TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Commands.Command.CommandType.STOP_TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

