/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/commands/Artifact;", "", "groupId", "", "artifactId", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroupId", "()Ljava/lang/String;", "getArtifactId", "getVersion", "fileName", "getFileName", "toGMavenUrl", "Ljava/net/URL;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.profilersAndroid"})
public final class Artifact {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @Nullable
    private final String version;
    @NotNull
    private final String fileName;

    public Artifact(@NotNull String groupId, @NotNull String artifactId, @Nullable String version2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version2;
        this.fileName = this.artifactId + "-" + this.version + ".aar";
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final URL toGMavenUrl() {
        return new URL(GoogleMavenRepositoryKt.GMAVEN_BASE_URL + "/" + StringsKt.replace$default((String)this.groupId, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + this.artifactId + "/" + this.version + "/" + this.fileName);
    }

    @NotNull
    public final String component1() {
        return this.groupId;
    }

    @NotNull
    public final String component2() {
        return this.artifactId;
    }

    @Nullable
    public final String component3() {
        return this.version;
    }

    @NotNull
    public final Artifact copy(@NotNull String groupId, @NotNull String artifactId, @Nullable String version2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return new Artifact(groupId, artifactId, version2);
    }

    public static /* synthetic */ Artifact copy$default(Artifact artifact, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifact.groupId;
        }
        if ((n & 2) != 0) {
            string2 = artifact.artifactId;
        }
        if ((n & 4) != 0) {
            string3 = artifact.version;
        }
        return artifact.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Artifact(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result2 = this.groupId.hashCode();
        result2 = result2 * 31 + this.artifactId.hashCode();
        result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)other;
        if (!Intrinsics.areEqual((Object)this.groupId, (Object)artifact.groupId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifactId, (Object)artifact.artifactId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)artifact.version);
    }
}

