/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profilers.ProfilerPreferences;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class TemporaryProfilerPreferences
implements ProfilerPreferences {
    @NotNull
    private static final Map<String, String> ourPreferenceMap = new HashMap<String, String>();

    @NotNull
    public String getValue(@NotNull String name2, @NotNull String defaultValue) {
        if (ourPreferenceMap.containsKey(name2)) {
            return ourPreferenceMap.get(name2);
        }
        return defaultValue;
    }

    public float getFloat(@NotNull String name2, float defaultValue) {
        if (ourPreferenceMap.containsKey(name2)) {
            try {
                return Float.parseFloat(ourPreferenceMap.get(name2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getInt(@NotNull String name2, int defaultValue) {
        if (ourPreferenceMap.containsKey(name2)) {
            try {
                return Integer.parseInt(ourPreferenceMap.get(name2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(@NotNull String name2, boolean defaultValue) {
        if (ourPreferenceMap.containsKey(name2)) {
            return Boolean.parseBoolean(ourPreferenceMap.get(name2));
        }
        return defaultValue;
    }

    public void setValue(@NotNull String name2, @NotNull String value2) {
        ourPreferenceMap.put(name2, value2);
    }

    public void setFloat(@NotNull String name2, float value2) {
        this.setFloat(name2, value2, 0.0f);
    }

    public void setFloat(@NotNull String name2, float value2, float defaultValue) {
        if (Float.compare(value2, defaultValue) == 0) {
            ourPreferenceMap.remove(name2);
        } else {
            ourPreferenceMap.put(name2, Float.toString(value2));
        }
    }

    public void setInt(@NotNull String name2, int value2) {
        this.setInt(name2, value2, 0);
    }

    public void setInt(@NotNull String name2, int value2, int defaultValue) {
        if (value2 == defaultValue) {
            ourPreferenceMap.remove(name2);
        } else {
            ourPreferenceMap.put(name2, Integer.toString(value2));
        }
    }

    public void setBoolean(@NotNull String name2, boolean value2) {
        ourPreferenceMap.put(name2, Boolean.toString(value2));
    }
}

