/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.execution.common.AndroidConfigurationExecutor;
import com.android.tools.idea.execution.common.AndroidConfigurationProgramRunner;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.ProfilerProgramRunnerToken;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.Token;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.configuration.AndroidTileConfigurationType;
import com.android.tools.idea.run.configuration.AndroidWatchFaceConfigurationType;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.google.wireless.android.sdk.stats.RunWithProfilingMetadata;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner;", "Lcom/android/tools/idea/execution/common/AndroidConfigurationProgramRunner;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "supportedConfigurationTypeIds", "", "getSupportedConfigurationTypeIds", "()Ljava/util/List;", "canRunWithMultipleDevices", "run", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "executor", "Lcom/android/tools/idea/execution/common/AndroidConfigurationExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "execute", "Lorg/jetbrains/concurrency/Promise;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "doExecuteInternal", "checkProfileableSupportAndExecute", "Companion", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nProfilerProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProgramRunner.kt\ncom/android/tools/idea/profilers/ProfilerProgramRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class ProfilerProgramRunner
extends AndroidConfigurationProgramRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> supportedConfigurationTypeIds;
    @VisibleForTesting
    public static final int MAX_MESSAGE_LINE_LENGTH = 120;

    public ProfilerProgramRunner() {
        Object[] objectArray = new String[4];
        objectArray[0] = new AndroidRunConfigurationType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)new AndroidTestRunConfigurationType().getId(), (String)"getId(...)");
        objectArray[2] = new AndroidWatchFaceConfigurationType().getId();
        objectArray[3] = new AndroidTileConfigurationType().getId();
        this.supportedConfigurationTypeIds = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getRunnerId() {
        return "ProfilerProgramRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!super.canRun(executorId, profile)) {
            return false;
        }
        if (!Companion.isProfilerExecutor(executorId)) {
            return false;
        }
        if (!(profile instanceof RunConfiguration)) {
            return false;
        }
        Project project = ((RunConfiguration)profile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        if (projectSystem.supportsProfilingMode()) {
            AbstractProfilerExecutorGroup<?> abstractProfilerExecutorGroup = AbstractProfilerExecutorGroup.Companion.getInstance();
            if ((abstractProfilerExecutorGroup != null ? (AbstractProfilerExecutorGroup.AbstractProfilerSetting)abstractProfilerExecutorGroup.getRegisteredSettings(executorId) : null) == null) {
                return false;
            }
        } else if (!Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId)) {
            return false;
        }
        ProjectSystemSyncManager $this$canRun_u24lambda_u240 = projectSystem.getSyncManager();
        boolean bl = false;
        return !$this$canRun_u24lambda_u240.isSyncInProgress() && !$this$canRun_u24lambda_u240.isSyncNeeded();
    }

    @Override
    @NotNull
    protected List<String> getSupportedConfigurationTypeIds() {
        return this.supportedConfigurationTypeIds;
    }

    @Override
    protected boolean canRunWithMultipleDevices(@NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return false;
    }

    @Override
    @NotNull
    protected RunContentDescriptor run(@NotNull ExecutionEnvironment environment, @NotNull AndroidConfigurationExecutor executor, @NotNull ProgressIndicator indicator) {
        SwapInfo swapInfo;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        if (!Companion.isProfilerExecutor(string)) {
            throw new RuntimeException("Not a profiler executor");
        }
        SwapInfo swapInfo2 = swapInfo = (SwapInfo)environment.getUserData(SwapInfo.SWAP_INFO_KEY);
        SwapInfo.SwapType swapType = swapInfo2 != null ? swapInfo2.getType() : null;
        return switch (swapType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[swapType.ordinal()]) {
            case 1 -> executor.applyChanges(indicator);
            case 2 -> executor.applyCodeChanges(indicator);
            default -> executor.run(indicator);
        };
    }

    @Override
    @NotNull
    public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        Promise<RunContentDescriptor> promise;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String executorId = string;
        if (Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId)) {
            promise = this.doExecuteInternal(state2, environment);
        } else {
            AbstractProfilerExecutorGroup.AbstractProfilerSetting abstractProfilerSetting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
            ProfilingMode profilingMode = abstractProfilerSetting != null ? abstractProfilerSetting.getProfilingMode() : null;
            switch (profilingMode == null ? -1 : WhenMappings.$EnumSwitchMapping$1[profilingMode.ordinal()]) {
                case 1: 
                case 2: {
                    promise = this.doExecuteInternal(state2, environment);
                    break;
                }
                case 3: {
                    promise = this.checkProfileableSupportAndExecute(state2, environment);
                    break;
                }
                default: {
                    promise = Promises.resolvedPromise(null);
                }
            }
        }
        return promise;
    }

    private final Promise<RunContentDescriptor> doExecuteInternal(RunProfileState state2, ExecutionEnvironment environment) {
        Promise<RunContentDescriptor> descriptor2 = super.execute(environment, state2);
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Companion.createProfilerToolWindow(project, environment.getRunnerAndConfigurationSettings(), environment.getUserData(SwapInfo.SWAP_INFO_KEY) != null, environment.getExecutor().getId());
        return descriptor2;
    }

    private final Promise<RunContentDescriptor> checkProfileableSupportAndExecute(RunProfileState state2, ExecutionEnvironment environment) {
        block2: {
            TaskHomeTabModel taskHomeTabModel;
            Project project = environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            boolean projectSupported = Companion.isProjectSupported(project);
            boolean apiLevelSupported = ProfilerProgramRunner.Companion.isApiLevelSupported(environment);
            boolean systemSupported = ProfilerProgramRunner.Companion.isSystemSupported(environment);
            if (projectSupported && apiLevelSupported && systemSupported) {
                return this.doExecuteInternal(state2, environment);
            }
            Messages.showErrorDialog((Project)environment.getProject(), (String)Companion.buildProfileableRequirementMessage(projectSupported, apiLevelSupported, systemSupported), (String)"Unsupported Device or Emulator");
            if (!((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) break block2;
            Project project2 = environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            AndroidProfilerToolWindow androidProfilerToolWindow = AndroidProfilerToolWindowFactory.Companion.getProfilerToolWindow(project2);
            TaskHomeTabModel taskHomeTabModel2 = taskHomeTabModel = androidProfilerToolWindow != null && (androidProfilerToolWindow = androidProfilerToolWindow.getProfilers()) != null ? androidProfilerToolWindow.getTaskHomeTabModel() : null;
            if (taskHomeTabModel2 != null) {
                taskHomeTabModel2.resetSelectionStateAndClearStartupTaskConfigs();
            }
        }
        return Promises.resolvedPromise();
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution, executorId);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        Companion.createProfilerToolWindow(project, settings);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner$Companion;", "", "<init>", "()V", "MAX_MESSAGE_LINE_LENGTH", "", "createProfilerToolWindow", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isSwapExecution", "", "executorId", "", "isProfilerExecutor", "isProjectSupported", "isApiLevelSupported", "featureLevel", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "isSystemSupported", "isDebuggable", "buildProfileableRequirementMessage", "intellij.android.profilersAndroid"})
    @SourceDebugExtension(value={"SMAP\nProfilerProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProgramRunner.kt\ncom/android/tools/idea/profilers/ProfilerProgramRunner$Companion\n+ 2 Token.kt\ncom/android/tools/idea/projectsystem/TokenKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n47#2:289\n669#3,11:290\n*S KotlinDebug\n*F\n+ 1 ProfilerProgramRunner.kt\ncom/android/tools/idea/profilers/ProfilerProgramRunner$Companion\n*L\n229#1:289\n229#1:290,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationManager.getApplication().assertIsDispatchThread();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
            if (runnerAndConfigurationSettings != null) {
                runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(false);
            }
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Android Profiler");
            if (toolWindow != null) {
                object = toolWindow;
                ToolWindow $this$createProfilerToolWindow_u24lambda_u240 = object;
                boolean bl = false;
                if (!$this$createProfilerToolWindow_u24lambda_u240.isVisible()) {
                    project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                    $this$createProfilerToolWindow_u24lambda_u240.setAvailable(true);
                    $this$createProfilerToolWindow_u24lambda_u240.show(null);
                }
            }
            AndroidProfilerToolWindow androidProfilerToolWindow = AndroidProfilerToolWindowFactory.Companion.getProfilerToolWindow(project);
            if (androidProfilerToolWindow != null) {
                Object $this$createProfilerToolWindow_u24lambda_u241 = object = androidProfilerToolWindow;
                boolean bl = false;
                ((AndroidProfilerToolWindow)((Object)$this$createProfilerToolWindow_u24lambda_u241)).disableAutoProfiling();
                if (!isSwapExecution) {
                    StudioProfilers studioProfilers = ((AndroidProfilerToolWindow)((Object)$this$createProfilerToolWindow_u24lambda_u241)).getProfilers();
                    Intrinsics.checkNotNull((Object)studioProfilers);
                    studioProfilers.getSessionsManager().endCurrentSession();
                }
            }
            StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
            RunWithProfilingMetadata.Builder metadataBuilder = RunWithProfilingMetadata.newBuilder();
            if (executorId != null) {
                Object object2 = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
                if (object2 == null || (object2 = ((AbstractProfilerExecutorGroup.AbstractProfilerSetting)object2).getProfilingMode()) == null) {
                    object2 = ProfilingMode.NOT_SET;
                }
                Object profilingMode = object2;
                metadataBuilder.setProfilingMode(((ProfilingMode)((Object)profilingMode)).getAnalyticsProtoType());
            }
            featureTracker.trackRunWithProfiling(metadataBuilder.build());
        }

        public static /* synthetic */ void createProfilerToolWindow$default(Companion companion, Project project, RunnerAndConfigurationSettings runnerAndConfigurationSettings, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            companion.createProfilerToolWindow(project, runnerAndConfigurationSettings, bl, string);
        }

        public final boolean isProfilerExecutor(@NotNull String executorId) {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            AbstractProfilerExecutorGroup<?> abstractProfilerExecutorGroup = AbstractProfilerExecutorGroup.Companion.getInstance();
            if ((abstractProfilerExecutorGroup != null ? (AbstractProfilerExecutorGroup.AbstractProfilerSetting)abstractProfilerExecutorGroup.getRegisteredSettings(executorId) : null) != null) {
                return true;
            }
            return Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isProjectSupported(@NotNull Project project) {
            Object v0;
            AndroidProjectSystem projectSystem;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                AndroidProjectSystem androidProjectSystem = projectSystem = ProjectSystemUtil.getProjectSystem(project);
                ExtensionPointName<ProfilerProgramRunnerToken<AndroidProjectSystem>> extensionPointName$iv = ProfilerProgramRunnerToken.Companion.getEP_NAME();
                boolean $i$f$getTokenOrNull = false;
                Iterable $this$singleOrNull$iv$iv = extensionPointName$iv.getExtensionList();
                boolean $i$f$singleOrNull = false;
                Object single$iv$iv = null;
                boolean found$iv$iv = false;
                for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                    void $this$getTokenOrNull$iv;
                    Token it$iv = (Token)element$iv$iv;
                    boolean bl = false;
                    if (!it$iv.isApplicable((AndroidProjectSystem)$this$getTokenOrNull$iv)) continue;
                    if (found$iv$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv$iv = element$iv$iv;
                    found$iv$iv = true;
                }
                v0 = !found$iv$iv ? null : single$iv$iv;
            }
            ProfilerProgramRunnerToken profilerProgramRunnerToken = (ProfilerProgramRunnerToken)((Token)v0);
            if (profilerProgramRunnerToken == null) {
                return false;
            }
            ProfilerProgramRunnerToken token = profilerProgramRunnerToken;
            return token.isProfileableBuildSupported(projectSystem);
        }

        public final boolean isApiLevelSupported(int featureLevel) {
            return featureLevel >= 29;
        }

        private final boolean isApiLevelSupported(ExecutionEnvironment env) {
            Object targetDevices;
            DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
            Object object = deviceFutures;
            if (object == null || (object = ((DeviceFutures)object).getDevices()) == null) {
                object = CollectionsKt.emptyList();
            }
            if (!((Collection)(targetDevices = object)).isEmpty()) {
                AndroidDevice device2 = (AndroidDevice)targetDevices.get(0);
                return this.isApiLevelSupported(device2.getVersion().getFeatureLevel());
            }
            return false;
        }

        public final boolean isSystemSupported(boolean isDebuggable) {
            return !isDebuggable;
        }

        private final boolean isSystemSupported(ExecutionEnvironment env) {
            Object targetDevices;
            DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
            Object object = deviceFutures;
            if (object == null || (object = ((DeviceFutures)object).getDevices()) == null) {
                object = CollectionsKt.emptyList();
            }
            if (!((Collection)(targetDevices = object)).isEmpty()) {
                AndroidDevice device2 = (AndroidDevice)targetDevices.get(0);
                return this.isSystemSupported(device2.isDebuggable());
            }
            return false;
        }

        @VisibleForTesting
        @NotNull
        public final String buildProfileableRequirementMessage(boolean isProjectSupported, boolean isApiLevelSupported, boolean isSystemSupported) {
            String PROJECT_CRITERIA = "Android Gradle Plugin 7.3 or higher";
            String API_LEVEL_CRITERIA = "a device with API level 29 or higher";
            String NON_DEBUGGABLE_CRITERIA = "a system that is not debuggable. Example: A Google Play enabled emulator system image";
            List reasons = new ArrayList();
            if (!isProjectSupported) {
                reasons.add(PROJECT_CRITERIA);
            }
            if (!isApiLevelSupported) {
                reasons.add(API_LEVEL_CRITERIA);
            }
            if (!isSystemSupported) {
                reasons.add(NON_DEBUGGABLE_CRITERIA);
            }
            StringBuilder message = new StringBuilder("\u201cRun as profileable (low overhead)\u201d is not available because it requires ");
            switch (reasons.size()) {
                case 0: {
                    if (_Assertions.ENABLED) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Object object = Unit.INSTANCE;
                    break;
                }
                case 1: {
                    Object object = message.append((String)reasons.get(0));
                    break;
                }
                case 2: {
                    Object object = message.append((String)reasons.get(0)).append(" and ").append((String)reasons.get(1));
                    break;
                }
                default: {
                    Object object = message.append((String)reasons.get(0)).append(", ").append((String)reasons.get(1)).append(", and ").append((String)reasons.get(2));
                }
            }
            message.append(".<br><br>To proceed, either choose a device or emulator that meets the requirements above or run the app with \"Profiler: Run as debuggable (complete data)\". <a href=\"https://d.android.com/r/studio-ui/profiler/profileable\">More Info</a>");
            String string = message.insert(0, "<html>").append("</html>").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, isSwapExecution, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, false, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SwapInfo.SwapType.values().length];
            try {
                nArray[SwapInfo.SwapType.APPLY_CHANGES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwapInfo.SwapType.APPLY_CODE_CHANGES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProfilingMode.values().length];
            try {
                nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilingMode.NOT_SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilingMode.PROFILEABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

