/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup;", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getDisabledIcon", "getDescription", "", "getActionName", "getId", "getStartActionText", "getContextActionId", "getHelpId", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "getRunToolbarActionText", "param", "getRunToolbarChooserText", "getToolWindowIcon", "getToolWindowId", "getChildExecutor", "Lcom/intellij/execution/Executor;", "profilingMode", "Lcom/android/tools/idea/run/profiler/ProfilingMode;", "ProfilerSetting", "Companion", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nProfileRunExecutorGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileRunExecutorGroup.kt\ncom/android/tools/idea/profilers/ProfileRunExecutorGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n774#2:149\n865#2,2:150\n*S KotlinDebug\n*F\n+ 1 ProfileRunExecutorGroup.kt\ncom/android/tools/idea/profilers/ProfileRunExecutorGroup\n*L\n135#1:149\n135#1:150,2\n*E\n"})
public final class ProfileRunExecutorGroup
extends AbstractProfilerExecutorGroup<ProfilerSetting> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Icon PROFILEABLE_ICON;
    @NotNull
    private static final Icon DEBUGGABLE_ICON;

    public ProfileRunExecutorGroup() {
        this.registerSettings(new ProfilerSetting(ProfilingMode.PROFILEABLE));
        this.registerSettings(new ProfilerSetting(ProfilingMode.DEBUGGABLE));
    }

    @NotNull
    public Icon getIcon() {
        return PROFILEABLE_ICON;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return this.getToolWindowIcon();
    }

    @NotNull
    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return "Android Profiler Group";
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    @NotNull
    public String getContextActionId() {
        return "ProfileGroupRunClass";
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CommonAndroidUtil.getInstance().isAndroidProject(project);
    }

    @NotNull
    public String getRunToolbarActionText(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return "Profile";
    }

    @NotNull
    public String getRunToolbarChooserText() {
        return "Profile";
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowRun;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowRun");
        return icon;
    }

    @NotNull
    public String getToolWindowId() {
        return "Run";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Executor getChildExecutor(@NotNull ProfilingMode profilingMode) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)profilingMode), (String)"profilingMode");
        Iterable $this$filter$iv = this.childExecutors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Executor e = (Executor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)e.getActionName(), (Object)new ProfilerSetting(profilingMode).getActionName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (Executor)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    @JvmStatic
    @Nullable
    public static final ProfileRunExecutorGroup getInstance() {
        return Companion.getInstance();
    }

    static {
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER_LOW_OVERHEAD;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PROFILER_LOW_OVERHEAD");
        PROFILEABLE_ICON = icon;
        Icon icon2 = StudioIcons.Shell.Toolbar.PROFILER_DETAILED;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PROFILER_DETAILED");
        DEBUGGABLE_ICON = icon2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$Companion;", "", "<init>", "()V", "PROFILEABLE_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "DEBUGGABLE_ICON", "getInstance", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ProfileRunExecutorGroup getInstance() {
            Executor executor = ExecutorRegistry.getInstance().getExecutorById("Android Profiler Group");
            return executor instanceof ProfileRunExecutorGroup ? (ProfileRunExecutorGroup)executor : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup$AbstractProfilerSetting;", "profilingMode", "Lcom/android/tools/idea/run/profiler/ProfilingMode;", "<init>", "(Lcom/android/tools/idea/run/profiler/ProfilingMode;)V", "actionName", "", "getActionName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "startActionText", "getStartActionText", "canRun", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "isApplicable", "project", "Lcom/intellij/openapi/project/Project;", "configurationName", "intellij.android.profilersAndroid"})
    public static final class ProfilerSetting
    extends AbstractProfilerExecutorGroup.AbstractProfilerSetting {
        @NotNull
        private final String startActionText;

        public ProfilerSetting(@NotNull ProfilingMode profilingMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilingMode), (String)"profilingMode");
            super(profilingMode);
            this.startActionText = "Profile";
        }

        @NotNull
        public String getActionName() {
            String string;
            if (((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                    case 1: {
                        string = "Profiler: Run as profileable (low overhead)";
                        break;
                    }
                    case 2: {
                        string = "Profiler: Run as debuggable (complete data)";
                        break;
                    }
                    default: {
                        string = "Profiler: Run";
                        break;
                    }
                }
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                    case 1: {
                        string = "Profile with low overhead (profileable)";
                        break;
                    }
                    case 2: {
                        string = "Profile with complete data (debuggable)";
                        break;
                    }
                    default: {
                        string = "Profile";
                    }
                }
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1: {
                    icon = PROFILEABLE_ICON;
                    break;
                }
                case 2: {
                    icon = DEBUGGABLE_ICON;
                    break;
                }
                default: {
                    Icon icon2 = StudioIcons.Shell.Toolbar.PROFILER;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PROFILER");
                }
            }
            return icon;
        }

        @NotNull
        public String getStartActionText() {
            return this.startActionText;
        }

        public boolean canRun(@NotNull RunProfile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            return true;
        }

        public boolean isApplicable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean isProfilingModeSupported = ProjectSystemUtil.getProjectSystem(project).supportsProfilingMode();
            return isProfilingModeSupported;
        }

        @Override
        @NotNull
        public String getStartActionText(@NotNull String configurationName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            if (((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                    case 1: {
                        string = "Profiler: Run '" + configurationName + "' as profileable (low overhead)";
                        break;
                    }
                    case 2: {
                        string = "Profiler: Run '" + configurationName + "' as debuggable (complete data)";
                        break;
                    }
                    default: {
                        string = "Profiler: Run '" + configurationName + "'";
                        break;
                    }
                }
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                    case 1: {
                        string = "Profile '" + configurationName + "' with low overhead (profileable)";
                        break;
                    }
                    case 2: {
                        string = "Profile '" + configurationName + "' with complete data (debuggable)";
                        break;
                    }
                    default: {
                        string = "Profile '" + configurationName + "'";
                    }
                }
            }
            return string;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProfilingMode.values().length];
                try {
                    nArray[ProfilingMode.PROFILEABLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

