/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.validation.Validator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersion;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersionKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \t2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/npw/validator/MultiplatformKgpMinVersionValidator;", "Lcom/android/tools/adtui/validation/Validator;", "Ljava/util/Optional;", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinGradlePluginVersion;", "<init>", "()V", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "value", "Companion", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=1)
public final class MultiplatformKgpMinVersionValidator
implements Validator<Optional<KotlinGradlePluginVersion>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final KotlinGradlePluginVersion MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION;

    @NotNull
    public Validator.Result validate(@NotNull Optional<KotlinGradlePluginVersion> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (value2.isEmpty()) {
            Object[] objectArray = new Object[]{MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION};
            String string = AndroidBundle.message("android.wizard.validate.kgp.version.for.kmp.module", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        }
        KotlinGradlePluginVersion kotlinGradlePluginVersion = value2.get();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinGradlePluginVersion, (String)"get(...)");
        KotlinGradlePluginVersion currentKgpVersion = kotlinGradlePluginVersion;
        if (KotlinGradlePluginVersionKt.compareTo((KotlinGradlePluginVersion)currentKgpVersion, (KotlinGradlePluginVersion)MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION) < 0) {
            Object[] objectArray = new Object[]{MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION};
            String string = AndroidBundle.message("android.wizard.validate.kgp.version.for.kmp.module", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        }
        return Validator.Result.OK;
    }

    static {
        KotlinGradlePluginVersion kotlinGradlePluginVersion = KotlinGradlePluginVersion.Companion.parse("2.0.0");
        Intrinsics.checkNotNull((Object)kotlinGradlePluginVersion);
        MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION = kotlinGradlePluginVersion;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/npw/validator/MultiplatformKgpMinVersionValidator$Companion;", "", "<init>", "()V", "MINIMUM_SUPPORTED_KOTLIN_MULTIPLATFORM_VERSION", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinGradlePluginVersion;", "intellij.android.newProjectWizard"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

