/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.projectsystem.AndroidModulePathsImpl;
import com.android.tools.idea.projectsystem.KotlinMultiplatformModulePathsImpl;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleAndroidModuleTemplate {
    public static NamedModuleTemplate createSampleTemplate() {
        return GradleAndroidModuleTemplate.createDefaultTemplateAt(new File(""));
    }

    public static NamedModuleTemplate createDefaultModuleTemplate(@NotNull Project project, @NotNull String moduleName) {
        String projectLocation = project.getBasePath();
        File moduleRoot = GradleAndroidModuleTemplate.getModuleRootForNewModule(projectLocation, moduleName);
        return GradleAndroidModuleTemplate.createDefaultTemplateAt(moduleRoot);
    }

    public static NamedModuleTemplate createMultiplatformModuleTemplate(@NotNull Project project, @NotNull String moduleName) {
        String projectLocation = project.getBasePath();
        File moduleRoot = GradleAndroidModuleTemplate.getModuleRootForNewModule(projectLocation, moduleName);
        return GradleAndroidModuleTemplate.createMultiplatformTemplateAt(moduleRoot);
    }

    public static NamedModuleTemplate createDefaultTemplateAt(@NotNull File moduleRoot) {
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavorDir = new File(baseSrcDir, "main");
        return new NamedModuleTemplate("main", new AndroidModulePathsImpl(moduleRoot, baseFlavorDir, new File(baseFlavorDir, "java"), new File(baseSrcDir.getPath(), "test" + File.separatorChar + "java"), new File(baseSrcDir.getPath(), "androidTest" + File.separatorChar + "java"), new File(baseFlavorDir, "aidl"), (List<? extends File>)ImmutableList.of((Object)new File(baseFlavorDir, "res")), (List<? extends File>)ImmutableList.of((Object)new File(baseFlavorDir, "ml"))));
    }

    public static NamedModuleTemplate createMultiplatformTemplateAt(@NotNull File moduleRoot) {
        File baseSrcDir = new File(moduleRoot, "src");
        File androidMainDir = new File(baseSrcDir, "androidMain");
        File commonMainDir = new File(baseSrcDir, "commonMain");
        File iosMainDir = new File(baseSrcDir, "iosMain");
        return new NamedModuleTemplate("main", new KotlinMultiplatformModulePathsImpl(moduleRoot, androidMainDir, new File(androidMainDir, "kotlin"), new File(commonMainDir, "kotlin"), new File(iosMainDir, "kotlin"), new File(baseSrcDir.getPath(), "androidHostTest" + File.separatorChar + "kotlin"), new File(baseSrcDir.getPath(), "androidDeviceTest" + File.separatorChar + "kotlin"), null, (List<? extends File>)ImmutableList.of((Object)new File(androidMainDir, "res")), (List<? extends File>)ImmutableList.of()));
    }

    public static File getModuleRootForNewModule(String projectLocation, String moduleName) {
        return new File(projectLocation, moduleName.replace(':', File.separatorChar));
    }
}

