/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CategoryIconMap {
    public static final Filter ACCEPT_ALL = category -> true;
    @NotNull
    private final Map<String, Map<String, AnnotatedImage>> myCategoryMap;

    public CategoryIconMap(@NotNull Map<String, Map<String, AnnotatedImage>> categoryMap) {
        this.myCategoryMap = categoryMap;
    }

    @NotNull
    public Map<Density, AnnotatedImage> toDensityMap() {
        return this.toDensityMap(ACCEPT_ALL);
    }

    @NotNull
    public Map<Density, AnnotatedImage> toDensityMap(@NotNull Filter filter2) {
        HashMap<Density, AnnotatedImage> densityImageMap = new HashMap<Density, AnnotatedImage>();
        for (String category : this.myCategoryMap.keySet()) {
            if (!filter2.accept(category)) continue;
            Map<String, AnnotatedImage> pathImageMap = this.myCategoryMap.get(category);
            for (String path : pathImageMap.keySet()) {
                Density density = IconGenerator.pathToDensity(path);
                if (density == null) continue;
                AnnotatedImage image = pathImageMap.get(path);
                densityImageMap.put(density, image);
            }
        }
        return densityImageMap;
    }

    @NotNull
    public Map<File, BufferedImage> toFileMap(@NotNull File rootDir) {
        HashMap<File, BufferedImage> outputMap = new HashMap<File, BufferedImage>();
        for (Map<String, AnnotatedImage> pathImageMap : this.myCategoryMap.values()) {
            for (Map.Entry<String, AnnotatedImage> pathImageEntry : pathImageMap.entrySet()) {
                outputMap.put(new File(rootDir, pathImageEntry.getKey()), pathImageEntry.getValue().getImage());
            }
        }
        return outputMap;
    }

    public static interface Filter {
        public boolean accept(@NotNull String var1);
    }
}

