/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.base.CaseFormat;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\n\u001a\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010\u001a\u0012\u0010\u0017\u001a\u00020\u00012\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019\u001a\u0012\u0010\u001a\u001a\u00020\u00012\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019\u001a\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 \"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006#"}, d2={"DEFAULT_ASSET_STUDIO", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "scaleRectangle", "Ljava/awt/Rectangle;", "rect", "scaleFactor", "", "scaleRectangleAroundCenter", "scaleDimension", "Ljava/awt/Dimension;", "dim", "roundToInt", "", "createPlaceholderImage", "Ljava/awt/image/BufferedImage;", "trim", "image", "pad", "paddingPercent", "toLowerCamelCase", "enumValue", "", "toUpperCamelCase", "getBundledImage", "Ljava/nio/file/Path;", "dir", "fileName", "orderTemplates", "", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "templates", "intellij.android.newProjectWizard"})
@JvmName(name="AssetStudioUtils")
@SourceDebugExtension(value={"SMAP\nAssetStudioUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetStudioUtils.kt\ncom/android/tools/idea/npw/assetstudio/AssetStudioUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
public final class AssetStudioUtils {
    @NotNull
    public static final String DEFAULT_ASSET_STUDIO = "asset_studio";

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"#com.android.tools.idea.npw.assetstudio.AssetStudioUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public static final Rectangle scaleRectangle(@NotNull Rectangle rect, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor)), MathKt.roundToInt((double)((double)rect.y * scaleFactor)), MathKt.roundToInt((double)((double)rect.width * scaleFactor)), MathKt.roundToInt((double)((double)rect.height * scaleFactor)));
    }

    @NotNull
    public static final Rectangle scaleRectangleAroundCenter(@NotNull Rectangle rect, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int width = MathKt.roundToInt((double)((double)rect.width * scaleFactor));
        int height = MathKt.roundToInt((double)((double)rect.height * scaleFactor));
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0)), MathKt.roundToInt((double)((double)rect.y * scaleFactor - (double)(height - rect.height) / 2.0)), width, height);
    }

    @NotNull
    public static final Dimension scaleDimension(@NotNull Dimension dim, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        return new Dimension(MathKt.roundToInt((double)((double)dim.width * scaleFactor)), MathKt.roundToInt((double)((double)dim.height * scaleFactor)));
    }

    public static final int roundToInt(double $this$roundToInt) {
        return MathKt.roundToInt((double)$this$roundToInt);
    }

    @NotNull
    public static final BufferedImage createPlaceholderImage() {
        return new BufferedImage(1, 1, 2);
    }

    @NotNull
    public static final BufferedImage trim(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage bufferedImage = ImageUtils.cropBlank((BufferedImage)image, null, (int)2);
        if (bufferedImage == null) {
            bufferedImage = image;
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            return image;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = RangesKt.coerceAtLeast((int)(largerSide * RangesKt.coerceAtMost((int)paddingPercent, (int)100) / 100), (int)(-(smallerSide / 2 - 1)));
        BufferedImage bufferedImage = AssetUtil.paddedImage((BufferedImage)image, (int)padding);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"paddedImage(...)");
        return bufferedImage;
    }

    @NotNull
    public static final String toLowerCamelCase(@NotNull Enum<?> enumValue) {
        Intrinsics.checkNotNullParameter(enumValue, (String)"enumValue");
        String string = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumValue.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"to(...)");
        return string;
    }

    @NotNull
    public static final String toUpperCamelCase(@NotNull Enum<?> enumValue) {
        Intrinsics.checkNotNullParameter(enumValue, (String)"enumValue");
        String string = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumValue.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"to(...)");
        return string;
    }

    @NotNull
    public static final Path getBundledImage(@NotNull String dir, @NotNull String fileName) {
        Path path;
        Path imageFile;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path path2 = imageFile = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)("tools/adt/idea/android/resources/images/" + dir + "/" + fileName)) : Paths.get(PathManager.getHomePath(), new String[0]).resolve("plugins/android/resources/images/" + dir + "/" + fileName);
        if (!Files.exists(imageFile, new LinkOption[0])) {
            AssetStudioUtils.getLOG().error("Missing bundled image file " + imageFile);
        } else if (Files.isDirectory(imageFile, new LinkOption[0])) {
            AssetStudioUtils.getLOG().error("Bundled image file " + imageFile + " is a directory");
        }
        if ((path = imageFile) == null) {
            Path path3 = Paths.get("/", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<NamedModuleTemplate> orderTemplates(@NotNull List<NamedModuleTemplate> templates) {
        block10: {
            Intrinsics.checkNotNullParameter(templates, (String)"templates");
            main = null;
            debug = null;
            release = null;
            orderedList = new ArrayList<E>();
            block5: for (NamedModuleTemplate template : templates) {
                block9: {
                    var7_7 = template.getName();
                    switch (var7_7.hashCode()) {
                        case 95458899: {
                            if (var7_7.equals("debug")) break;
                            ** break;
                        }
                        case 1090594823: {
                            if (!var7_7.equals("release")) {
                                ** break;
                            }
                            break block9;
                        }
                        case 3343801: {
                            if (!var7_7.equals("main")) ** break;
                            main = template;
                            continue block5;
                        }
                    }
                    debug = template;
                    continue;
                }
                release = template;
                continue;
lbl25:
                // 4 sources

                orderedList.add(template);
            }
            v0 = Comparator.comparing((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, orderTemplates$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)((Function1)((Function1)orderTemplates.1.INSTANCE)));
            Intrinsics.checkNotNullExpressionValue(v0, (String)"comparing(...)");
            CollectionsKt.sortWith((List)orderedList, v0);
            v1 = release;
            if (v1 != null) {
                it = v1;
                $i$a$-let-AssetStudioUtils$orderTemplates$2 = false;
                orderedList.add(0, it);
            }
            v2 = debug;
            if (v2 != null) {
                it = v2;
                $i$a$-let-AssetStudioUtils$orderTemplates$3 = false;
                orderedList.add(0, it);
            }
            v3 = main;
            if (v3 == null) break block10;
            it = v3;
            $i$a$-let-AssetStudioUtils$orderTemplates$4 = false;
            orderedList.add(0, it);
        }
        return orderedList;
    }

    private static final String orderTemplates$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

