/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IndexedRegularExpressionIncludeResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/navigator/nodes/ndk/includes/resolver/NdkIncludeResolver;", "Lcom/android/tools/idea/navigator/nodes/ndk/includes/resolver/IncludeResolver;", "<init>", "()V", "SXS_REVISION_PATTERN", "", "LEGACY_REVISION_PATTERN", "resolvers", "", "resolve", "Lcom/android/tools/idea/navigator/nodes/ndk/includes/model/SimpleIncludeValue;", "includeFolder", "Ljava/io/File;", "literalNamed", "pattern", "name", "leafNamed", "concreteNdkFolder", "ndkFolder", "intellij.android.navigator"})
public final class NdkIncludeResolver
extends IncludeResolver {
    @NotNull
    private final String SXS_REVISION_PATTERN;
    @NotNull
    private final String LEGACY_REVISION_PATTERN;
    @NotNull
    private final List<IncludeResolver> resolvers;

    public NdkIncludeResolver() {
        this.SXS_REVISION_PATTERN = ".*/ndk/(?<ndk>[0-9]+(?:\\.[0-9]+(?:\\.[0-9]+)?)?(?:[\\s-]*)?(?:rc|alpha|beta|\\.[0-9]+)?)";
        this.LEGACY_REVISION_PATTERN = ".*/ndk-bundle";
        Object[] objectArray = new List[]{this.leafNamed("^(?<home>{NDKFOLDER})(?<relative>/platforms/(?<library>android-.*?)/arch-.*?(/.*))$"), this.leafNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/cxx-stl/(?<library>.*?)(/.*))$"), this.leafNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/third_party/(?<library>.*?)(/.*))$"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/toolchains/llvm(/.*))$", "LLVM"), this.leafNamed("^(?<home>{NDKFOLDER})(?<relative>/toolchains/(?<library>.*?)(/.*))$"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/android/cpufeatures(/.*))$", "CPU Features"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/android/native_app_glue(/.*))$", "Native App Glue"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/android/ndk_helper(/.*))$", "Helper"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/sources/android/support(/.*))$", "Support"), this.literalNamed("^(?<home>{NDKFOLDER})(?<relative>/sysroot(/.*))$", "Sysroot")};
        this.resolvers = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Intrinsics.checkNotNullParameter((Object)includeFolder, (String)"includeFolder");
        for (IncludeResolver resolver : this.resolvers) {
            SimpleIncludeValue classifiedIncludeExpression = resolver.resolve(includeFolder);
            if (classifiedIncludeExpression == null) continue;
            return classifiedIncludeExpression;
        }
        return null;
    }

    private final List<IncludeResolver> literalNamed(String pattern, String name2) {
        List result2 = new ArrayList();
        ((Collection)result2).add(new IndexedRegularExpressionIncludeResolver(PackageType.NdkSxsComponent, this.concreteNdkFolder(pattern, this.SXS_REVISION_PATTERN), name2));
        ((Collection)result2).add(new IndexedRegularExpressionIncludeResolver(PackageType.NdkComponent, this.concreteNdkFolder(pattern, this.LEGACY_REVISION_PATTERN), name2));
        return result2;
    }

    private final List<IncludeResolver> leafNamed(String pattern) {
        List result2 = new ArrayList();
        ((Collection)result2).add(new IndexedRegularExpressionIncludeResolver(PackageType.NdkSxsComponent, this.concreteNdkFolder(pattern, this.SXS_REVISION_PATTERN), null));
        ((Collection)result2).add(new IndexedRegularExpressionIncludeResolver(PackageType.NdkComponent, this.concreteNdkFolder(pattern, this.LEGACY_REVISION_PATTERN), null));
        return result2;
    }

    private final String concreteNdkFolder(String pattern, String ndkFolder) {
        return StringsKt.replace$default((String)pattern, (String)"{NDKFOLDER}", (String)ndkFolder, (boolean)false, (int)4, null);
    }
}

