/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.apk.java.DexFileStructure;
import com.android.tools.idea.navigator.nodes.apk.java.PackageNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexGroupNode
extends ProjectViewNode<DexGroupElement> {
    @NotNull
    Project myProject;
    @NotNull
    List<VirtualFile> myDexFiles;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;
    @NotNull
    private final DexFileStructure myDexFileStructure;
    @Nullable
    private Collection<ApkPackage> myPackages;

    public DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull List<VirtualFile> dexFiles) {
        this(project, settings, DexSourceFiles.getInstance(project), dexFiles);
    }

    DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles, @NotNull List<VirtualFile> dexFiles) {
        super(project, (Object)new DexGroupElement(), settings);
        this.myProject = project;
        this.myDexFiles = dexFiles;
        this.myDexSourceFiles = dexSourceFiles;
        this.myDexFileStructure = new DexFileStructure(dexFiles);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        try {
            return this.getChildren(this.getPackages());
        }
        catch (Throwable e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).warn("Failed to parse dex file", e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private Collection<? extends AbstractTreeNode<?>> getChildren(@NotNull Collection<ApkPackage> packages) {
        ArrayList children2 = new ArrayList();
        ViewSettings settings = this.getSettings();
        if (settings.isFlattenPackages()) {
            this.addPackagesAsFlatList(packages, children2);
        } else {
            this.addPackagesAsTree(packages, children2);
        }
        return children2;
    }

    private void addPackagesAsFlatList(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode<?>> children2) {
        for (ApkPackage apkPackage : packages) {
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            if (!hideEmptyMiddlePackages || !apkPackage.getClasses().isEmpty()) {
                children2.add((AbstractTreeNode<?>)this.createNode(apkPackage));
            }
            this.addPackagesAsFlatList(apkPackage.getSubpackages(), children2);
        }
    }

    private void addPackagesAsTree(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode<?>> children2) {
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            for (ApkPackage apkPackage : packages) {
                if (!apkPackage.getClasses().isEmpty() || apkPackage.doSubpackagesHaveClasses()) {
                    children2.add((AbstractTreeNode<?>)this.createNode(apkPackage));
                    continue;
                }
                this.addPackagesAsTree(apkPackage.getSubpackages(), children2);
            }
        } else {
            for (ApkPackage apkPackage : packages) {
                children2.add((AbstractTreeNode<?>)this.createNode(apkPackage));
            }
        }
    }

    @NotNull
    private PackageNode createNode(ApkPackage apkPackage) {
        return new PackageNode(this.myProject, apkPackage, this.getSettings(), this.myDexSourceFiles);
    }

    public boolean contains(@NotNull VirtualFile file) {
        block3: {
            block2: {
                if (!this.myDexSourceFiles.isJavaFile(file)) break block2;
                String foundPackage = this.myDexSourceFiles.findJavaPackageNameIn(file);
                for (ApkPackage apkPackage : this.getPackages()) {
                    if (foundPackage == null || !foundPackage.contains(apkPackage.getFqn())) continue;
                    return true;
                }
                break block3;
            }
            if (!this.myDexSourceFiles.isSmaliFile(file)) break block3;
            File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            for (ApkPackage apkPackage : this.getPackages()) {
                File packageFilePath = this.myDexSourceFiles.findSmaliFilePathForPackage(apkPackage.getFqn());
                if (!FileUtil.isAncestor((File)packageFilePath, (File)filePath, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.addText(AndroidSourceType.JAVA.INSTANCE.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myDexFiles.size() == 1) {
            presentation.addText(" (" + this.myDexFiles.get(0).getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (" + this.myDexFiles.size() + " dex files)", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable<AndroidSourceType> getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable<AndroidSourceType> getTypeSortKey() {
        return DexGroupNode.getSourceType();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.PACKAGE.getWeight();
    }

    @NotNull
    private static AndroidSourceType getSourceType() {
        return AndroidSourceType.JAVA.INSTANCE;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return DexGroupNode.getSourceType().getName() + " (" + this.myDexFiles.stream().map(VirtualFile::getName).collect(Collectors.joining(",")) + ")";
    }

    @NotNull
    private Collection<ApkPackage> getPackages() {
        if (this.myPackages == null) {
            try {
                this.myPackages = this.myDexFileStructure.getPackages();
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn("Failed to parse dex file", (Throwable)e);
                this.myPackages = Collections.emptyList();
            }
        }
        return this.myPackages;
    }

    public static class DexGroupElement {
    }
}

