/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.navigator.ProjectViewListener;
import com.android.utils.DateProvider;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProjectViewSelectionChangeEvent;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0012\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/navigator/ProjectViewListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "dateProvider", "Lcom/android/utils/DateProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/ScheduledExecutorService;Lcom/android/utils/DateProvider;)V", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addEventTimestamp", "", "firstRemovedId", "", "contentManagerListener", "com/android/tools/idea/navigator/ProjectViewListener$contentManagerListener$1", "Lcom/android/tools/idea/navigator/ProjectViewListener$contentManagerListener$1;", "toolWindowsRegistered", "", "ids", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindowUnregistered", "id", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "processDetectedChange", "fromViewId", "toViewId", "convertToViewEnum", "Lcom/google/wireless/android/sdk/stats/ProjectViewSelectionChangeEvent$ProjectViewContent;", "viewId", "ReportingRunnable", "intellij.android.core"})
public final class ProjectViewListener
implements ToolWindowManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final DateProvider dateProvider;
    private volatile long addEventTimestamp;
    @Nullable
    private volatile String firstRemovedId;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;

    public ProjectViewListener(@NotNull Project project, @NotNull ScheduledExecutorService scheduler, @NotNull DateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.project = project;
        this.scheduler = scheduler;
        this.dateProvider = dateProvider;
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ ProjectViewListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                long currentTime = ProjectViewListener.access$getDateProvider$p(this.this$0).now().getTime();
                ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                switch (contentOperation == null ? -1 : contentManagerListener.WhenMappings.$EnumSwitchMapping$0[contentOperation.ordinal()]) {
                    case 1: {
                        boolean shouldUpdateFirstId = ProjectViewListener.access$getAddEventTimestamp$p(this.this$0) + 10000L < currentTime;
                        ProjectViewListener.access$setAddEventTimestamp$p(this.this$0, currentTime);
                        if (!shouldUpdateFirstId) break;
                        ProjectViewListener.access$setFirstRemovedId$p(this.this$0, ProjectView.getInstance((Project)this.this$0.getProject()).getCurrentViewId());
                        break;
                    }
                    case 2: {
                        ProjectViewListener.access$setAddEventTimestamp$p(this.this$0, currentTime);
                        ProjectViewListener.access$getScheduler$p(this.this$0).schedule(this.this$0.new ReportingRunnable(currentTime), 10000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                }
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectViewListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScheduledExecutorService scheduledExecutorService = EdtExecutorService.getScheduledExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getScheduledExecutorInstance(...)");
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkNotNullExpressionValue((Object)dateProvider, (String)"SYSTEM");
        this(project, scheduledExecutorService, dateProvider);
    }

    public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        if (ids.contains("Project")) {
            long currentTime;
            this.addEventTimestamp = currentTime = this.dateProvider.now().getTime();
            this.firstRemovedId = "";
            this.scheduler.schedule(new ReportingRunnable(currentTime), 10000L, TimeUnit.MILLISECONDS);
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)this.project.getDisposed(), () -> ProjectViewListener.toolWindowsRegistered$lambda$0(toolWindowManager, this));
        }
    }

    public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        if (Intrinsics.areEqual((Object)id2, (Object)"Project")) {
            toolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processDetectedChange(String fromViewId, String toViewId) {
        void $this$processDetectedChange_u24lambda_u242_u24lambda_u241;
        ProjectViewSelectionChangeEvent.Builder builder;
        AndroidStudioEvent.Builder builder2;
        ProjectViewSelectionChangeEvent.ProjectViewContent viewBeforeChangeValue = this.convertToViewEnum(fromViewId);
        ProjectViewSelectionChangeEvent.ProjectViewContent viewAfterChangeValue = this.convertToViewEnum(toViewId);
        AndroidStudioEvent.Builder $this$processDetectedChange_u24lambda_u242 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$processDetectedChange_u24lambda_u242.setKind(AndroidStudioEvent.EventKind.PROJECT_VIEW_SELECTION_CHANGE_EVENT);
        ProjectViewSelectionChangeEvent.Builder builder3 = builder = ProjectViewSelectionChangeEvent.newBuilder();
        AndroidStudioEvent.Builder builder4 = $this$processDetectedChange_u24lambda_u242;
        boolean bl2 = false;
        $this$processDetectedChange_u24lambda_u242_u24lambda_u241.setViewBeforeChange(viewBeforeChangeValue);
        $this$processDetectedChange_u24lambda_u242_u24lambda_u241.setViewAfterChange(viewAfterChangeValue);
        builder4.setProjectViewSelectionChangeEvent(builder.build());
        AndroidStudioEvent.Builder builder5 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"apply(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder5);
    }

    private final ProjectViewSelectionChangeEvent.ProjectViewContent convertToViewEnum(String viewId) {
        return switch (viewId) {
            case "" -> ProjectViewSelectionChangeEvent.ProjectViewContent.UNKNOWN;
            case "AndroidView" -> ProjectViewSelectionChangeEvent.ProjectViewContent.ANDROID;
            case "ProjectPane" -> ProjectViewSelectionChangeEvent.ProjectViewContent.PROJECT;
            default -> ProjectViewSelectionChangeEvent.ProjectViewContent.OTHER;
        };
    }

    private static final void toolWindowsRegistered$lambda$0(ToolWindowManager $toolWindowManager, ProjectViewListener this$0) {
        block0: {
            ContentManager contentManager;
            ToolWindow toolWindow = $toolWindowManager.getToolWindow("Project");
            if (toolWindow == null || (contentManager = toolWindow.getContentManager()) == null) break block0;
            contentManager.addContentManagerListener((ContentManagerListener)this$0.contentManagerListener);
        }
    }

    public static final /* synthetic */ DateProvider access$getDateProvider$p(ProjectViewListener $this) {
        return $this.dateProvider;
    }

    public static final /* synthetic */ void access$setAddEventTimestamp$p(ProjectViewListener $this, long l) {
        $this.addEventTimestamp = l;
    }

    public static final /* synthetic */ void access$setFirstRemovedId$p(ProjectViewListener $this, String string) {
        $this.firstRemovedId = string;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getScheduler$p(ProjectViewListener $this) {
        return $this.scheduler;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/navigator/ProjectViewListener$ReportingRunnable;", "Ljava/lang/Runnable;", "addingTime", "", "<init>", "(Lcom/android/tools/idea/navigator/ProjectViewListener;J)V", "getAddingTime", "()J", "run", "", "intellij.android.core"})
    private final class ReportingRunnable
    implements Runnable {
        private final long addingTime;

        public ReportingRunnable(long addingTime) {
            this.addingTime = addingTime;
        }

        public final long getAddingTime() {
            return this.addingTime;
        }

        @Override
        public void run() {
            if (ProjectViewListener.this.getProject().isDisposed()) {
                return;
            }
            String localInitialViewId = ProjectViewListener.this.firstRemovedId;
            if (this.addingTime != ProjectViewListener.this.addEventTimestamp) {
                return;
            }
            String newViewId = ProjectView.getInstance((Project)ProjectViewListener.this.getProject()).getCurrentViewId();
            if (localInitialViewId != null && newViewId != null && !Intrinsics.areEqual((Object)localInitialViewId, (Object)newViewId)) {
                ProjectViewListener.this.processDetectedChange(localInitialViewId, newViewId);
            }
        }
    }
}

