/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.projectView.AndroidProjectViewSettings;
import com.android.tools.idea.navigator.nodes.AndroidViewNodeProvider;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNode;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.BuildScriptTreeStructureProvider;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.diagnostic.VMOptions;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public class AndroidProjectViewPane
extends AbstractProjectViewPaneWithAsyncSupport {
    public static final String ID = "AndroidView";
    public static final String PROJECT_VIEW_DEFAULT_KEY = "studio.projectview";
    private AtomicBoolean isProcessingChanges = new AtomicBoolean(false);

    public AndroidProjectViewPane(final Project project) {
        super(project);
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                this.somethingChanged();
            }

            public void facetRemoved(@NotNull Facet facet) {
                this.somethingChanged();
            }

            private void somethingChanged() {
                if (!AndroidProjectViewPane.this.isProcessingChanges.getAndSet(true)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            if (project.isDisposed()) {
                                return;
                            }
                            ProjectView projectView = ProjectView.getInstance((Project)project);
                            AbstractProjectViewPane pane = projectView.getProjectViewPaneById(AndroidProjectViewPane.ID);
                            boolean visible = AndroidProjectViewPane.this.isInitiallyVisible();
                            if (visible && pane == null) {
                                projectView.addProjectPane((AbstractProjectViewPane)AndroidProjectViewPane.this);
                            } else if (!visible && pane != null) {
                                projectView.removeProjectPane(pane);
                            }
                        }
                        finally {
                            AndroidProjectViewPane.this.isProcessingChanges.set(false);
                        }
                    }, project.getDisposed());
                }
            }
        });
    }

    @NotNull
    public String getTitle() {
        return "Android";
    }

    @NotNull
    public Icon getIcon() {
        return StudioIcons.Common.ANDROID_HEAD;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 142;
    }

    public boolean isInitiallyVisible() {
        return CommonAndroidUtil.getInstance().isAndroidProject(this.myProject) && ProjectSystemUtil.getProjectSystem(this.myProject).isAndroidProjectViewSupported();
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            public String toString() {
                return AndroidProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return AndroidProjectViewPane.this.getId();
            }

            public float getWeight() {
                return AndroidProjectViewPane.this.getWeight();
            }

            protected boolean canSelect(PsiFileSystemItem file) {
                if (super.canSelect(file)) {
                    return true;
                }
                return AndroidViewNodeProvider.getProviders().stream().anyMatch(it -> it.projectContainsExternalFile(this.myProject, file.getVirtualFile()));
            }
        };
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new AndroidProjectTreeStructure(this.myProject, ID);
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        return new MyProjectViewTree(treeModel);
    }

    public PsiDirectory @NotNull [] getSelectedDirectories() {
        PackageElement packageElement;
        Module m;
        Object[] selectedElements;
        Object[] paths = this.getSelectionPaths();
        Object selectedElement = null;
        if (paths != null && (selectedElements = ContainerUtil.map2Array((Object[])paths, TreeUtil::getLastUserObject)).length == 1) {
            selectedElement = selectedElements[0];
        }
        if (selectedElement instanceof PackageElement && (m = (packageElement = (PackageElement)selectedElement).getModule()) != null) {
            return packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
        }
        NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)this.getSelectedPath());
        if (descriptor2 instanceof FolderGroupNode) {
            return ((FolderGroupNode)descriptor2).getFolders().toArray(PsiDirectory.EMPTY_ARRAY);
        }
        PsiDirectory[] selectedDirectories = super.getSelectedDirectories();
        if (selectedElement instanceof Module && selectedDirectories.length > 0) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(selectedDirectories.length);
            for (PsiDirectory dir : selectedDirectories) {
                VirtualFile file = dir.getVirtualFile();
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)this.myProject) || file.getParent() != null && file.getPath().contains("/generated/")) continue;
                dirs.add(dir);
            }
            selectedDirectories = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        return selectedDirectories;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        Object o = super.getValueFromNode(node);
        if (o instanceof ArrayList && TreeUtil.getUserObject((Object)node) instanceof FolderGroupNode) {
            return ((ArrayList)o).toArray();
        }
        return o;
    }

    protected void uiDataSnapshotForSelection(@NotNull DataSink sink, Object @NotNull [] selectedUserObjects, @Nullable Object[] singleSelectedPathUserObjects) {
        super.uiDataSnapshotForSelection(sink, selectedUserObjects, singleSelectedPathUserObjects);
        sink.lazy(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, () -> {
            VirtualFile directory;
            Object o;
            Object object = o = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (o instanceof PsiDirectory && this.isTopModuleDirectoryOrParent(directory = ((PsiDirectory)o).getVirtualFile())) {
                return new NoOpDeleteProvider();
            }
            return null;
        });
        sink.lazy(PlatformCoreDataKeys.MODULE, () -> {
            Module module;
            Object value2;
            Object object = value2 = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (value2 instanceof PackageElement) {
                PackageElement o = (PackageElement)value2;
                module = o.getModule();
            } else if (value2 instanceof AndroidFacet) {
                AndroidFacet o = (AndroidFacet)value2;
                module = o.getModule();
            } else {
                module = null;
            }
            return module;
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> {
            Object value2;
            Object object = value2 = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (!(value2 instanceof PackageElement)) {
                return null;
            }
            PackageElement packageElement = (PackageElement)value2;
            Module m = packageElement.getModule();
            if (m == null) {
                return null;
            }
            PsiDirectory[] folders = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
            if (folders.length > 0) {
                return folders[0].getVirtualFile();
            }
            return null;
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> {
            List<PsiDirectory> directories;
            List<PsiFile> files2;
            NodeDescriptor selectedDescriptor;
            NodeDescriptor nodeDescriptor = selectedDescriptor = selectedUserObjects.length != 1 ? null : (NodeDescriptor)ObjectUtils.tryCast((Object)selectedUserObjects[0], NodeDescriptor.class);
            if (selectedDescriptor instanceof FileGroupNode && !(files2 = ((FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>(files2.size());
                for (PsiFile file : files2) {
                    if (!file.isValid()) continue;
                    virtualFiles.add(file.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories = ((FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>(directories.size());
                for (PsiDirectory directory : directories) {
                    if (!directory.isValid()) continue;
                    virtualFiles.add(directory.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            return null;
        });
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            List<PsiDirectory> directories;
            Object o;
            List<PsiFile> files2;
            NodeDescriptor selectedDescriptor;
            Object patt0$temp;
            List l;
            Object value2;
            Object object = value2 = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (value2 instanceof PsiElement) {
                PsiElement o2 = (PsiElement)value2;
                return o2;
            }
            if (value2 instanceof List && !(l = (List)value2).isEmpty() && (patt0$temp = l.get(0)) instanceof PsiElement) {
                PsiElement o3 = (PsiElement)patt0$temp;
                return o3;
            }
            NodeDescriptor nodeDescriptor = selectedDescriptor = selectedUserObjects.length != 1 ? null : (NodeDescriptor)ObjectUtils.tryCast((Object)selectedUserObjects[0], NodeDescriptor.class);
            if (selectedDescriptor instanceof FileGroupNode && !(files2 = (o = (FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                return (PsiElement)files2.get(0);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories = (o = (FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                return (PsiElement)directories.get(0);
            }
            return null;
        });
    }

    public boolean isDefaultPane(@NotNull Project project) {
        return this.isDefaultPane(project, IdeInfo.getInstance(), AndroidProjectViewSettings.Companion.getInstance());
    }

    @VisibleForTesting
    boolean isDefaultPane(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull AndroidProjectViewSettings settings) {
        if (!ProjectSystemUtil.getProjectSystem(this.myProject).isAndroidProjectViewSupported() || !CommonAndroidUtil.getInstance().isAndroidProject(this.myProject)) {
            return false;
        }
        if (!ideInfo.isAndroidStudio() && !ideInfo.isGameTools()) {
            return super.isDefaultPane(project);
        }
        if (((Boolean)StudioFlags.SHOW_DEFAULT_PROJECT_VIEW_SETTINGS.get()).booleanValue() && Boolean.getBoolean(PROJECT_VIEW_DEFAULT_KEY)) {
            this.handleCustomDefaultProjectViewProperty(project, settings);
        }
        return !settings.isProjectViewDefault();
    }

    private void handleCustomDefaultProjectViewProperty(Project project, AndroidProjectViewSettings settings) {
        settings.setDefaultToProjectView(true);
        System.clearProperty(PROJECT_VIEW_DEFAULT_KEY);
        String propertyNotificationNote = "";
        propertyNotificationNote = this.checkForProjectViewCustomProperty();
        if (propertyNotificationNote.isBlank()) {
            try {
                String projectViewDefaultKeyOption = VMOptions.readOption((String)"-Dstudio.projectview=", (boolean)false);
                if (projectViewDefaultKeyOption != null && projectViewDefaultKeyOption.equals("true")) {
                    VMOptions.setProperty((String)PROJECT_VIEW_DEFAULT_KEY, null);
                    propertyNotificationNote = "This property has been removed from custom VM options.";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (propertyNotificationNote.isBlank()) {
            propertyNotificationNote = "We recommend removing this property and using 'Advanced Settings -> Project View -> Set Project view as the default` to configure the default project view.";
        }
        AndroidNotification.getInstance((Project)project).showBalloon("Default Project View Setting Updated", "'Set Project view as the default' advanced setting was enabled due to the custom property `studio.projectview=true`. " + propertyNotificationNote, NotificationType.INFORMATION);
    }

    private String checkForProjectViewCustomProperty() {
        block14: {
            String customOptionsDirectory = PathManager.getCustomOptionsDirectory();
            if (customOptionsDirectory != null) {
                Path propertiesFilePath = Path.of(customOptionsDirectory, "idea.properties");
                Properties properties = new Properties();
                try {
                    try (FileInputStream inputStream = new FileInputStream(propertiesFilePath.toFile());){
                        properties.load(inputStream);
                    }
                    if (!properties.containsKey(PROJECT_VIEW_DEFAULT_KEY)) break block14;
                    properties.remove(PROJECT_VIEW_DEFAULT_KEY);
                    try (FileOutputStream outputStream = new FileOutputStream(propertiesFilePath.toFile());){
                        properties.store(outputStream, null);
                    }
                    return "This property has been removed from " + String.valueOf(propertiesFilePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    private boolean isTopModuleDirectoryOrParent(@NotNull VirtualFile directory) {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            File baseDirPath;
            File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module);
            if (moduleRootFolderPath == null || !FileUtil.filesEqual((File)moduleRootFolderPath, (File)(baseDirPath = Projects.getBaseDirPath((Project)this.myProject)))) continue;
            File directoryPath = VfsUtilCore.virtualToIoFile((VirtualFile)directory);
            return FileUtil.isAncestor((File)directoryPath, (File)baseDirPath, (boolean)false);
        }
        return false;
    }

    private static class AndroidProjectTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        AndroidProjectTreeStructure(@NotNull Project project, @NotNull String panelId) {
            super(project, panelId);
        }

        public @Unmodifiable List<TreeStructureProvider> getProviders() {
            List providers = super.getProviders();
            if (providers == null) {
                return null;
            }
            return ContainerUtil.map((Collection)providers, provider -> new BuildScriptTreeStructureProvider((TreeStructureProvider)provider));
        }

        protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            return new AndroidViewProjectNode(project, settings);
        }
    }

    private class MyProjectViewTree
    extends ProjectViewTree {
        MyProjectViewTree(DefaultTreeModel treeModel) {
            super((TreeModel)treeModel);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            super.uiDataSnapshot(sink);
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)AndroidProjectViewPane.this);
        }
    }

    private static class NoOpDeleteProvider
    implements DeleteProvider {
        private NoOpDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return false;
        }
    }
}

