/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.npw.model.NewTemplateRendererKt;
import com.android.tools.idea.npw.template.ModuleTemplateDataBuilderKt;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.template.ModuleTemplateData;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import com.android.tools.idea.wizard.template.TemplateData;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R)\u0010\u0004\u001a\u001d\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\n\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/mlkit/notifications/BuildFeatureOffNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "addBuildFeatureRecipe", "Lkotlin/Function2;", "Lcom/android/tools/idea/wizard/template/RecipeExecutor;", "Lcom/android/tools/idea/wizard/template/TemplateData;", "", "Lkotlin/ExtensionFunctionType;", "Lcom/android/tools/idea/wizard/template/Recipe;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addBuildFeature", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.android.mlkit"})
public final class BuildFeatureOffNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<RecipeExecutor, TemplateData, Unit> addBuildFeatureRecipe = BuildFeatureOffNotificationProvider::addBuildFeatureRecipe$lambda$0;
    @NotNull
    private static final Key<String> HIDDEN_KEY;
    @NotNull
    private static final String BANNER_MESSAGE = "ML Model Binding build feature not enabled.";
    @NotNull
    private static final String DIALOG_TITLE = "Enable Build Feature";
    @NotNull
    private static final String DIALOG_MESSAGE = "This operation adds the below build feature\n\nbuildFeatures {\n    mlModelBinding true\n}\n\nWould you like to add this now?";

    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)"tflite", (Object)file.getExtension())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || MlUtils.isMlModelBindingBuildFeatureEnabled(module)) {
            return null;
        }
        return arg_0 -> BuildFeatureOffNotificationProvider.collectNotificationData$lambda$3(project, this, module, file, arg_0);
    }

    private final void addBuildFeature(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ModuleTemplateData moduleTemplateData = ModuleTemplateDataBuilderKt.getExistingModuleTemplateDataBuilder(module).build();
        RenderingContext renderingContext = new RenderingContext(project2, module, "Add build feature mlModelBinding", (TemplateData)moduleTemplateData, null, null, false, true, 16, null);
        NewTemplateRendererKt.render$default(this.addBuildFeatureRecipe, renderingContext, new DefaultRecipeExecutor(renderingContext), AndroidStudioEvent.TemplateRenderer.ML_MODEL_BINDING_FEATURE_OFF_NOTIFICATION, null, 8, null);
    }

    private static final Unit addBuildFeatureRecipe$lambda$0(RecipeExecutor recipeExecutor, TemplateData it) {
        Intrinsics.checkNotNullParameter((Object)recipeExecutor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        recipeExecutor.setBuildFeature("mlModelBinding", true);
        return Unit.INSTANCE;
    }

    private static final void collectNotificationData$lambda$3$lambda$1(Project $project, BuildFeatureOffNotificationProvider this$0, Module $module) {
        if (Messages.showOkCancelDialog((Project)$project, (String)DIALOG_MESSAGE, (String)DIALOG_TITLE, (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getInformationIcon()) == 0) {
            this$0.addBuildFeature($module);
            ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        }
    }

    private static final void collectNotificationData$lambda$3$lambda$2(FileEditor $fileEditor, Project $project, VirtualFile $file) {
        ((TfliteModelFileEditor)$fileEditor).putUserData(HIDDEN_KEY, "true");
        EditorNotifications.getInstance((Project)$project).updateNotifications($file);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$3(Project $project, BuildFeatureOffNotificationProvider this$0, Module $module, VirtualFile $file, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (!(fileEditor instanceof TfliteModelFileEditor) || ((TfliteModelFileEditor)fileEditor).getUserData(HIDDEN_KEY) != null) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(BANNER_MESSAGE);
        panel2.createActionLabel("Enable Now", () -> BuildFeatureOffNotificationProvider.collectNotificationData$lambda$3$lambda$1($project, this$0, $module));
        panel2.createActionLabel("Hide notification", () -> BuildFeatureOffNotificationProvider.collectNotificationData$lambda$3$lambda$2(fileEditor, $project, $file));
        return panel2;
    }

    static {
        Key key = Key.create((String)"ml.build.feature.off.notification.panel.hidden");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HIDDEN_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/mlkit/notifications/BuildFeatureOffNotificationProvider$Companion;", "", "<init>", "()V", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "BANNER_MESSAGE", "DIALOG_TITLE", "DIALOG_MESSAGE", "intellij.android.mlkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

