/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.lightpsi;

import com.android.tools.idea.mlkit.APIVersion;
import com.android.tools.idea.mlkit.lightpsi.CodeUtils;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.android.tools.idea.psi.light.DeprecatableLightMethodBuilder;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

public class LightModelOutputsClass
extends AndroidLightClassBase {
    @NotNull
    public static final String TAG_NORMAL_METHOD = "normal method";
    @NotNull
    public static final String TAG_GROUP_METHOD = "group method";
    @NotNull
    private final LightModelClass containingClass;
    @NotNull
    private final String qualifiedName;
    @NotNull
    private final CachedValue<PsiMethod[]> myMethodCache;
    @NotNull
    private final APIVersion myAPIVersion;
    private final boolean myGenerateFallbackApiOnly;

    public LightModelOutputsClass(@NotNull Module module, @NotNull ModelInfo modelInfo, @NotNull LightModelClass containingClass) {
        super(containingClass, (Iterable<String>)ImmutableSet.of((Object)"public", (Object)"static", (Object)"final"));
        this.qualifiedName = String.join((CharSequence)".", containingClass.getQualifiedName(), "Outputs");
        this.containingClass = containingClass;
        this.myAPIVersion = APIVersion.fromProject(module.getProject());
        this.myGenerateFallbackApiOnly = this.myAPIVersion.generateFallbackApiOnly(modelInfo.getMinParserVersion());
        this.myMethodCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
            if (this.myAPIVersion.isAtLeastVersion(APIVersion.API_VERSION_1)) {
                for (TensorInfo tensorInfo : modelInfo.getOutputs()) {
                    methods2.add(this.buildGetterMethod(tensorInfo, false));
                    if (CodeUtils.getPsiClassType(tensorInfo, this.getProject(), this.getResolveScope(), this.myGenerateFallbackApiOnly).getClassName().equals("TensorBuffer")) continue;
                    methods2.add(this.buildGetterMethod(tensorInfo, true));
                }
            }
            if (this.myAPIVersion.isAtLeastVersion(APIVersion.API_VERSION_2)) {
                for (TensorGroupInfo tensorGroupInfo : modelInfo.getOutputTensorGroups()) {
                    methods2.add(this.buildGroupGetterMethod(tensorGroupInfo));
                }
            }
            return CachedValueProvider.Result.create((Object)methods2.toArray(PsiMethod.EMPTY_ARRAY), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @NotNull
    public String getName() {
        return "Outputs";
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])this.myMethodCache.getValue();
    }

    @NotNull
    private PsiMethod buildGetterMethod(@NotNull TensorInfo tensorInfo, boolean usedForFallback) {
        GlobalSearchScope scope = this.getResolveScope();
        PsiClassType returnType = usedForFallback ? PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)this.getProject(), (GlobalSearchScope)scope) : CodeUtils.getPsiClassType(tensorInfo, this.getProject(), scope, this.myGenerateFallbackApiOnly);
        String methodName = MlNames.formatGetterName((String)tensorInfo.getIdentifierName(), (String)CodeUtils.getTypeName((PsiType)returnType));
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.myManager, (Language)JavaLanguage.INSTANCE, methodName);
        method2.setMethodReturnType((PsiType)returnType, true).addModifiers(new String[]{"public", "final"}).setContainingClass((PsiClass)this).setNavigationElement((PsiElement)this);
        method2.setDeprecated(usedForFallback);
        method2.setOriginInfo(TAG_NORMAL_METHOD);
        return method2;
    }

    @NotNull
    private PsiMethod buildGroupGetterMethod(@NotNull TensorGroupInfo tensorGroupInfo) {
        Project project = this.getProject();
        GlobalSearchScope scope = this.getResolveScope();
        String groupClassName = StringHelper.usLocaleCapitalize((String)tensorGroupInfo.getIdentifierName());
        String groupQualifiedName = String.join((CharSequence)".", this.containingClass.getQualifiedName(), groupClassName);
        PsiClass listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", scope);
        PsiClassType returnType = PsiElementFactory.getInstance((Project)project).createType(listClass, (PsiType)PsiType.getTypeByName((String)groupQualifiedName, (Project)project, (GlobalSearchScope)scope));
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.myManager, (Language)JavaLanguage.INSTANCE, MlNames.formatGroupGetterName((String)groupClassName));
        method2.setMethodReturnType((PsiType)returnType, true).addModifiers(new String[]{"public", "final"}).setContainingClass((PsiClass)this).setNavigationElement((PsiElement)this);
        method2.setOriginInfo(TAG_GROUP_METHOD);
        return method2;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.containingClass.getNavigationElement();
    }
}

