/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.lightpsi;

import com.android.tools.mlkit.TensorInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class CodeUtils {
    @NotNull
    public static PsiClassType getPsiClassType(@NotNull TensorInfo tensorInfo, @NotNull Project project, @NotNull GlobalSearchScope scope, boolean generateFallbackApiOnly) {
        if (generateFallbackApiOnly) {
            return PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)project, (GlobalSearchScope)scope);
        }
        if (tensorInfo.isRGBImage()) {
            return PsiType.getTypeByName((String)"org.tensorflow.lite.support.image.TensorImage", (Project)project, (GlobalSearchScope)scope);
        }
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS) {
            PsiClass listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", scope);
            PsiClassType value2 = PsiType.getTypeByName((String)"org.tensorflow.lite.support.label.Category", (Project)project, (GlobalSearchScope)scope);
            return PsiElementFactory.getInstance((Project)project).createType(listClass, (PsiType)value2);
        }
        return PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)project, (GlobalSearchScope)scope);
    }

    @NotNull
    public static String getTypeName(@NotNull PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiType[] psiTypes = psiClassType.getParameters();
            if (psiTypes.length == 0) {
                return psiClassType.getClassName();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (PsiType paramType : psiTypes) {
                stringBuilder.append(paramType.getPresentableText());
            }
            stringBuilder.append(psiClassType.getClassName());
            return stringBuilder.toString();
        }
        return psiType.getPresentableText();
    }
}

