/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileType;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.RegisteredDependencyId;
import com.android.tools.idea.projectsystem.RegisteredDependencyQueryId;
import com.android.tools.idea.projectsystem.RegisteringModuleSystem;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.projectsystem.gradle.GradleModuleSystem;
import com.android.tools.idea.projectsystem.gradle.GradleRegisteredDependencyId;
import com.android.tools.mlkit.MlNames;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlUtils {
    private static final ImmutableMap<WellKnownMavenArtifactId, Version> REQUIRED_DEPENDENCY_LIST = ImmutableMap.builder().put((Object)WellKnownMavenArtifactId.TFLITE_SUPPORT, (Object)Version.parse((String)"0.1.0")).put((Object)WellKnownMavenArtifactId.TFLITE_METADATA, (Object)Version.parse((String)"0.1.0")).build();

    private MlUtils() {
    }

    public static boolean isMlModelBindingBuildFeatureEnabled(@NotNull Module module) {
        return AndroidFacet.getInstance((Module)module) != null && ProjectSystemUtil.getModuleSystem(module).isMlModelBindingEnabled();
    }

    public static boolean isModelFileInMlModelsFolder(@NotNull Module module, @NotNull VirtualFile file) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        return androidFacet != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)TfliteModelFileType.INSTANCE) && SourceProviders.getInstance(androidFacet).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream().flatMap(sourceProvider -> Streams.stream(sourceProvider.getMlModelsDirectories())).anyMatch(mlDir -> VfsUtilCore.isAncestor((VirtualFile)mlDir, (VirtualFile)file, (boolean)true));
    }

    @NotNull
    public static String computeModelClassName(@NotNull Module module, @NotNull VirtualFile file) {
        String relativePath = MlUtils.relativePathToMlModelsFolder(module, file);
        return relativePath != null ? MlNames.computeModelClassName((String)relativePath) : "";
    }

    @Nullable
    private static String relativePathToMlModelsFolder(@NotNull Module module, @NotNull VirtualFile file) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null || !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)TfliteModelFileType.INSTANCE)) {
            return null;
        }
        Optional<VirtualFile> ancestor = SourceProviders.getInstance(androidFacet).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream().flatMap(sourceProvider -> Streams.stream(sourceProvider.getMlModelsDirectories())).filter(mlDir -> VfsUtilCore.isAncestor((VirtualFile)mlDir, (VirtualFile)file, (boolean)true)).findFirst();
        return ancestor.map(virtualFile -> VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)virtualFile)).orElse(null);
    }

    @NotNull
    public static List<WellKnownMavenArtifactId> getMissingTfliteGpuDependencies(@NotNull Module module) {
        return MlUtils.getMissingDependencies(module, (ImmutableSet<WellKnownMavenArtifactId>)ImmutableSet.of((Object)WellKnownMavenArtifactId.TFLITE_GPU));
    }

    @NotNull
    public static List<WellKnownMavenArtifactId> getMissingRequiredDependencies(@NotNull Module module) {
        return MlUtils.getMissingDependencies(module, (ImmutableSet<WellKnownMavenArtifactId>)REQUIRED_DEPENDENCY_LIST.keySet());
    }

    @NotNull
    private static List<WellKnownMavenArtifactId> getMissingDependencies(@NotNull Module module, ImmutableSet<WellKnownMavenArtifactId> dependencies2) {
        RegisteringModuleSystem<RegisteredDependencyQueryId, RegisteredDependencyId> moduleSystem = ProjectSystemUtil.getModuleSystem(module).getRegisteringModuleSystem();
        if (moduleSystem == null) {
            return List.of();
        }
        ArrayList<WellKnownMavenArtifactId> pendingDeps = new ArrayList<WellKnownMavenArtifactId>();
        for (WellKnownMavenArtifactId id2 : dependencies2) {
            if (moduleSystem.hasRegisteredDependency(id2)) continue;
            pendingDeps.add(id2);
        }
        return pendingDeps;
    }

    @NotNull
    public static List<Pair<RegisteredDependencyId, Map.Entry<WellKnownMavenArtifactId, Version>>> getDependenciesLowerThanRequiredVersion(@NotNull Module module) {
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem(module);
        ArrayList<Pair<RegisteredDependencyId, Map.Entry<WellKnownMavenArtifactId, Version>>> resultDepPairList = new ArrayList<Pair<RegisteredDependencyId, Map.Entry<WellKnownMavenArtifactId, Version>>>();
        if (androidModuleSystem instanceof GradleModuleSystem) {
            GradleModuleSystem moduleSystem = (GradleModuleSystem)androidModuleSystem;
            for (Map.Entry depInfo : REQUIRED_DEPENDENCY_LIST.entrySet()) {
                GradleRegisteredDependencyId id2 = moduleSystem.getRegisteredDependency((WellKnownMavenArtifactId)depInfo.getKey());
                if (id2 == null || id2.getDependency().getVersion().getLowerBound().compareTo((Version)depInfo.getValue()) >= 0) continue;
                resultDepPairList.add((Pair<RegisteredDependencyId, Map.Entry<WellKnownMavenArtifactId, Version>>)Pair.create((Object)id2, (Object)depInfo));
            }
        }
        return resultDepPairList;
    }
}

