/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.analytics.HostData;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MemorySettings;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.system.CpuArch;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class MemorySettingsUtil {
    private static final Logger LOG = Logger.getInstance(MemorySettingsUtil.class);
    private static final int MIN_RAM_IN_GB_FOR_CONFIG = 5;
    static final int NO_XMX_IN_VM_ARGS = -1;

    public static boolean memorySettingsEnabled() {
        return !CpuArch.is32Bit() && MemorySettingsUtil.getMachineMem() >= 5120;
    }

    public static int getCurrentXmx() {
        int current;
        int stored = VMOptions.readOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (boolean)false);
        int n = current = stored == -1 ? VMOptions.readOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (boolean)true) : stored;
        if (ApplicationManager.getApplication().isUnitTestMode() && current == 2048) {
            LOG.info("current Xmx reaches IDE_XMX_CAP_IN_GB already, reducing to 1GB");
            current = 1024;
        }
        return current;
    }

    @Nullable
    public static Long getMachineMemoryBytes() {
        OperatingSystemMXBean osBean = HostData.getOsBean();
        return osBean == null ? null : Long.valueOf(osBean.getTotalPhysicalMemorySize());
    }

    public static int getMachineMem() {
        Long bytes2 = MemorySettingsUtil.getMachineMemoryBytes();
        return bytes2 == null ? -1 : Math.toIntExact(bytes2 >> 20);
    }

    public static void saveXmx(int newValue) {
        if (newValue <= 0) {
            LOG.info(String.format(Locale.US, "invalid value for Xmx: %d", newValue));
            return;
        }
        LOG.info("saving new Xmx value: " + newValue);
        try {
            VMOptions.setOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (int)newValue);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void log(MemorySettingsEvent.EventKind kind, int currentIdeXmx, int currentGradleXmx, int currentKotlinXmx, int recommendedIdeXmx, int recommendedGradleXmx, int recommendedKotlinXmx, int changedIdeXmx, int changedGradleXmx, int changedKotlinXmx) {
        if (!ApplicationManager.getApplication().isInternal() && StatisticsUploadAssistant.isSendAllowed()) {
            MemorySettingsEvent.Builder eventBuilder = MemorySettingsEvent.newBuilder().setKind(kind).setCurrent(MemorySettingsUtil.createMemorySettings(currentIdeXmx, currentGradleXmx, currentKotlinXmx)).setRecommended(MemorySettingsUtil.createMemorySettings(recommendedIdeXmx, recommendedGradleXmx, recommendedKotlinXmx)).setChanged(MemorySettingsUtil.createMemorySettings(changedIdeXmx, changedGradleXmx, changedKotlinXmx));
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MEMORY_SETTINGS_EVENT).setMemorySettingsEvent(eventBuilder));
        }
    }

    @Nullable
    public static Project getCurrentProject() {
        Project project;
        Project result2 = null;
        Window activeWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (activeWindow != null && (project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)activeWindow))) != null && !project.isDefault()) {
            result2 = project;
        }
        return result2;
    }

    private static MemorySettings.Builder createMemorySettings(int ideXmx, int gradleXmx, int kotlinXmx) {
        MemorySettings.Builder builder = MemorySettings.newBuilder();
        if (ideXmx > 0) {
            builder.setIdeXmx(ideXmx);
        }
        if (gradleXmx > 0) {
            builder.setGradleDaemonXmx(gradleXmx);
        }
        if (kotlinXmx > 0) {
            builder.setKotlinDaemonXmx(kotlinXmx);
        }
        return builder;
    }
}

