/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.gradle.util.GradleProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradlePropertiesUtil {
    private static final String XMX_PROPERTY = "-Xmx";
    private static final String TOP_SPLIT_REGEX = "([^ \"']|\"[^\"]*\"|'[^']*')+";
    private static final String INNER_SPLIT_REGEX = "([^, \"']|\"[^\"]*\"|'[^']*')+";
    private static final String TOP_DELIMITER = " ";
    private static final String INNER_DELIMITER = ",";
    private static final String KOTLIN_JVM_OPTIONS_PROPERTY = "-Dkotlin.daemon.jvm.options";

    static boolean hasJvmArgs(GradleProperties properties) {
        return properties != null && properties.getJvmArgs() != null;
    }

    static int getGradleDaemonXmx(GradleProperties properties) {
        return properties == null ? -1 : GradlePropertiesUtil.getXmxFromVmArgs(properties.getJvmArgs(), TOP_SPLIT_REGEX);
    }

    static int getKotlinDaemonXmx(GradleProperties properties) {
        return properties == null ? -1 : GradlePropertiesUtil.getKotlinXmxFromVMArgs(properties.getJvmArgs());
    }

    static void setDaemonXmx(GradleProperties properties, int gradleValue, int kotlinValue) throws IOException {
        if (gradleValue > 0 || kotlinValue > 0) {
            properties.setJvmArgs(GradlePropertiesUtil.setDaemonXmx(properties.getJvmArgs(), gradleValue, kotlinValue));
            properties.save();
        }
    }

    @VisibleForTesting
    static String setDaemonXmx(String vmArgs, int gradleValue, int kotlinValue) {
        String result2 = vmArgs;
        if (gradleValue > 0) {
            result2 = GradlePropertiesUtil.setXmxInVmArgs(result2, TOP_SPLIT_REGEX, TOP_DELIMITER, gradleValue);
        }
        if (kotlinValue > 0) {
            if (Strings.isNullOrEmpty((String)result2)) {
                return GradlePropertiesUtil.kotlinXmxJvmOption(kotlinValue);
            }
            List<String> properties = GradlePropertiesUtil.splitProperties(result2, TOP_SPLIT_REGEX);
            int i = GradlePropertiesUtil.getLastIndexOfProperty(properties, KOTLIN_JVM_OPTIONS_PROPERTY);
            if (i == -1) {
                properties.add(1, GradlePropertiesUtil.kotlinXmxJvmOption(kotlinValue));
            } else {
                String kotlinDaemonJvmOptions = GradlePropertiesUtil.getKotlinDaemonJvmOptions(properties.get(i));
                String newKotlinDaemonJvmOptions = GradlePropertiesUtil.setXmxInVmArgs(kotlinDaemonJvmOptions, INNER_SPLIT_REGEX, INNER_DELIMITER, kotlinValue);
                properties.set(i, String.format(Locale.US, "%s=\"%s\"", KOTLIN_JVM_OPTIONS_PROPERTY, newKotlinDaemonJvmOptions));
            }
            result2 = String.join((CharSequence)TOP_DELIMITER, properties);
        }
        return result2;
    }

    private static String setXmxInVmArgs(String vmArgs, String regex, String delimiter, int value2) {
        if (Strings.isNullOrEmpty((String)vmArgs)) {
            return GradlePropertiesUtil.getXmxString(value2);
        }
        List<String> properties = GradlePropertiesUtil.splitProperties(vmArgs, regex);
        int i = GradlePropertiesUtil.getLastIndexOfProperty(properties, XMX_PROPERTY);
        if (i == -1) {
            properties.add(1, GradlePropertiesUtil.getXmxString(value2));
        } else {
            properties.set(i, GradlePropertiesUtil.getXmxString(value2));
        }
        return String.join((CharSequence)delimiter, properties);
    }

    private static String getXmxString(int value2) {
        return String.format(Locale.US, "%s%sM", XMX_PROPERTY, Integer.toString(value2));
    }

    private static String kotlinXmxJvmOption(int value2) {
        return String.format(Locale.US, String.format("%s=\"%s%sM\"", KOTLIN_JVM_OPTIONS_PROPERTY, XMX_PROPERTY, value2), new Object[0]);
    }

    private static List<String> splitProperties(String vmArgs, String regex) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher regexMatcher = pattern.matcher(vmArgs);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList;
    }

    private static int getLastIndexOfProperty(List<String> properties, String prefix) {
        for (int i = properties.size() - 1; i >= 0; --i) {
            String property2 = properties.get(i);
            if (!property2.startsWith(prefix)) continue;
            return i;
        }
        return -1;
    }

    private static String getProperty(String vmArgs, String regex, String prefix) {
        List<String> properties = GradlePropertiesUtil.splitProperties(vmArgs, regex);
        int i = GradlePropertiesUtil.getLastIndexOfProperty(properties, prefix);
        return i == -1 ? null : properties.get(i);
    }

    private static int getKotlinXmxFromVMArgs(String vmArgs) {
        if (Strings.isNullOrEmpty((String)vmArgs)) {
            return -1;
        }
        String kotlinProperty = GradlePropertiesUtil.getProperty(vmArgs, TOP_SPLIT_REGEX, KOTLIN_JVM_OPTIONS_PROPERTY);
        if (kotlinProperty == null) {
            return -1;
        }
        String kotlinJvmOptions = GradlePropertiesUtil.getKotlinDaemonJvmOptions(kotlinProperty);
        return kotlinJvmOptions == null ? -1 : GradlePropertiesUtil.getXmxFromVmArgs(kotlinJvmOptions, INNER_SPLIT_REGEX);
    }

    private static String getKotlinDaemonJvmOptions(String property2) {
        int i = property2.indexOf(61);
        if (i < 0) {
            return null;
        }
        String kotlinJvmOptions = property2.substring(i + 1);
        return kotlinJvmOptions.replaceAll("^['|\"]|['|\"]$", "");
    }

    private static int getXmxFromVmArgs(String vmArgs, String regex) {
        if (Strings.isNullOrEmpty((String)vmArgs)) {
            return -1;
        }
        String xmxProperty = GradlePropertiesUtil.getProperty(vmArgs, regex, XMX_PROPERTY);
        if (xmxProperty == null) {
            return -1;
        }
        return GradlePropertiesUtil.parseMemorySizeInMB(xmxProperty.substring(XMX_PROPERTY.length()));
    }

    private static int parseMemorySizeInMB(String size) {
        try {
            for (int i = 0; i < size.length(); ++i) {
                char c = size.charAt(i);
                if (Character.isDigit(c)) continue;
                if (i == 0) {
                    return -1;
                }
                String digits = size.substring(0, i);
                long value2 = Long.parseLong(digits);
                switch (c) {
                    case 'T': 
                    case 't': {
                        return Math.toIntExact(value2 * 1024L * 1024L);
                    }
                    case 'G': 
                    case 'g': {
                        return Math.toIntExact(value2 * 1024L);
                    }
                    case 'M': 
                    case 'm': {
                        return Math.toIntExact(value2);
                    }
                    case 'K': 
                    case 'k': {
                        return Math.toIntExact(value2 / 1024L);
                    }
                }
                return -1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return -1;
    }
}

