/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.BuildSystemComponent;
import com.android.tools.idea.memorysettings.DaemonMemorySettings;
import com.android.tools.idea.memorysettings.MemorySettingsConfigurable;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonsUi;

public class GradleComponent
extends BuildSystemComponent {
    private JPanel myPanel;
    private ComboBox<Integer> myGradleDaemonXmxBox;
    private ComboBox<Integer> myKotlinDaemonXmxBox;
    private HyperlinkLabel myShowDaemonsLabel;
    private JBLabel myDaemonInfoLabel;
    private static final int SIZE_INCREMENT = 1024;
    private final Project myProject;
    private int myCurrentGradleXmx;
    private int myCurrentKotlinXmx;
    private int mySelectedGradleXmx;
    private int mySelectedKotlinXmx;
    private DaemonMemorySettings myDaemonMemorySettings;

    GradleComponent() {
        this.setupUI();
        this.myProject = MemorySettingsUtil.getCurrentProject();
        this.setUI();
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    public boolean isModified() {
        return this.isGradleDaemonXmxModified() || this.isKotlinDaemonXmxModified();
    }

    @Override
    public void reset() {
        this.myGradleDaemonXmxBox.setSelectedItem((Object)this.myCurrentGradleXmx);
        this.mySelectedGradleXmx = this.myCurrentGradleXmx;
        this.myKotlinDaemonXmxBox.setSelectedItem((Object)this.myCurrentKotlinXmx);
        this.mySelectedKotlinXmx = this.myCurrentKotlinXmx;
    }

    @Override
    public void apply() {
        this.myCurrentGradleXmx = this.mySelectedGradleXmx;
        this.myCurrentKotlinXmx = this.mySelectedKotlinXmx;
        this.myDaemonMemorySettings.saveProjectDaemonXmx(this.myCurrentGradleXmx, this.myCurrentKotlinXmx);
    }

    @Override
    public void setUI() {
        this.myDaemonMemorySettings = new DaemonMemorySettings(this.myProject);
        this.mySelectedGradleXmx = this.myCurrentGradleXmx = this.myDaemonMemorySettings.getProjectGradleDaemonXmx();
        this.mySelectedKotlinXmx = this.myCurrentKotlinXmx = this.myDaemonMemorySettings.getProjectKotlinDaemonXmx();
        if (this.myDaemonMemorySettings.hasUserPropertiesPath()) {
            MemorySettingsConfigurable.MyComponent.setXmxBoxWithOnlyCurrentValue(this.myGradleDaemonXmxBox, this.myCurrentGradleXmx);
            MemorySettingsConfigurable.MyComponent.setXmxBoxWithOnlyCurrentValue(this.myKotlinDaemonXmxBox, this.myCurrentKotlinXmx);
            this.myDaemonInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.has.user.properties", this.myDaemonMemorySettings.getUserPropertiesPath())));
            this.myShowDaemonsLabel.setVisible(false);
        } else {
            this.setDaemonPanelWhenNoUserGradleProperties();
        }
    }

    @Override
    public void fillCurrent(BuildSystemComponent.BuildSystemXmxs xmxs) {
        xmxs.gradleXmx = this.myCurrentGradleXmx;
        xmxs.kotlinXmx = this.myCurrentKotlinXmx;
    }

    @Override
    public void fillChanged(BuildSystemComponent.BuildSystemXmxs xmxs) {
        xmxs.gradleXmx = this.mySelectedGradleXmx;
        xmxs.kotlinXmx = this.mySelectedKotlinXmx;
    }

    private void setDaemonPanelWhenNoUserGradleProperties() {
        MemorySettingsConfigurable.MyComponent.setXmxBox(this.myGradleDaemonXmxBox, this.myCurrentGradleXmx, -1, this.myDaemonMemorySettings.getDefaultGradleDaemonXmx(), 2048, 512, event -> {
            if (event.getStateChange() == 1 && event.getItem() != null) {
                this.mySelectedGradleXmx = (Integer)event.getItem();
            }
        });
        MemorySettingsConfigurable.MyComponent.setXmxBox(this.myKotlinDaemonXmxBox, this.myCurrentKotlinXmx, -1, this.myDaemonMemorySettings.getDefaultKotlinDaemonXmx(), 2048, 512, event -> {
            if (event.getStateChange() == 1 && event.getItem() != null) {
                this.mySelectedKotlinXmx = (Integer)event.getItem();
            }
        });
        this.myDaemonInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.panel.daemon.info", new Object[0])));
    }

    private boolean isGradleDaemonXmxModified() {
        return this.mySelectedGradleXmx != this.myCurrentGradleXmx;
    }

    private boolean isKotlinDaemonXmxModified() {
        return this.mySelectedKotlinXmx != this.myCurrentKotlinXmx;
    }

    private void setupUI() {
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)this.myPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Daemon Heap Size Settings", (int)0, (int)0, null, null));
        JBLabel jBLabel1 = new JBLabel();
        Font jBLabel1Font = this.getFont(null, -1, 12, jBLabel1.getFont());
        if (jBLabel1Font != null) {
            jBLabel1.setFont(jBLabel1Font);
        }
        jBLabel1.setText("Gradle daemon max heap size:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(190, -1), new Dimension(190, -1), 0, false));
        this.myGradleDaemonXmxBox = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("1024");
        defaultComboBoxModel1.addElement("1280");
        defaultComboBoxModel1.addElement("2048");
        defaultComboBoxModel1.addElement("3072");
        defaultComboBoxModel1.addElement("4096");
        this.myGradleDaemonXmxBox.setModel(defaultComboBoxModel1);
        this.myPanel.add((Component)this.myGradleDaemonXmxBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1), 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(4, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        Font jBLabel2Font = this.getFont(null, -1, 12, jBLabel2.getFont());
        if (jBLabel2Font != null) {
            jBLabel2.setFont(jBLabel2Font);
        }
        jBLabel2.setText("Kotlin daemon max heap size:");
        this.myPanel.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(190, -1), new Dimension(190, -1), 0, false));
        this.myKotlinDaemonXmxBox = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("1024");
        defaultComboBoxModel2.addElement("1280");
        defaultComboBoxModel2.addElement("2048");
        defaultComboBoxModel2.addElement("3072");
        defaultComboBoxModel2.addElement("4096");
        this.myKotlinDaemonXmxBox.setModel(defaultComboBoxModel2);
        this.myPanel.add((Component)this.myKotlinDaemonXmxBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1), 0, false));
        Spacer spacer2 = new Spacer();
        this.myPanel.add((Component)spacer2, new GridConstraints(6, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myShowDaemonsLabel = new HyperlinkLabel();
        this.myShowDaemonsLabel.setHyperlinkText(AndroidBundle.message("memory.settings.panel.show.daemons.info", new Object[0]));
        this.myShowDaemonsLabel.addHyperlinkListener((HyperlinkListener)this.createDisplayGradleDaemonsHyperlink());
        this.myPanel.add((Component)this.myShowDaemonsLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10), 0, false));
        this.myDaemonInfoLabel = new JBLabel();
        this.myDaemonInfoLabel.setText("Label");
        this.myPanel.add((Component)this.myDaemonInfoLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(600, -1), null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myPanel.add((Component)spacer4, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10), 0, false));
        Spacer spacer5 = new Spacer();
        this.myPanel.add((Component)spacer5, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10), 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private HyperlinkAdapter createDisplayGradleDaemonsHyperlink() {
        return new HyperlinkAdapter(){
            DaemonsUi myUi;

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                this.myUi = new DaemonsUi(GradleComponent.this.myProject){

                    public void dispose() {
                        myUi = null;
                    }
                };
                ApplicationManager.getApplication().invokeLater(() -> this.myUi.show(), ModalityState.current());
            }
        };
    }
}

