/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.download;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.material.icons.common.MaterialSymbolsUrlProvider;
import com.android.tools.idea.material.icons.common.SymbolConfiguration;
import com.android.tools.idea.material.icons.common.Symbols;
import com.android.tools.idea.material.icons.download.MaterialSymbolsUpdaterKt;
import com.intellij.openapi.util.Pair;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/material/icons/download/MaterialSymbolsUpdater;", "", "<init>", "()V", "Companion", "intellij.android.android-material"})
public final class MaterialSymbolsUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String METADATA_DOWNLOAD_URL = "https://fonts.google.com/metadata/icons?key=material_symbols&incomplete=true";
    @NotNull
    private static final String DOWNLOADED_METADATA_FILE_NAME = "icons_metadata_temp.txt";
    @NotNull
    private static final String FONT_FILE_DOWNLOADER_NAME = "MaterialSymbolsFont";
    @NotNull
    private static final String METADATA_DOWNLOADER_NAME = "MaterialSymbolsMetadata";
    @NotNull
    private static final String SYMBOL_VD_DOWNLOADER_NAME = "PickedMaterialSymbol";
    @NotNull
    private static final String FONT_EXTENSION = ".ttf";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J0\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/material/icons/download/MaterialSymbolsUpdater$Companion;", "", "<init>", "()V", "METADATA_DOWNLOAD_URL", "", "DOWNLOADED_METADATA_FILE_NAME", "FONT_FILE_DOWNLOADER_NAME", "METADATA_DOWNLOADER_NAME", "SYMBOL_VD_DOWNLOADER_NAME", "FONT_EXTENSION", "downloadFontFiles", "", "type", "Lcom/android/tools/idea/material/icons/common/Symbols;", "materialSymbolsUrlProvider", "Lcom/android/tools/idea/material/icons/common/MaterialSymbolsUrlProvider;", "downloadMetadataFile", "downloadVdIcon", "symbolConfiguration", "Lcom/android/tools/idea/material/icons/common/SymbolConfiguration;", "symbolName", "downloadAndMove", "downloadUrl", "tempFileName", "finalFileName", "downloadFolder", "Ljava/io/File;", "downloaderName", "intellij.android.android-material"})
    public static final class Companion {
        private Companion() {
        }

        @Slow
        public final void downloadFontFiles(@NotNull Symbols type, @NotNull MaterialSymbolsUrlProvider materialSymbolsUrlProvider) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)materialSymbolsUrlProvider, (String)"materialSymbolsUrlProvider");
            URL url = materialSymbolsUrlProvider.getRemoteFontUrl(type);
            File file = materialSymbolsUrlProvider.getLocalFontDirectoryFile(type);
            if (file == null) {
                return;
            }
            File folder = file;
            String fileName = type.getRemoteFileName();
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.downloadAndMove(string, fileName, type.getLocalName() + MaterialSymbolsUpdater.FONT_EXTENSION, folder, MaterialSymbolsUpdater.FONT_FILE_DOWNLOADER_NAME);
        }

        @Slow
        public final void downloadMetadataFile(@NotNull MaterialSymbolsUrlProvider materialSymbolsUrlProvider) {
            Intrinsics.checkNotNullParameter((Object)materialSymbolsUrlProvider, (String)"materialSymbolsUrlProvider");
            File file = materialSymbolsUrlProvider.getLocalSymbolsPath();
            if (file == null) {
                return;
            }
            File folder = file;
            this.downloadAndMove(MaterialSymbolsUpdater.METADATA_DOWNLOAD_URL, MaterialSymbolsUpdater.DOWNLOADED_METADATA_FILE_NAME, "icons_metadata.txt", folder, MaterialSymbolsUpdater.METADATA_DOWNLOADER_NAME);
        }

        @Slow
        public final void downloadVdIcon(@NotNull SymbolConfiguration symbolConfiguration, @NotNull String symbolName, @NotNull MaterialSymbolsUrlProvider materialSymbolsUrlProvider) {
            File file;
            Intrinsics.checkNotNullParameter((Object)symbolConfiguration, (String)"symbolConfiguration");
            Intrinsics.checkNotNullParameter((Object)symbolName, (String)"symbolName");
            Intrinsics.checkNotNullParameter((Object)materialSymbolsUrlProvider, (String)"materialSymbolsUrlProvider");
            File file2 = materialSymbolsUrlProvider.getLocalSymbolsPath();
            if (file2 == null || (file = FilesKt.resolve((File)file2, (String)(symbolConfiguration.getType().getLocalName() + "/" + symbolName))) == null) {
                return;
            }
            File folder = file;
            String fileName = symbolConfiguration.toFileName(symbolName);
            String remoteUrl = symbolConfiguration.toUrlString(symbolName);
            this.downloadAndMove(remoteUrl, fileName + ".tmp", fileName, folder, MaterialSymbolsUpdater.SYMBOL_VD_DOWNLOADER_NAME);
        }

        private final void downloadAndMove(String downloadUrl, String tempFileName, String finalFileName, File downloadFolder, String downloaderName) {
            try {
                DownloadableFileService downloadService = DownloadableFileService.getInstance();
                List fileDescription = CollectionsKt.listOf((Object)downloadService.createFileDescription(downloadUrl, tempFileName));
                FileDownloader fileDownloader = downloadService.createDownloader(fileDescription, downloaderName);
                Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
                FileDownloader downloader = fileDownloader;
                List list = downloader.download(downloadFolder);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"download(...)");
                File downloadedFile = (File)((Pair)CollectionsKt.first((List)list)).first;
                Path path = downloadedFile.toPath();
                File file = downloadedFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(path, FilesKt.resolve((File)file, (String)finalFileName).toPath(), copyOptionArray);
                downloadedFile.delete();
            }
            catch (Throwable e) {
                MaterialSymbolsUpdaterKt.access$getLOG$p().warn("Download failed for " + finalFileName + " with error: " + e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

