/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.common;

import com.android.tools.idea.material.icons.common.MaterialSymbolsUrlProvider;
import com.android.tools.idea.material.icons.common.Symbols;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/material/icons/common/SymbolsSdkUrlProvider;", "Lcom/android/tools/idea/material/icons/common/MaterialSymbolsUrlProvider;", "<init>", "()V", "HOST", "", "EXTENSION", "FOLDER", "getRemoteFontUrl", "Ljava/net/URL;", "type", "Lcom/android/tools/idea/material/icons/common/Symbols;", "getLocalFontDirectoryFile", "Ljava/io/File;", "getLocalFontFile", "getLocalSymbolsPath", "hasFontPathInSdk", "", "intellij.android.android-material"})
public final class SymbolsSdkUrlProvider
implements MaterialSymbolsUrlProvider {
    @NotNull
    private final String HOST;
    @NotNull
    private final String EXTENSION;
    @NotNull
    private final String FOLDER;

    public SymbolsSdkUrlProvider() {
        this.HOST = "https://raw.githubusercontent.com/google/material-design-icons/master/";
        this.EXTENSION = ".ttf";
        this.FOLDER = "variablefont/";
    }

    @Override
    @NotNull
    public URL getRemoteFontUrl(@NotNull Symbols type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String fileName = type.getRemoteFileName();
        String encodedString = URLEncoder.encode(fileName, "UTF-8");
        URL url = new URL(this.HOST + this.FOLDER + encodedString + this.EXTENSION);
        return url;
    }

    @Override
    @Nullable
    public File getLocalFontDirectoryFile(@NotNull Symbols type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String directoryName = type.getLocalName();
        File file = MaterialIconsUtils.INSTANCE.getIconsSdkTargetPath();
        if (file == null || (file = FilesKt.resolve((File)file, (String)(this.FOLDER + directoryName))) == null) {
            return null;
        }
        File fontDirectoryPath = file;
        return fontDirectoryPath;
    }

    @Override
    @Nullable
    public File getLocalFontFile(@NotNull Symbols type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String fileName = type.getLocalName() + this.EXTENSION;
        File file = this.getLocalFontDirectoryFile(type);
        if (file == null || (file = FilesKt.resolve((File)file, (String)fileName)) == null) {
            return null;
        }
        File fontFilePath = file;
        return fontFilePath;
    }

    @Override
    @Nullable
    public File getLocalSymbolsPath() {
        return MaterialIconsUtils.INSTANCE.getIconsSdkTargetPath();
    }

    @Override
    public boolean hasFontPathInSdk(@NotNull Symbols type) {
        File fontFilePath;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        File file = fontFilePath = this.getLocalFontFile(type);
        return file != null ? file.exists() : false;
    }
}

