/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.material.icons.MaterialIconsCopyHandlerKt;
import com.android.tools.idea.material.icons.MaterialVdIcons;
import com.android.tools.idea.material.icons.VdIconURLWithFileName;
import com.android.tools.idea.material.icons.VdIconWriteData;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataBuilder;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import com.android.utils.SdkUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/material/icons/MaterialIconsCopyHandler;", "", "metadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "materialVdIcons", "Lcom/android/tools/idea/material/icons/MaterialVdIcons;", "<init>", "(Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;Lcom/android/tools/idea/material/icons/MaterialVdIcons;)V", "host", "", "urlPattern", "families", "", "[Ljava/lang/String;", "iconNameToWriteData", "Ljava/util/LinkedList;", "Lcom/android/tools/idea/material/icons/VdIconWriteData;", "copyTo", "", "targetPath", "Ljava/io/File;", "getRemainingIconsToCopy", "", "metadataBuilder", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadataBuilder;", "copyIcons", "iconsToCopy", "copyIcon", "iconUrl", "Ljava/net/URL;", "iconFileName", "family", "iconMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialMetadataIcon;", "updateTemporaryMetadataFile", "alreadyCopied", "", "restoreMetadata", "updateFinishedMetadataFileName", "intellij.android.android-material"})
@SourceDebugExtension(value={"SMAP\nMaterialIconsCopyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialIconsCopyHandler.kt\ncom/android/tools/idea/material/icons/MaterialIconsCopyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1869#2:214\n1869#2,2:215\n1870#2:217\n1869#2,2:218\n1869#2:222\n1870#2:225\n13472#3,2:220\n13472#3,2:227\n216#4,2:223\n1#5:226\n*S KotlinDebug\n*F\n+ 1 MaterialIconsCopyHandler.kt\ncom/android/tools/idea/material/icons/MaterialIconsCopyHandler\n*L\n66#1:214\n67#1:215,2\n66#1:217\n82#1:218,2\n130#1:222\n130#1:225\n117#1:220,2\n180#1:227,2\n136#1:223,2\n*E\n"})
public final class MaterialIconsCopyHandler {
    @NotNull
    private final String host;
    @NotNull
    private final String urlPattern;
    @NotNull
    private final String[] families;
    @NotNull
    private final LinkedList<VdIconWriteData> iconNameToWriteData;

    public MaterialIconsCopyHandler(@NotNull MaterialIconsMetadata metadata, @NotNull MaterialVdIcons materialVdIcons) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)materialVdIcons, (String)"materialVdIcons");
        this.host = metadata.getHost();
        this.urlPattern = metadata.getUrlPattern();
        this.families = metadata.getFamilies();
        this.iconNameToWriteData = new LinkedList();
        Set icons = ArraysKt.toSet((Object[])metadata.getIcons());
        HashMap iconNameToStyleAndUrl = new HashMap();
        Iterable $this$forEach$iv = materialVdIcons.getStyles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String style = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = materialVdIcons.getAllIcons(style);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                Map map2;
                VdIcon vdIcon = (VdIcon)element$iv2;
                boolean bl2 = false;
                String string = vdIcon.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                String iconName = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
                if (!((Map)iconNameToStyleAndUrl).containsKey(iconName)) {
                    map2 = iconNameToStyleAndUrl;
                    object = new HashMap<String, VdIconURLWithFileName>();
                    HashMap<String, VdIconURLWithFileName> $this$lambda_u242_u24lambda_u241_u24lambda_u240 = object;
                    boolean bl3 = false;
                    URL uRL = vdIcon.getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
                    String string2 = vdIcon.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    $this$lambda_u242_u24lambda_u241_u24lambda_u240.put(style, new VdIconURLWithFileName(uRL, string2));
                    map2.put(iconName, object);
                    continue;
                }
                Object v = iconNameToStyleAndUrl.get(iconName);
                Intrinsics.checkNotNull(v);
                map2 = (Map)v;
                URL uRL = vdIcon.getURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
                String string3 = vdIcon.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                object = new VdIconURLWithFileName(uRL, string3);
                map2.put(style, object);
            }
        }
        $this$forEach$iv = icons;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MaterialMetadataIcon it = (MaterialMetadataIcon)element$iv;
            boolean bl = false;
            if (iconNameToStyleAndUrl.containsKey(it.getName())) {
                Object v = iconNameToStyleAndUrl.get(it.getName());
                Intrinsics.checkNotNull(v);
                this.iconNameToWriteData.add(new VdIconWriteData((HashMap)v, it));
                continue;
            }
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("Files not found for '" + it.getName() + "'");
        }
    }

    @Slow
    public final void copyTo(@NotNull File targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (!targetPath.isDirectory()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.alreadyCopied(targetPath)) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().info("Icons have already been copied to this directory.");
            return;
        }
        MaterialIconsMetadataBuilder metadataBuilder = this.restoreMetadata(targetPath);
        Set<VdIconWriteData> iconsToCopy = this.getRemainingIconsToCopy(metadataBuilder);
        if (iconsToCopy.isEmpty()) {
            return;
        }
        this.copyIcons(iconsToCopy, metadataBuilder, targetPath);
    }

    private final Set<VdIconWriteData> getRemainingIconsToCopy(MaterialIconsMetadataBuilder metadataBuilder) {
        Set iconsToCopy = CollectionsKt.toMutableSet((Iterable)this.iconNameToWriteData);
        MaterialMetadataIcon[] $this$forEach$iv = metadataBuilder.build().getIcons();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MaterialMetadataIcon element$iv;
            MaterialMetadataIcon iconMetadata = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            iconsToCopy.removeIf(arg_0 -> MaterialIconsCopyHandler.getRemainingIconsToCopy$lambda$6$lambda$5(arg_0 -> MaterialIconsCopyHandler.getRemainingIconsToCopy$lambda$6$lambda$4(iconMetadata, arg_0), arg_0));
        }
        return iconsToCopy;
    }

    private final void copyIcons(Set<VdIconWriteData> iconsToCopy, MaterialIconsMetadataBuilder metadataBuilder, File targetPath) {
        boolean cancelled = false;
        Iterable $this$forEach$iv = iconsToCopy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VdIconWriteData writeData = (VdIconWriteData)element$iv;
            boolean bl = false;
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            boolean bl2 = progressIndicator != null ? progressIndicator.isCanceled() : false;
            if (bl2) {
                cancelled = true;
                continue;
            }
            MaterialMetadataIcon iconMetadata = writeData.getMetadataIcon();
            Map $this$forEach$iv2 = writeData.getStylesToURLAndName();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl3 = false;
                String family = (String)entry.getKey();
                VdIconURLWithFileName urlAndFileName = (VdIconURLWithFileName)entry.getValue();
                if (ArraysKt.contains((Object[])iconMetadata.getUnsupportedFamilies(), (Object)family)) continue;
                this.copyIcon(urlAndFileName.getUrl(), urlAndFileName.getFileName(), family, iconMetadata, targetPath);
            }
            metadataBuilder.addIconMetadata(iconMetadata);
        }
        this.updateTemporaryMetadataFile(metadataBuilder, targetPath);
        if (!cancelled) {
            this.updateFinishedMetadataFileName(targetPath);
        }
    }

    private final void copyIcon(URL iconUrl, String iconFileName, String family, MaterialMetadataIcon iconMetadata, File targetPath) {
        Serializable serializable;
        File $this$copyIcon_u24lambda_u249 = serializable = FilesKt.resolve((File)FilesKt.resolve((File)targetPath, (String)MaterialIconsUtils.INSTANCE.toDirFormat(family)), (String)iconMetadata.getName());
        boolean bl = false;
        $this$copyIcon_u24lambda_u249.mkdirs();
        File vdIconDir = serializable;
        serializable = iconUrl;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)serializable);
        FilesKt.writeText$default((File)new File(vdIconDir, iconFileName), (String)new String(byArray, charset), null, (int)2, null);
    }

    private final void updateTemporaryMetadataFile(MaterialIconsMetadataBuilder metadataBuilder, File targetPath) {
        Path tempFilePath = targetPath.toPath().resolve("icons_metadata_temp_copy.txt");
        MaterialIconsMetadata materialIconsMetadata = metadataBuilder.build();
        Intrinsics.checkNotNull((Object)tempFilePath);
        MaterialIconsMetadata.Companion.writeAsJson(materialIconsMetadata, tempFilePath, MaterialIconsCopyHandlerKt.access$getLOG$p());
    }

    private final boolean alreadyCopied(File targetPath) {
        File $this$alreadyCopied_u24lambda_u2410 = new File(targetPath, "icons_metadata.txt");
        boolean bl = false;
        return !$this$alreadyCopied_u24lambda_u2410.isDirectory() && $this$alreadyCopied_u24lambda_u2410.exists();
    }

    private final MaterialIconsMetadataBuilder restoreMetadata(File targetPath) {
        MaterialIconsMetadataBuilder metadataBuilder;
        block3: {
            metadataBuilder = new MaterialIconsMetadataBuilder(this.host, this.urlPattern, this.families);
            File metadataTempFile = new File(targetPath, "icons_metadata_temp_copy.txt");
            if (!metadataTempFile.exists() || metadataTempFile.isDirectory()) break block3;
            MaterialIconsCopyHandlerKt.access$getLOG$p().info("Continuing icons copy");
            URL uRL = SdkUtils.fileToUrl((File)metadataTempFile);
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"fileToUrl(...)");
            Object object = MaterialIconsMetadata.Companion.parse-IoAF18A(uRL);
            if (Result.isSuccess-impl((Object)object)) {
                MaterialIconsMetadata metadata = (MaterialIconsMetadata)object;
                boolean bl = false;
                MaterialMetadataIcon[] $this$forEach$iv = metadata.getIcons();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    MaterialMetadataIcon element$iv;
                    MaterialMetadataIcon it = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    metadataBuilder.addIconMetadata(it);
                }
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable t = throwable2 = throwable;
                boolean bl = false;
                MaterialIconsCopyHandlerKt.access$getLOG$p().warn("Failed to parse metadata " + metadataTempFile, t);
            }
        }
        return metadataBuilder;
    }

    private final void updateFinishedMetadataFileName(File targetPath) {
        File metadataFinishedFile = FilesKt.resolve((File)targetPath, (String)"icons_metadata.txt");
        File metadataTempFile = FilesKt.resolve((File)targetPath, (String)"icons_metadata_temp_copy.txt");
        if (!metadataTempFile.exists()) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("No temporary metadata file");
            return;
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(metadataTempFile.toPath(), metadataFinishedFile.toPath(), copyOptionArray);
        }
        catch (IOException e) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("Failed to rename temporary metadata file", (Throwable)e);
        }
    }

    private static final boolean getRemainingIconsToCopy$lambda$6$lambda$4(MaterialMetadataIcon $iconMetadata, VdIconWriteData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getMetadataIcon(), (Object)$iconMetadata);
    }

    private static final boolean getRemainingIconsToCopy$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

