/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.util;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.DocumentAppenderKt;
import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.settings.AndroidLogcatSettings;
import com.android.tools.idea.logcat.util.FilterHint;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0001\u001a\u0014\u0010\r\u001a\u00020\f*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\fH\u0001\u001a\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0015H\u0000\u001a\f\u0010\u0016\u001a\u00020\n*\u00020\u0015H\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DOC_VERSION_KEY", "Lcom/intellij/openapi/util/Key;", "", "createLogcatEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "updateFontSize", "", "isCaretAtBottom", "", "isScrollAtBottom", "useImmediatePosition", "getFilterHint", "Lcom/android/tools/idea/logcat/util/FilterHint;", "offset", "formattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "getVersion", "Lcom/intellij/openapi/editor/Document;", "incrementVersion", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorUtils.kt\ncom/android/tools/idea/logcat/util/EditorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class EditorUtilsKt {
    @NotNull
    private static final Key<Integer> DOC_VERSION_KEY = new Key("DOC_VERSION_KEY");

    @NotNull
    public static final EditorEx createLogcatEditor(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorFactoryImpl");
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(true);
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        ((DocumentImpl)document).setAcceptSlashR(true);
        UndoUtil.disableUndoFor((Document)document);
        Editor editor = ((EditorFactoryImpl)editorFactory).createViewer(document, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings editorSettings2 = editorSettings;
        editorSettings2.setAllowSingleLogicalLineFolding(true);
        editorSettings2.setLineMarkerAreaShown(false);
        editorSettings2.setIndentGuidesShown(false);
        editorSettings2.setLineNumbersShown(false);
        editorSettings2.setFoldingOutlineShown(true);
        editorSettings2.setAdditionalPageAtBottom(false);
        editorSettings2.setAdditionalColumnsCount(0);
        editorSettings2.setAdditionalLinesCount(0);
        editorSettings2.setRightMarginShown(false);
        editorSettings2.setCaretRowShown(false);
        editorSettings2.setShowingSpecialChars(false);
        editor2.getGutterComponentEx().setPaintBackground(false);
        EditorUtilsKt.updateFontSize(editor2);
        UISettingsListener uiSettingsListener = arg_0 -> EditorUtilsKt.createLogcatEditor$lambda$0(editor2, arg_0);
        MessageBusConnection bus = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        bus.subscribe(topic, (Object)uiSettingsListener);
        Topic topic2 = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        bus.subscribe(topic2, arg_0 -> EditorUtilsKt.createLogcatEditor$lambda$1(editor2, arg_0));
        return editor2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateFontSize(@NotNull EditorEx $this$updateFontSize) {
        void $this$updateFontSize_u24lambda_u242;
        DelegateColorScheme delegateColorScheme;
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$updateFontSize, (String)"<this>");
        AndroidLogcatSettings logcatSettings = AndroidLogcatSettings.Companion.getInstance();
        boolean bl = logcatSettings.getOverrideFontSize();
        if (bl) {
            f = JBUI.scale((int)logcatSettings.getFontSize());
        } else if (!bl) {
            f = UISettingsUtils.Companion.getInstance().getScaledConsoleFontSize();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float fontSize = f;
        $this$updateFontSize.setFontSize(fontSize);
        DelegateColorScheme delegateColorScheme2 = delegateColorScheme = ConsoleViewUtil.updateConsoleColorScheme((EditorColorsScheme)$this$updateFontSize.getColorsScheme());
        EditorEx editorEx = $this$updateFontSize;
        boolean bl2 = false;
        $this$updateFontSize_u24lambda_u242.setEditorFontSize(fontSize);
        editorEx.setColorsScheme((EditorColorsScheme)delegateColorScheme);
    }

    @UiThread
    public static final boolean isCaretAtBottom(@NotNull EditorEx $this$isCaretAtBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$isCaretAtBottom, (String)"<this>");
        DocumentEx it = $this$isCaretAtBottom.getDocument();
        boolean bl = false;
        return it.getLineNumber($this$isCaretAtBottom.getCaretModel().getOffset()) >= it.getLineCount() - 1;
    }

    @UiThread
    public static final boolean isScrollAtBottom(@NotNull EditorEx $this$isScrollAtBottom, boolean useImmediatePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$isScrollAtBottom, (String)"<this>");
        JScrollBar scrollBar = $this$isScrollAtBottom.getScrollPane().getVerticalScrollBar();
        int position = useImmediatePosition ? scrollBar.getValue() : $this$isScrollAtBottom.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return scrollBar.getMaximum() - scrollBar.getVisibleAmount() == position;
    }

    @Nullable
    public static final FilterHint getFilterHint(@NotNull EditorEx $this$getFilterHint, int offset, @NotNull FormattingOptions formattingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$getFilterHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        $this$getFilterHint.getDocument().processRangeMarkersOverlappingWith(offset, offset, arg_0 -> EditorUtilsKt.getFilterHint$lambda$5(arg_0 -> EditorUtilsKt.getFilterHint$lambda$4(offset, result2, formattingOptions, arg_0), arg_0));
        return (FilterHint)result2.element;
    }

    public static final int getVersion(@NotNull Document $this$getVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getVersion, (String)"<this>");
        return ((Number)ActionsKt.runReadAction(() -> EditorUtilsKt.getVersion$lambda$6($this$getVersion))).intValue();
    }

    @UiThread
    public static final void incrementVersion(@NotNull Document $this$incrementVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$incrementVersion, (String)"<this>");
        ActionsKt.runWriteAction(() -> EditorUtilsKt.incrementVersion$lambda$7($this$incrementVersion));
    }

    private static final void createLogcatEditor$lambda$0(EditorEx $editor, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorUtilsKt.updateFontSize($editor);
    }

    private static final void createLogcatEditor$lambda$1(EditorEx $editor, EditorColorsScheme it) {
        EditorUtilsKt.updateFontSize($editor);
    }

    private static final boolean getFilterHint$lambda$4(int $offset, Ref.ObjectRef $result, FormattingOptions $formattingOptions, RangeMarker it) {
        Object object = (LogcatMessage)it.getUserData(DocumentAppenderKt.getLOGCAT_MESSAGE_KEY());
        if (object == null || (object = ((LogcatMessage)object).getHeader()) == null) {
            return true;
        }
        Object header = object;
        int pos = $offset - it.getStartOffset();
        $result.element = $formattingOptions.getTagRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.Tag(((LogcatHeader)header).getTag(), $formattingOptions.getTagFormat().width() - 1) : ($formattingOptions.getAppIdRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.AppName(((LogcatHeader)header).getApplicationId(), $formattingOptions.getAppNameFormat().width() - 1) : ($formattingOptions.getLeveRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.Level(((LogcatHeader)header).getLogLevel()) : null));
        return false;
    }

    private static final boolean getFilterHint$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int getVersion$lambda$6(Document $this_getVersion) {
        Integer n = (Integer)$this_getVersion.getUserData(DOC_VERSION_KEY);
        return n != null ? n : 0;
    }

    private static final Unit incrementVersion$lambda$7(Document $this_incrementVersion) {
        int version2 = EditorUtilsKt.getVersion($this_incrementVersion);
        $this_incrementVersion.putUserData(DOC_VERSION_KEY, (Object)(version2 + 1));
        return Unit.INSTANCE;
    }
}

