/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.settings.AndroidLogcatSettings;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u00020\t*\u00020\u000eH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/logcat/filters/LogcatMasterFilter;", "", "logcatFilter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "<init>", "(Lcom/android/tools/idea/logcat/filters/LogcatFilter;)V", "settings", "Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;", "ignoreSpam", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "filter", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "messages", "zoneId", "Ljava/time/ZoneId;", "isSpam", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFilter.kt\ncom/android/tools/idea/logcat/filters/LogcatMasterFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n774#2:408\n865#2,2:409\n774#2:411\n865#2,2:412\n*S KotlinDebug\n*F\n+ 1 LogcatFilter.kt\ncom/android/tools/idea/logcat/filters/LogcatMasterFilter\n*L\n53#1:408\n53#1:409,2\n56#1:411\n56#1:412,2\n*E\n"})
public final class LogcatMasterFilter {
    @Nullable
    private final LogcatFilter logcatFilter;
    @NotNull
    private final AndroidLogcatSettings settings;
    private final Boolean ignoreSpam;

    public LogcatMasterFilter(@Nullable LogcatFilter logcatFilter) {
        this.logcatFilter = logcatFilter;
        this.settings = AndroidLogcatSettings.Companion.getInstance();
        this.ignoreSpam = (Boolean)StudioFlags.LOGCAT_IGNORE_STUDIO_TAGS.get();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogcatMessage> filter(@NotNull List<LogcatMessage> messages, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        if (this.logcatFilter == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = messages;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LogcatMessage it = (LogcatMessage)element$iv$iv;
                boolean bl = false;
                if (!(!this.isSpam(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        this.logcatFilter.prepare();
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LogcatMessage it = (LogcatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getHeader() == ConstantsKt.SYSTEM_HEADER || this.logcatFilter.matches(new LogcatMessageWrapper(it, zoneId)) && !this.isSpam(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List filter$default(LogcatMasterFilter logcatMasterFilter, List list, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault(...)");
            zoneId = zoneId2;
        }
        return logcatMasterFilter.filter(list, zoneId);
    }

    private final boolean isSpam(LogcatMessage $this$isSpam) {
        return this.settings.getIgnoredTags().contains($this$isSpam.getHeader().getTag()) || this.settings.getIgnoredApps().contains($this$isSpam.getHeader().getApplicationId()) || this.ignoreSpam != false && StringsKt.startsWith$default((String)$this$isSpam.getHeader().getTag(), (String)"studio.", (boolean)false, (int)2, null);
    }
}

