/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.files;

import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.files.LogcatFileParserKt;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0019\u001a\u00020\u0015*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/logcat/files/LogcatFileParser;", "", "headerRegex", "Lkotlin/text/Regex;", "zoneId", "Ljava/time/ZoneId;", "<init>", "(Lkotlin/text/Regex;Ljava/time/ZoneId;)V", "parseLogcatFile", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "path", "Ljava/nio/file/Path;", "isBugreport", "", "parseBugreportFile", "reader", "Ljava/io/BufferedReader;", "filename", "", "year", "", "toLogcatHeader", "Lcom/android/tools/idea/logcat/message/LogcatHeader;", "Lkotlin/text/MatchResult;", "creationYear", "Companion", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFileParser.kt\ncom/android/tools/idea/logcat/files/LogcatFileParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,173:1\n1#2:174\n32#3,2:175\n*S KotlinDebug\n*F\n+ 1 LogcatFileParser.kt\ncom/android/tools/idea/logcat/files/LogcatFileParser\n*L\n79#1:175,2\n*E\n"})
public final class LogcatFileParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex headerRegex;
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    public static final String SYSTEM_LOG_PREFIX = "--------- beginning of ";

    public LogcatFileParser(@NotNull Regex headerRegex, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)headerRegex, (String)"headerRegex");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.headerRegex = headerRegex;
        this.zoneId = zoneId;
    }

    public /* synthetic */ LogcatFileParser(Regex regex, ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault(...)");
            zoneId = zoneId2;
        }
        this(regex, zoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LogcatMessage> parseLogcatFile(@NotNull Path path, boolean isBugreport) {
        List<LogcatMessage> list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl = false;
            list = this.parseLogcatFile(it, ((Object)path).toString(), this.creationYear(path), isBugreport);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return list;
    }

    public static /* synthetic */ List parseLogcatFile$default(LogcatFileParser logcatFileParser, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return logcatFileParser.parseLogcatFile(path, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LogcatMessage> parseBugreportFile(@NotNull Path path) {
        Object v1;
        Object object;
        ZipFile zip;
        block7: {
            Sequence entries2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            zip = new ZipFile(((Object)path).toString());
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            object = entries2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            for (Object e : object) {
                ZipEntry it = (ZipEntry)e;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!LogcatFileParserKt.access$isBugreport(it)) continue;
                v1 = e;
                break block7;
            }
            v1 = null;
        }
        ZipEntry zipEntry = v1;
        if (zipEntry == null) {
            throw new IllegalArgumentException("Bugreport not found in " + path);
        }
        ZipEntry entry = zipEntry;
        InputStream inputStream = zip.getInputStream(entry);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)closeable, (Charset)object2);
        int n = 8192;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object = this.parseLogcatFile(it, ((Object)path).toString(), this.creationYear(path), true);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        return object;
    }

    private final List<LogcatMessage> parseLogcatFile(BufferedReader reader2, String filename, int year, boolean isBugreport) {
        List list;
        block10: {
            LogcatHeader currentHeader = null;
            StringBuilder currentMessage = new StringBuilder();
            PeekingIterator iterator2 = Iterators.peekingIterator((Iterator)CollectionsKt.withIndex((Iterator)TextStreamsKt.lineSequence((BufferedReader)reader2).iterator()));
            if (isBugreport) {
                Intrinsics.checkNotNull((Object)iterator2);
                boolean found = LogcatFileParserKt.access$consumeUntilLogcat(iterator2);
                if (!found) {
                    throw new IllegalStateException("SYSTEM LOG not found");
                }
            }
            List $this$parseLogcatFile_u24lambda_u247 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            List $this$parseLogcatFile_u24lambda_u247_u24lambda_u245 = $this$parseLogcatFile_u24lambda_u247;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)iterator2);
            Iterator $this$forEach$iv = (Iterator)iterator2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv;
            while (iterator3.hasNext()) {
                MatchResult result2;
                Object element$iv = iterator3.next();
                IndexedValue it = (IndexedValue)element$iv;
                boolean bl3 = false;
                String line = (String)it.getValue();
                if (isBugreport && LogcatFileParserKt.access$isEndOfLogcat(line)) {
                    boolean bl4 = LogcatFileParserKt.access$consumeUntilLogcat(iterator2);
                    if (bl4) continue;
                    if (!bl4) break;
                    throw new NoWhenBranchMatchedException();
                }
                if (StringsKt.startsWith$default((String)line, (String)SYSTEM_LOG_PREFIX, (boolean)false, (int)2, null)) {
                    $this$parseLogcatFile_u24lambda_u247_u24lambda_u245.add(new LogcatMessage(ConstantsKt.SYSTEM_HEADER, line));
                    currentHeader = null;
                    StringsKt.clear((StringBuilder)currentMessage);
                    continue;
                }
                if (Regex.find$default((Regex)this.headerRegex, (CharSequence)line, (int)0, (int)2, null) == null) {
                    throw new IllegalArgumentException("Error parsing [" + filename + ":" + (it.getIndex() + 1) + "]. Invalid logcat line: " + line);
                }
                LogcatHeader header = this.toLogcatHeader(result2, year);
                if (!Intrinsics.areEqual((Object)header, currentHeader)) {
                    if (currentHeader != null) {
                        LogcatHeader logcatHeader;
                        boolean bl5 = false;
                        String string = currentMessage.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        $this$parseLogcatFile_u24lambda_u247_u24lambda_u245.add(new LogcatMessage(logcatHeader, string));
                    }
                    currentHeader = header;
                    StringsKt.clear((StringBuilder)currentMessage);
                }
                if (((CharSequence)currentMessage).length() > 0) {
                    currentMessage.append('\n');
                }
                currentMessage.append(LogcatFileParserKt.access$getGroup(result2, "message"));
            }
            LogcatHeader logcatHeader = currentHeader;
            if (logcatHeader == null) break block10;
            LogcatHeader it = logcatHeader;
            boolean bl6 = false;
            if (((CharSequence)currentMessage).length() > 0) {
                String string = currentMessage.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$parseLogcatFile_u24lambda_u247.add(new LogcatMessage(it, string));
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final LogcatHeader toLogcatHeader(MatchResult $this$toLogcatHeader, int year) {
        Object $this$toLogcatHeader_u24lambda_u248;
        int month = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "month"));
        int day = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "day"));
        int hour = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "hour"));
        int minute = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "minute"));
        int second = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "second"));
        int nanos = (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "milli")));
        int pid = Integer.parseInt(LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "pid"));
        MatchResult matchResult = $this$toLogcatHeader;
        try {
            $this$toLogcatHeader_u24lambda_u248 = matchResult;
            boolean bl = false;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$toLogcatHeader_u24lambda_u248.getGroups(), (String)"tid");
            $this$toLogcatHeader_u24lambda_u248 = Result.constructor-impl(object != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null);
        }
        catch (Throwable bl) {
            $this$toLogcatHeader_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        matchResult = $this$toLogcatHeader_u24lambda_u248;
        Integer n = (Integer)(Result.isFailure-impl((Object)matchResult) ? null : matchResult);
        int tid = n != null ? n : 0;
        String levelLetter = LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "level");
        LogLevel logLevel = LogLevel.Companion.getByLetter(levelLetter);
        if (logLevel == null) {
            throw new IllegalArgumentException("Invalid log level: " + levelLetter);
        }
        LogLevel level = logLevel;
        String tag = ((Object)StringsKt.trim((CharSequence)LogcatFileParserKt.access$getGroup($this$toLogcatHeader, "tag"))).toString();
        String processName = "pid-" + pid;
        Instant timestamp = Instant.from(ZonedDateTime.of(year, month, day, hour, minute, second, nanos, this.zoneId));
        Intrinsics.checkNotNull((Object)timestamp);
        return new LogcatHeader(level, pid, tid, processName, processName, tag, timestamp);
    }

    private final int creationYear(Path $this$creationYear) {
        return Files.readAttributes($this$creationYear, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant().atZone(this.zoneId).getYear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/files/LogcatFileParser$Companion;", "", "<init>", "()V", "SYSTEM_LOG_PREFIX", "", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

